// -*- C++ -*-

/* sheet_logsignals.cc
 * 
 * Copyright (C) 2000 GtkExtra-- Development Team  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "sheet_logsignals.h"

Sheet_LogSignals::Sheet_LogSignals(gint rows, gint columns, const nstring& title)
 : GtkExtra::Sheet(rows, columns, title)
{
  resize_range.connect(slot(this, &Sheet_LogSignals::on_resize_range));
  move_range.connect(slot(this, &Sheet_LogSignals::on_move_range));
  traverse.connect(slot(this, &Sheet_LogSignals::on_traverse));
}

Sheet_LogSignals::~Sheet_LogSignals()
{
}

void 
Sheet_LogSignals::on_resize_range(GtkSheetRange *old_range, GtkSheetRange *new_range)
{
  printf("OLD SELECTION: %d %d %d %d\n",old_range->row0, old_range->col0,
                                    old_range->rowi, old_range->coli);
  printf("NEW SELECTION: %d %d %d %d\n",new_range->row0, new_range->col0,
                                    new_range->rowi, new_range->coli);
}

void 
Sheet_LogSignals::on_move_range(GtkSheetRange *old_range, GtkSheetRange *new_range)
{
  printf("OLD SELECTION: %d %d %d %d\n",old_range->row0, old_range->col0,
                                    old_range->rowi, old_range->coli);
  printf("NEW SELECTION: %d %d %d %d\n",new_range->row0, new_range->col0,
                                    new_range->rowi, new_range->coli);
}

gint
Sheet_LogSignals::on_traverse(gint row, gint col, gint *new_row, gint *new_col)
{
  printf("TRAVERSE: %d %d %d %d\n",row,col,*new_row,*new_col);
  return TRUE;
}

