// -*- C++ -*-

/* window_test_polar.cc
 * 
 * Copyright (C) 2000 GtkExtra-- Development Team  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "window_test_polar.h"
#include <math.h>

Window_Test_Polar::Window_Test_Polar()
: m_VBox(false, 0),
  m_PlotCanvas(GTK_PLOT_LETTER_W, GTK_PLOT_LETTER_H, 1),
  m_Plot1(0, .5, .25),
  m_Button1("1"),
  m_vecDataSets(5)
{ 
  set_title("GtkExtra::PlotPolar Demo");
  set_usize(550, 650);
  m_VBox.set_border_width(0);
  add(m_VBox);

  m_ScrolledWindow.set_border_width(0);
  m_ScrolledWindow.set_policy(GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
  m_VBox.pack_start(m_ScrolledWindow, true, true, 0);
  
  m_PlotCanvas.set_flags(GTK_PLOT_CANVAS_DND_FLAGS);
  m_ScrolledWindow.add_with_viewport(m_PlotCanvas);

  //Plot 1:
  m_PlotCanvas.set_active_plot(m_Plot1);
 

  m_PlotCanvas.add_plot(m_Plot1, .15, .06);

  build_example1(m_Plot1);
  m_Plot1.show();
 
  //Buttons:
  m_Button1.set_usize(20, 20); 
  m_PlotCanvas.put(m_Button1, 0, 0);
   
  m_Button1.toggled.connect(bind<gint>(slot(this, &Window_Test_Polar::on_Button_toggled), 1));

  show_all();
  
  // (show the window before printing)
  m_PlotCanvas.export_ps("demopolar.ps", GTK_PLOT_PORTRAIT, false, GTK_PLOT_LETTER);
}

Window_Test_Polar::~Window_Test_Polar()
{
}

gint Window_Test_Polar::delete_event_impl(GdkEventAny*)
{ 
  Gtk::Main::quit();
  return 0; 
}

void
Window_Test_Polar::build_example1(GtkExtra::Plot& refPlot)
{
  static gdouble pr[]={0.2, 0.34, 0.45, 0.6, 0.75, 0.81};
  static gdouble pangle[]={15., 20., 43., 67., 84., 106.};

  Gdk_Colormap colormap = refPlot.get_colormap();

  m_vecDataSets[0] = new GtkExtra::PlotData();
  refPlot.add_data(m_vecDataSets[0]);
  m_vecDataSets[0]->set_points(pr, pangle, 0, 0, 6);
 
  Gdk_Color color("red");
  Gdk_Colormap::get_system().alloc(color); 

  m_vecDataSets[0]->set_symbol(GTK_PLOT_SYMBOL_DIAMOND,
			GTK_PLOT_SYMBOL_OPAQUE,
			10, 2, color, color);
  m_vecDataSets[0]->set_line_attributes(GTK_PLOT_LINE_SOLID,
				1, color);

  m_vecDataSets[0]->set_legend("Example");
  m_vecDataSets[0]->show();
}




//iButtonNumber parameter is from a bind<>:
void
Window_Test_Polar::on_Button_toggled(gint iButtonNumber)
{
  //Select the apropriate plot:
  //Activate the appropriate grid:
  //This doesn't seem to do anything. Maybe 'active' != 'selected'.
  //However, it doesn't work in the C version either, so this is a faithful transaltion.
  GtkExtra::Plot* pPlot = 0;
  if(iButtonNumber == 1)
  {
    pPlot = &m_Plot1;
  }

  if(pPlot)
  {
    m_PlotCanvas.set_active_plot(*pPlot);
  }
}

void
Window_Test_Polar::activate_plot()
{
  GtkExtra::Plot* pPlot = 0;
  Gtk::ToggleButton* pButton = 0;
  Gtk::ToggleButton* pButtonOther = 0;
  
  pPlot = &m_Plot1;
  pButton = &m_Button1;
  
  if(pPlot && pButton)
  {
    m_PlotCanvas.set_active_plot(*pPlot);
    if(!(pButton->get_active())) pButton->set_active(true);
    
    pButton->queue_draw();
  }
}


