/******************************************************************************/
/* smooth_gtk1_misc.c - Misc Functions for GTK1 Engine                        */
/******************************************************************************/
/* Smooth Theme Engine                                                        */
/* Copyright (C) 2002-2004 Andrew Johnson                                     */
/*                                                                            */
/* This library is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU Lesser General Public                 */
/* License as published by the Free Software Foundation; either               */
/* version 2.1 of the License, or (at your option) any later version.         */
/*                                                                            */
/* This library is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          */
/* Lesser General Public License for more details.                            */
/*                                                                            */
/* You should have received a copy of the GNU Lesser General Public           */
/* License along with this library; if not, write to the Free Software        */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  */
/*                                                                            */
/* Author(s): Andrew Johnson <ajgenius@ajgenius.us>                           */
/******************************************************************************/
/* Portions Based on GTK+                                                     */
/*   Peter Mattis <petm@xcf.berkeley.edu>                                     */
/*   Spencer Kimball <spencer@xcf.berkeley.edu>                               */
/*   Josh MacDonald <jmacd@xcf.berkeley.edu>                                  */
/*                                                                            */
/* Portions Based on the EnGradient Engine                                    */
/*   Andrew Cattau                                                            */
/*                                                                            */
/* Portions Based on the Metal Engine                                         */
/*  Randy Gordon <randy@integrand.com>                                        */
/*  Owen Taylor <otaylor@redhat.com>                                          */
/*                                                                            */
/* Portions Based on the ThinIce Engine                                       */
/*   Tim Gerla <timg@rrv.net>                                                 */
/*   Tomas Ögren <stric@ing.umu.se>                                           */
/*   Richard Hult <rhult@codefactory.se>                                      */
/*                                                                            */
/* Portions Based on the Wonderland Engine                                    */
/*   Garrett LeSage                                                           */
/*   Alexander Larsson                                                        */
/*   Owen Taylor <otaylor@redhat.com>                                         */
/*                                                                            */
/* Portions Based on the XFCE Engine                                          */
/*   Olivier Fourdan <fourdan@xfce.org>                                       */
/*                                                                            */
/* Portions Based on the Xenophilia Engine                                    */
/*   Johan Hanson <misagon@bahnhof.se>                                        */
/******************************************************************************/
#include "smooth_gtk1_engine.h"
#include "smooth_gtk1_drawing.h"
#include "smooth_gtk1_misc.h"
#include "smooth_gtk1_rc.h"

/* Widget Type Lookups/Macros */
gboolean
widget_is_a (GtkWidget * widget, gchar * type_name)
{
  gboolean result = FALSE;

  if ((widget))
    {
      GtkType tmp = gtk_type_from_name (type_name);
      if (tmp)
	result = gtk_type_is_a(GTK_WIDGET_TYPE(widget), tmp);
    }

  return result;
}

gboolean
is_toolbar_item (GtkWidget * widget)
{
  gboolean result = FALSE;

  if ((widget) && (widget->parent))
  {
    if ((IS_BONOBO_TOOLBAR (widget->parent))
	|| (IS_BONOBO_DOCK_ITEM (widget->parent))
	|| (IS_EGG_TOOLBAR (widget->parent))
	|| (GTK_IS_TOOLBAR (widget->parent))
	|| (GTK_IS_HANDLE_BOX (widget->parent)))
    {
      result = TRUE;
    }
    else
      result = is_toolbar_item (widget->parent);
  }
  return result;
}

gboolean
is_panel_widget_item (GtkWidget * widget)
{
  gboolean result = FALSE;

  if ((widget) && (widget->parent))
    {
      if (IS_PANEL_WIDGET (widget->parent))
	result = TRUE;
      else
	result = is_panel_widget_item (widget->parent);
    }
  return result;
}

gboolean
is_combo (GtkWidget * widget)
{
  gboolean result = FALSE;
 
  if (widget)
    {
      if (IS_COMBO (widget))
	result = TRUE;
      else
	result = is_combo (widget->parent);
    }
  return result;
}
 
gboolean
is_in_combo_box (GtkWidget * widget)
{
  return is_combo (widget);
}

/* Misc Functions */
GdkBitmap *
arc_clip_mask(gint width,
	      gint height)
{
  GdkBitmap *result;
  GdkGC *gc;
  GdkColor color;

  result = (GdkBitmap *)gdk_pixmap_new(NULL, width, height, 1);
  gc = gdk_gc_new(result);
	
  color.pixel = 0;
  gdk_gc_set_foreground(gc, &color);

  gdk_draw_rectangle(result, gc, TRUE, 0, 0, width, height);
  gdk_draw_rectangle(result, gc, FALSE, 0, 0, width, height);

  color.pixel = 1;
  gdk_gc_set_foreground(gc, &color);

  gdk_draw_arc(result, gc, TRUE, 0, 0, width + 1, height + 1, 0, 360*64);
  gdk_draw_arc(result, gc, FALSE, 0, 0, width, height, 0, 360*64);

  gdk_gc_destroy(gc);

  return result;
}

/* The following is based on a similar routine found in most 
 * GTK2 engines, I have no idea which one came up with it first...
 */
gboolean
sanitize_parameters(GtkStyle * style,
  	            GdkWindow * window,
	            gint * width,
	            gint * height)
{
  if (!style) return FALSE;
  if (!window) return FALSE;

  if ((width) && (height)) {
    if ((*width == -1) && (*height == -1))
      gdk_window_get_size (window, width, height);
    else if (*width == -1)
      gdk_window_get_size(window, width, NULL);
    else if (*height == -1)
      gdk_window_get_size (window, NULL, height);  
  }
  return TRUE;  
}

GtkWidget *
get_notebook_page(GtkWidget * widget)
{
  g_return_val_if_fail(GTK_IS_WIDGET(widget), NULL);

  while (widget && widget->parent && !gtk_type_is_a(GTK_WIDGET_TYPE(widget->parent), GTK_TYPE_NOTEBOOK))
    widget = widget->parent;

  if (!(widget && widget->parent && gtk_type_is_a(GTK_WIDGET_TYPE(widget->parent), GTK_TYPE_NOTEBOOK)))
    return NULL;
      

  return widget;
}

GtkWidget *
get_tab_label(GtkWidget *page, GtkWidget * widget)
{
  g_return_val_if_fail(GTK_IS_WIDGET(widget), NULL);

  widget = gtk_notebook_get_menu_label(GTK_NOTEBOOK(page->parent), page);
  if (!(widget)) 
     widget = gtk_notebook_get_tab_label(GTK_NOTEBOOK(page->parent), page);
     
  return widget;
}

gboolean 
widget_is_tab_label(GtkWidget *page, GtkWidget * widget)
{
  GtkWidget * real_widget = widget;
  g_return_val_if_fail(GTK_IS_WIDGET(widget), FALSE);

  widget = gtk_notebook_get_menu_label(GTK_NOTEBOOK(page->parent), page);
  if (!(widget)) 
     widget = gtk_notebook_get_tab_label(GTK_NOTEBOOK(page->parent), page);
     
  if ((real_widget) && (widget) && (real_widget != widget) && (!(gtk_widget_is_ancestor(real_widget, widget))))
    return FALSE;

  return TRUE;
}

gboolean 
tab_label_is_current_page(GtkWidget *page, GtkWidget * widget)
{
  gint current_num = 0;
  GtkWidget *current_page = NULL; 
  GtkWidget *current_label = NULL;

  current_num = gtk_notebook_get_current_page(GTK_NOTEBOOK(page->parent));
  if (current_num ==-1)
    return FALSE;

  current_page = gtk_notebook_get_nth_page(GTK_NOTEBOOK(page->parent), current_num); 

  if (!(current_page))
    return FALSE;

  current_label = gtk_notebook_get_tab_label(GTK_NOTEBOOK(page->parent), current_page);

  if ((current_label == NULL) || ((current_label != widget) && (!gtk_widget_is_ancestor(widget, current_label))))
    return FALSE;

  return TRUE;
}

/* This function is a home-grown (probably flawed) function 
 * inspired by the metal, ThinIce, & Wonderland GTK2 engines
 */
void
reverse_engineer_arrow_box (GtkWidget    *widget,
                            const gchar * detail,
			    GtkArrowType  arrow_type,
			    gint         *x,
			    gint         *y,
			    gint         *width,
			    gint         *height)
{
  if (CHECK_DETAIL(detail, "hscrollbar") || CHECK_DETAIL(detail, "vscrollbar"))
    {
      *x += 2;
      *y += 2;
      *width -= 4;
      *height -= 4;
    }
  else if (CHECK_DETAIL(detail, "menuitem"))
    {
      *width += 2;
      *height += 2;
      *x -= 1;
    }
  else if ((is_in_combo_box (widget) || 
               IS_SPIN_BUTTON (widget)) && 
             ENTRY_BUTTON_EMBED(widget->style))
    {
      GtkStyle *style = widget->style;
      smooth_part_style *part = smooth_button_part(style, FALSE);
      gint thick = 2;

      thick = EDGE_LINE_THICKNESS(style, part);

      *x -= (gint)thick/2;
      *y += (gint)thick/2;
    }
  else if (CHECK_DETAIL(detail, "arrow"))
    {
      *width += 2;
      *height += 2;
      *x -= 1;
      *y -= 1;
    }
}
