/* $Id: ColorByAge.cpp,v 1.4 2005/04/05 11:32:54 ellson Exp $ $Revision: 1.4 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#include "Dynagraph.h"
#include <sstream>
#include "breakList.h"
#include "ColorByAge.h"

// an apology: this uses string attributes, which are supposed to be confined to 
// stringsIn.cpp and stringsOut.cpp

using namespace std;
void rotateColor(vector<DString> colors, StrAttrs2 &attrs2) {
  DString color = attrs2["color"];
  if(color.empty())
    attrs2.put("color",colors[0]);
  else for(size_t i=0; i<colors.size()-1; ++i)
    if(color==colors[i]) {
      attrs2.put("color",colors[i+1]);
      break;
    }
}
void ColorByAge::Process(ChangeQueue &Q) {
    StrAttrs::iterator ai = gd<StrAttrs>(Q.current).find("agecolors");
    if(ai==gd<StrAttrs>(Q.current).end())
        return;
    vector<DString> colors;
    breakList(ai->second,colors);
    if(colors.size()==0)
        return;
    for(Layout::node_iter ni = Q.current->nodes().begin(); ni!=Q.current->nodes().end(); ++ni) 
        rotateColor(colors,gd<StrAttrs2>(*ni));
    for(Layout::graphedge_iter ei = Q.current->edges().begin(); ei!=Q.current->edges().end(); ++ei) 
        rotateColor(colors,gd<StrAttrs2>(*ei));
}
