/* gradio.h
 * Contains prototypes and some useful constant definition
 */

/* (c) 1998-2000 by Keith Wesolowski (wesolows@foobazco.org)

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. 

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. 

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include <gtk/gtk.h>
#include <linux/version.h>
#include <stdio.h>

/* Make sure we have the right version code */
/* Archaic (2.0.x) kernels don't have KERNEL_VERSION_CODE, so
 * the value is hard-coded (2.1.106).
 */
#if (LINUX_VERSION_CODE < 0x02016a)
#error "You need kernel 2.1.106+ or 2.2.x"
#endif

#define VERSION "1.0.1"

#define GR_TUNER_UP 0
#define GR_TUNER_DOWN 1

#define GR_VOL_UP 2
#define GR_VOL_DOWN 3

#define GR_TUNER_STEP_LARGE 200
#define GR_TUNER_STEP_SMALL 10

#ifndef WIDE_FREQ
#define GR_FREQ_MIN 87900
#define GR_FREQ_MAX 108100
#else
#define GR_FREQ_MIN 76100
#define GR_FREQ_MAX 108900
#endif

#define GR_FREQ_DEFAULT 100100
#define GR_VOL_MIN 0
#define GR_VOL_MAX 10
#define GR_VOL_DEFAULT 4

typedef struct
{
    char dev_name[128];
    int fd;
    int freq;
    int freq_max;
    int freq_min;
    int vol;
    int muted;
    int mem[8];
    int power;
    int memset;
    int tuned;
} radio_status;

void gradio_get_interface (void);

int gradio_init (int argc, char **argv);
void gradio_usage (char *name);

GtkWidget *gradio_get_volume_box (GtkWidget *w);
GtkWidget *gradio_get_tuner_box (GtkWidget *w);
GtkWidget *gradio_get_memory_box (GtkWidget *w);
GtkWidget *gradio_get_control_box (GtkWidget *w);
GtkWidget *gradio_get_display (GtkWidget *w);
GtkWidget *xpm_label_box_d (GtkWidget *parent, gchar **xpm_d, 
			    gchar *label_text);

gint gradio_delete_event_cb (GtkWidget *w, gpointer *data);
void gradio_destroy_cb (GtkWidget *w, gpointer *data);
void gradio_vol_cb (GtkWidget *w, gpointer *data);
void gradio_tuner_cb (GtkWidget *w, GdkEventButton *data);
void gradio_power_cb (GtkWidget *w, gpointer *data);
void gradio_mute_cb (GtkWidget *w, gpointer *data);
void gradio_memory_cb (GtkWidget *w, GdkEventButton *data);
gint gradio_button_press_cb (GtkWidget *w, GdkEvent *data);
void gradio_setfreq_cb (GtkWidget *w, gpointer *data);
void gradio_help_cb (GtkWidget *w, gpointer *data);
void gradio_about_cb (GtkWidget *w, gpointer *data);
void gradio_freq_from_value_cb (GtkWidget *w, gpointer *data);
void gradio_close_dialog_cb (GtkWidget *w, gpointer *data);

double gradio_get_freq_fact (void);
int gradio_setfreq (int fr);
int gradio_setvol (int lvl);
void gradio_mute (int state);

void gradio_save_rcfile (void);

void gradio_pixmap_inits (GtkWidget *w);
void gradio_set_display_from_status (void);
