/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*

  sun.c: Widgets and functions to display the position of the sun.

  Copyright (C)  2001-2003  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#include <gnome.h>
#include <math.h>
#include "defaults.h"
#include "satlog.h"
#include "util.h"
#include "qth.h"
#include "sun.h"

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#define SUN_X_PAD 3
#define SUN_Y_PAD 0

GtkWidget *sunframe,*sunbox,*sunaz,*sunel;
/* fix this, thank you */


extern qth_struc qth;

gfloat sun_az,sun_el;
gchar *azs,*els;


void FindSun(gdouble);


GtkWidget *sun_create()
{

	azs = g_malloc (7);
	els = g_malloc (7);

	sunaz = gtk_label_new ("000.00");
	sunel = gtk_label_new ("+00.00");
	gtk_misc_set_alignment (GTK_MISC (sunaz), 1.0f, 0.0f);
	gtk_misc_set_alignment (GTK_MISC (sunel), 1.0f, 0.0f);

	/* the table to contain the labels */
	sunbox = gtk_table_new (2, 2, TRUE);
	gtk_table_attach (GTK_TABLE (sunbox), gtk_label_new (_("Az:")),
			  0, 1, 0, 1, 
			  GTK_FILL | GTK_EXPAND,
			  GTK_FILL | GTK_EXPAND,
			  SUN_X_PAD, SUN_Y_PAD );
	gtk_table_attach (GTK_TABLE (sunbox), gtk_label_new (_("El:")),
			  0, 1, 1, 2,
			  GTK_FILL | GTK_EXPAND,
			  GTK_FILL | GTK_EXPAND,
			  SUN_X_PAD, SUN_Y_PAD );
	gtk_table_attach (GTK_TABLE (sunbox), GTK_WIDGET (sunaz),
			  1, 2, 0, 1,
			  GTK_FILL | GTK_EXPAND,
			  GTK_FILL | GTK_EXPAND,
			  SUN_X_PAD, SUN_Y_PAD );
	gtk_table_attach (GTK_TABLE (sunbox), GTK_WIDGET (sunel),
			  1, 2, 1, 2,
			  GTK_FILL | GTK_EXPAND,
			  GTK_FILL | GTK_EXPAND,
			  SUN_X_PAD, SUN_Y_PAD );
	/* add a nice frame */
	sunframe = gtk_frame_new (_(" Sun "));
	gtk_frame_set_label_align (GTK_FRAME (sunframe), 0.5, 0.5);
	gtk_frame_set_shadow_type (GTK_FRAME (sunframe),
				   GTK_SHADOW_ETCHED_OUT);
	gtk_container_add (GTK_CONTAINER (sunframe),
			   GTK_WIDGET (sunbox) );

	return sunframe;
}

void sun_update()
{
	FindSun (CurrentDaynum ());
	g_snprintf (azs, 7, "%6.2f", sun_az);
	g_snprintf (els, 7, ( sun_el > 0 ) ? "+%5.2f" : "%6.2f", sun_el);
	gtk_label_set_text (GTK_LABEL (sunaz), azs);
	gtk_label_set_text (GTK_LABEL (sunel), els);
}



void FindSun(gdouble daynum)
{
	/* Striped down version of Predict's FindSun function.
	   Only calculates the position and not the visibility
	   conditions. The visibility conditions are calculated
	   in the satellite tracking routine.
	 */

	gdouble	c, ms, t1, t2, t3, ew, e, n, si, co, ra,
		lh, gm, de, se, gs, el, az, yr, dc, gh;

	/* Calculate the year from "daynum" */
	t1 = (gdouble)(glong)(daynum-39410.0);
	t2 = floor( (t1+32044.75)/36524.25 );
	t2 += t1-t2/4.0+1486.0;
	yr = 2084.0+floor( (t2-122.1)/365.25 );

	gm = 24.0*(daynum-floor(daynum));
	c = ( (daynum+gm/24.0)/365.2422-0.010452395 );
	ms = TP*(c-floor(c));
	t1 = ms;
	t2 = 0.016718;

	do
	{
		t3 = t1-t2*sin(t1)-ms;
		t1 = t1-t3/(1.0-t2*cos(t1));
	}
	while ( fabs(t3) > 1.0e-6 );

	t1 = 1.01686*tan(t1/2.0);
	ew = 2.0*atan(t1)+4.932237686;
	si = S1*sin(ew);
	co = sqrt(1.0-(si*si));
	dc = atan2(si,co);
	si = sin(ew)*C1;
	co = cos(ew);
	ra = atan2(si,co);

	if ( ra < 0.0 )
		ra += TP;

	t1 = yr-1.0;
	de = floor(365.25*(t1-1980.0))-floor(t1/100.0)+floor(t1/400.0)+381.0;
	t1 = (de+29218.5)/36525.0;
	t1 = 6.6460656+t1*(2400.051262+t1*2.581e-5);
	se = t1-24.0*(yr-1900.0);
	t1 = (se+0.0657098*(daynum-de)+gm*1.002738)/24.0;
	gs = 24.0*(t1-floor(t1));
	t1 = gs/24.0-ra/TP;
	gh = TP*(t1-floor(t1));

	n = qth.lat*DEG2RAD;  /* North latitude of tracking position */
	e = -qth.lon*DEG2RAD; /* East longitude of tracking position */

	lh = gh+e;
	si = cos(lh)*cos(dc)*cos(n)+sin(dc)*sin(n);
	co = sqrt(1.0-(si*si));
	el = atan2(si,co);

	si = -sin(lh)*cos(dc)*cos(n);
	co = sin(dc)-sin(n)*sin(el);
	az = atan2(si,co);

	if ( az < 0.0 )
		az += TP;
	

	sun_az = az/DEG2RAD;
	sun_el = el/DEG2RAD;

}
