/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
    newuser-tle.c: TLE file druid page.

  Copyright (C)   2002-2003  Alexandru Csete.

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#include <gnome.h>
#include "defaults.h"
#include "newuser-tle.h"

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif


extern GdkColor mainbg,logobg;   /* in newuser.c */


GtkWidget *newuser_tle_create (void)
{
        GtkWidget *page;
	GdkImlibImage *img;               /* logo */
	gchar *path;


	/* initialize colors */
	mainbg.red   = (gushort)0xFFFF;
	mainbg.green = (gushort)0xFFFF;
	mainbg.blue  = (gushort)0xFFFF;
	logobg.red   = (gushort)6425;
	logobg.green = (gushort)6425;
	logobg.blue  = (gushort)28784;

	path = g_strconcat (PACKAGE_PIXMAPS_DIR, G_DIR_SEPARATOR_S,
			    "icons", G_DIR_SEPARATOR_S, "gpredict-icon.png",NULL);
	img = gdk_imlib_load_image (path);

	page = gnome_druid_page_standard_new_with_vals (_("Satellite Data"), img);
	gnome_druid_page_standard_set_logo_bg_color (GNOME_DRUID_PAGE_STANDARD (page),
						     &logobg );
	gtk_container_set_border_width( GTK_CONTAINER ((GNOME_DRUID_PAGE_STANDARD (page))->vbox), 10 );

	
	g_free (path);
	gdk_imlib_destroy_image (img);


	return page;
}


void newuser_tle_finish (void)
{
}


void newuser_tle_cancel (void)
{
}
