#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "gpc_app.h"
#include "gpc_utils.h"

#include "gpc_film_infos.h"
#include "gpc_film_infos_intf.h"
#include "support.h"


gint      gpc_film_keyword_selection;
gboolean  gpc_film_updating;



 /*
 **
 ** gpc_film_infos private callbacks 
 **
 */
 
void
gpc_film_dialog_save_options (void);

void 
kind_validate_callback (gint reply, gpointer data);

void 
film_maker_validate_callback (gint reply, gpointer data);

void 
film_model_validate_callback (gint reply, gpointer data);

void 
camera_maker_validate_callback (gint reply, gpointer data);

void 
camera_model_validate_callback (gint reply, gpointer data);

void 
film_keywords_validate_callback (gint reply, gpointer data);

void
swap_film_table_visibility (gchar *tablename, gchar *pixmapname);


 /*
 **
 ** User functions
 **
 */

void
gpc_film_dialog_update (GpcFilmInfos *infos)
{
  gchar *id;
  gint length;
  guint pos;
  GtkText *description;

  GList *keywords;
  guint elements;
  guint index;
  gchar *fields[2];

  if (!gpc_film_dialog)
    return;
  gpc_film_updating = TRUE;
  if (!gpc_film_kinds)
    gpc_film_kinds = gpc_app_get_keywords (gpc_connection, "GPC_FILM_KIND");
  gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_film_dialog, "kind_combo")), gpc_film_kinds);
  if (!gpc_film_makers)
    gpc_film_makers = gpc_app_get_keywords (gpc_connection, "GPC_FILM_MAKER");
  gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_film_dialog, "film_maker_combo")), gpc_film_makers);
  if (!gpc_camera_makers)
    gpc_camera_makers = gpc_app_get_keywords (gpc_connection, "GPC_CAMERA_MAKER");
  gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_film_dialog, "camera_maker_combo")), gpc_camera_makers);
  if (!gpc_keywords)
    gpc_keywords = gpc_app_get_keywords (gpc_connection, "GPC_KEY");
  gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_film_dialog, "keywords_combo")), gpc_keywords);
  if (!infos) {
    gtk_label_set_text (GTK_LABEL (lookup_widget (gpc_film_dialog, "id_label")), NULL);
    gtk_label_set_text (GTK_LABEL (lookup_widget (gpc_film_dialog, "pathname_label")), NULL);
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "kind_combo_entry")), NULL);
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "number_entry")), NULL);
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "film_maker_combo_entry")), NULL);
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "film_model_combo_entry")), NULL);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_film_dialog, "iso_spinbutton")), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_film_dialog, "nb_photos_spinbutton")), 0);
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "camera_maker_combo_entry")), NULL);
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "camera_model_combo_entry")), NULL);
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "period_entry")), NULL);
    length = strlen (gpc_film_get_description (infos));
    description = GTK_TEXT (lookup_widget (gpc_film_dialog, "description_text"));
    pos = gtk_text_get_point (description);
    if (pos > 0)
      gtk_text_backward_delete (description, pos);
    pos = gtk_text_get_length (description);
    if (pos > 0)
      gtk_text_forward_delete (description, pos);
    gtk_editable_delete_text (GTK_EDITABLE (lookup_widget (gpc_film_dialog, "keywords_combo_entry")), 0, -1);
    gtk_clist_clear (GTK_CLIST (lookup_widget (gpc_film_dialog, "keywords_clist")));
  }
  else {
    id = g_strdup_printf ("%d", gpc_film_get_id (infos));
    gtk_label_set_text (GTK_LABEL (lookup_widget (gpc_film_dialog, "id_label")), id);
    g_free (id);
    gtk_label_set_text (GTK_LABEL (lookup_widget (gpc_film_dialog, "pathname_label")),
                        gpc_film_get_pathname (infos));
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "kind_combo_entry")),
                        gpc_film_get_kind (infos));
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "number_entry")),
                        gpc_film_get_number (infos));
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "film_maker_combo_entry")),
                        gpc_film_get_maker (infos));
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "film_model_combo_entry")),
                        gpc_film_get_model (infos));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_film_dialog, "iso_spinbutton")),
                              (gfloat) gpc_film_get_iso (infos));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_film_dialog, "nb_photos_spinbutton")),
                              (gfloat) gpc_film_get_size (infos));
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "camera_maker_combo_entry")),
                        gpc_film_get_camera_maker (infos));
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "camera_model_combo_entry")),
                        gpc_film_get_camera_model (infos));
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "period_entry")),
                        gpc_film_get_period (infos));
    length = strlen (gpc_film_get_description (infos));
    description = GTK_TEXT (lookup_widget (gpc_film_dialog, "description_text"));
    pos = gtk_text_get_point (description);
    if (pos > 0)
      gtk_text_backward_delete (description, pos);
    pos = gtk_text_get_length (description);
    if (pos > 0)
      gtk_text_forward_delete (description, pos);
    gtk_text_insert (description, NULL, NULL, NULL, gpc_film_get_description (infos), length);
    gtk_editable_delete_text (GTK_EDITABLE (lookup_widget (gpc_film_dialog, "keywords_combo_entry")), 0, -1);
    gtk_clist_clear (GTK_CLIST (lookup_widget (gpc_film_dialog, "keywords_clist")));
    keywords = gpc_film_get_keywords (infos);
    if (keywords) {
      elements = g_list_length (keywords);
      for (index = 0; index < elements; index++) {
        fields[0] = g_strdup ((gchar *) g_list_nth_data (keywords, index));
        fields[1] = NULL;
        gtk_clist_append (GTK_CLIST (lookup_widget (gpc_film_dialog, "keywords_clist")), fields);
      }
    }
  }
  gpc_film_updating = FALSE;
  gpc_film_modified = FALSE;
}


 /*
 **
 ** gpc_film dialog callbacks
 **
 */

void
gpc_film_dialog_save_options (void)
{
  gint x;
  gint y;

  if (gpc_film_dialog->window) {
    gnome_config_set_bool ("/gphotocoll/film_infos/classification", GTK_WIDGET_VISIBLE (lookup_widget (gpc_film_dialog, "classification_table")));
    gnome_config_set_bool ("/gphotocoll/film_infos/film", GTK_WIDGET_VISIBLE (lookup_widget (gpc_film_dialog, "film_table")));
    gnome_config_set_bool ("/gphotocoll/film_infos/general", GTK_WIDGET_VISIBLE (lookup_widget (gpc_film_dialog, "general_table")));
    gnome_config_set_bool ("/gphotocoll/film_infos/keywords", GTK_WIDGET_VISIBLE (lookup_widget (gpc_film_dialog, "keywords_table")));
    gdk_window_get_root_origin (GTK_WIDGET (gpc_film_dialog)->window, &x, &y);
    gnome_config_set_int ("/gphotocoll/film_infos/x", x);
    gnome_config_set_int ("/gphotocoll/film_infos/y", y);
  }
  gnome_config_sync ();
}


void
on_gpc_film_dialog_realize             (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gpc_film_updating = FALSE;
}


void
on_gpc_film_dialog_show                (GtkWidget       *widget,
                                        gpointer         user_data)
{
  if (gnome_config_get_bool ("/gphotocoll/film_infos/classification=false"))
    swap_film_table_visibility ("classification_table", "classification_pixmap");
  if (gnome_config_get_bool ("/gphotocoll/film_infos/film=false"))
    swap_film_table_visibility ("film_table", "film_pixmap");
  if (gnome_config_get_bool ("/gphotocoll/film_infos/general=false"))
    swap_film_table_visibility ("general_table", "general_pixmap");
  if (!gnome_config_get_bool ("/gphotocoll/film_infos/keywords=false"))
    swap_film_table_visibility ("keywords_table", "keywords_pixmap");
  gdk_window_move (GTK_WIDGET (gpc_film_dialog)->window, 
                   gnome_config_get_int ("/gphotocoll/film_infos/x=550"),
                   gnome_config_get_int ("/gphotocoll/film_infos/y=20"));
}


gboolean
on_gpc_film_dialog_delete_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gpc_film_dialog_save_options ();
  gpc_film_dialog = NULL;
  return FALSE;
}


void
on_kind_combo_entry_changed            (GtkEditable     *editable,
                                        gpointer         user_data)
{
  if (!gpc_film_infos || gpc_film_updating)
    return;
  gpc_film_set_kind (gpc_film_infos, gtk_entry_get_text (GTK_ENTRY (editable)));
  gpc_film_modified = TRUE;
}


void
kind_validate_callback (gint reply, gpointer data)
{
  switch (reply) {
    case  0 : gpc_film_kinds = g_list_insert_sorted (gpc_film_kinds, (gchar *) data, (GCompareFunc) g_strcasecmp);
              gpc_added_film_kinds = g_list_insert_sorted (gpc_added_film_kinds, g_strdup ((gchar *) data), (GCompareFunc) g_strcasecmp);
              gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_film_dialog, "kind_combo")), gpc_film_kinds);
              gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "kind_combo_entry")), (gchar *) data);
              break;
    default : gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "kind_combo_entry")), "");
              g_free (data);
  }
}


gboolean
on_kind_combo_entry_focus_out_event    (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
  gchar      *value;
  gchar      *message;

  if (!gpc_film_infos || gpc_film_updating)
    return FALSE;
  value = g_strdup (gtk_entry_get_text (GTK_ENTRY (widget)));
  if ((strlen (value) > 0) && !gpc_app_check_keyword (gpc_connection, gpc_film_kinds, value, "GPC_FILM_KIND")) {
    if (gpc_confirm_insert_refs) {
      message = g_strdup_printf (_("Insert value '%s' in film kind's reference table ?"), value);
      gnome_app_ok_cancel_modal (GNOME_APP (gpc_app), message, kind_validate_callback, value);
      g_free (message);
    }
    else
      kind_validate_callback (0, value);
  }
  return FALSE;
}


void
on_film_number_entry_changed           (GtkEditable     *editable,
                                        gpointer         user_data)
{
  if (!gpc_film_infos || gpc_film_updating)
    return;
  gpc_film_set_number (gpc_film_infos, gtk_entry_get_text (GTK_ENTRY (editable)));
  if (films_clist)
    gtk_clist_set_text (films_clist, gpc_film_selection, 1, g_strdup (gpc_film_get_number (gpc_film_infos)));
  gpc_film_modified = TRUE;
}


void
on_film_maker_combo_entry_changed      (GtkEditable     *editable,
                                        gpointer         user_data)
{
  if (!gpc_film_infos || gpc_film_updating)
    return;
  gpc_film_set_maker (gpc_film_infos, gtk_entry_get_text (GTK_ENTRY (editable)));
  if (gpc_film_maker_codes) {
    g_list_foreach (gpc_film_maker_codes, (GFunc) g_free, NULL);
    g_list_free (gpc_film_maker_codes);
    gpc_film_maker_codes = NULL;
  }
  gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "film_model_combo_entry")), "");
  gpc_film_modified = TRUE;
}


void
film_maker_validate_callback (gint reply, gpointer data)
{
  switch (reply) {
    case  0 : gpc_film_makers = g_list_insert_sorted (gpc_film_makers, (gchar *) data, (GCompareFunc) g_strcasecmp);
              gpc_added_film_makers = g_list_insert_sorted (gpc_added_film_makers, g_strdup ((gchar *) data), (GCompareFunc) g_strcasecmp);
              gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_film_dialog, "film_maker_combo")), gpc_film_makers);
              gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "film_maker_combo_entry")), (gchar *) data);
              break;
    default : gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "film_maker_combo_entry")), "");
              g_free (data);
  }
}


gboolean
on_film_maker_combo_entry_focus_out_event (GtkWidget       *widget,
                                           GdkEventFocus   *event,
                                           gpointer         user_data)
{
  gchar      *value;
  gchar      *message;

  if (!gpc_film_infos || gpc_film_updating)
    return FALSE;
  value = g_strdup (gtk_entry_get_text (GTK_ENTRY (widget)));
  if ((strlen (value) > 0) && !gpc_app_check_keyword (gpc_connection, gpc_film_makers, value, "GPC_FILM_MAKER")) {
    if (gpc_confirm_insert_refs) {
      message = g_strdup_printf (_("Insert value '%s' in film maker's reference table ?"), value);
      gnome_app_ok_cancel_modal (GNOME_APP (gpc_app), message, film_maker_validate_callback, value);
      g_free (message);
    }
    else
      film_maker_validate_callback (0, value);
  }
  return FALSE;
}


gboolean
on_film_model_combo_entry_focus_in_event (GtkWidget       *widget,
                                          GdkEventFocus   *event,
                                          gpointer         user_data)
{
  gchar *value;

  if (!gpc_film_infos || gpc_film_updating)
    return FALSE;
  value = g_strdup (gpc_film_get_model (gpc_film_infos));
  if (!gpc_film_maker_codes)
    gpc_film_maker_codes = gpc_app_get_maker_codes (gpc_connection, "GPC_FILM_MODEL", gpc_film_get_maker (gpc_film_infos));
  gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_film_dialog, "film_model_combo")), gpc_film_maker_codes);
  gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "film_model_combo_entry")), value);
  return FALSE;
}


void
on_film_model_combo_entry_changed      (GtkEditable     *editable,
                                        gpointer         user_data)
{
  if (!gpc_film_infos || gpc_film_updating)
    return;
  gpc_film_set_model (gpc_film_infos, gtk_entry_get_text (GTK_ENTRY (editable)));
  gpc_film_modified = TRUE;
}


void
film_model_validate_callback (gint reply, gpointer data)
{
  switch (reply) {
    case  0 : gpc_film_maker_codes = g_list_insert_sorted (gpc_film_maker_codes, (gchar *) data, (GCompareFunc) g_strcasecmp);
              gpc_added_film_maker_codes = g_list_insert_sorted (gpc_added_film_maker_codes, g_strdup ((gchar *) data), (GCompareFunc) g_strcasecmp);
              gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_film_dialog, "film_model_combo")), gpc_film_maker_codes);
              gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "film_model_combo_entry")), (gchar *) data);
              break;
    default : gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "film_model_combo_entry")), "");
              g_free (data);
  }
}


gboolean
on_film_model_combo_entry_focus_out_event (GtkWidget       *widget,
                                           GdkEventFocus   *event,
                                           gpointer         user_data)
{
  gchar      *value;
  gchar      *message;

  if (!gpc_film_infos || gpc_film_updating)
    return FALSE;
  value = g_strdup (gtk_entry_get_text (GTK_ENTRY (widget)));
  if ((strlen (value) > 0) && !gpc_app_check_keyword (gpc_connection, gpc_film_maker_codes, value, "GPC_FILM_MODEL")) {
    if (gpc_confirm_insert_refs) {
      message = g_strdup_printf (_("Insert value '%s' in %s film model's table ?"), value, gpc_film_get_maker (gpc_film_infos));
      gnome_app_ok_cancel_modal (GNOME_APP (gpc_app), message, film_model_validate_callback, value);
      g_free (message);
    }
    else
      film_model_validate_callback (0, value);
  }
  return FALSE;
}


void
on_iso_spinbutton_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{
  if (!gpc_film_infos || gpc_film_updating)
    return;
  gpc_film_set_iso (gpc_film_infos, gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (editable)));
  gpc_film_modified = TRUE;
}


void
on_nb_photos_spinbutton_changed        (GtkEditable     *editable,
                                        gpointer         user_data)
{
  if (!gpc_film_infos || gpc_film_updating)
    return;
  gpc_film_set_size (gpc_film_infos, gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (editable)));
  gpc_film_modified = TRUE;
}


void
on_camera_maker_combo_entry_changed    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  if (!gpc_film_infos || gpc_film_updating)
    return;
  gpc_film_set_camera_maker (gpc_film_infos, gtk_entry_get_text (GTK_ENTRY (editable)));
  if (gpc_camera_maker_codes) {
    g_list_foreach (gpc_camera_maker_codes, (GFunc) g_free, NULL);
    g_list_free (gpc_camera_maker_codes);
    gpc_camera_maker_codes = NULL;
  }
  gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "camera_model_combo_entry")), "");
  gpc_film_modified = TRUE;
}


void
camera_maker_validate_callback (gint reply, gpointer data)
{
  switch (reply) {
    case  0 : gpc_camera_makers = g_list_insert_sorted (gpc_camera_makers, (gchar *) data, (GCompareFunc) g_strcasecmp);
              gpc_added_camera_makers = g_list_insert_sorted (gpc_added_camera_makers, g_strdup ((gchar *) data), (GCompareFunc) g_strcasecmp);
              gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_film_dialog, "camera_maker_combo")), gpc_camera_makers);
              gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "camera_maker_combo_entry")), (gchar *) data);
              break;
    default : gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "camera_maker_combo_entry")), "");
              g_free (data);
  }
}


gboolean
on_camera_maker_combo_entry_focus_out_event (GtkWidget       *widget,
                                             GdkEventFocus   *event,
                                             gpointer         user_data)
{
  gchar      *value;
  gchar      *message;

  if (!gpc_film_infos || gpc_film_updating)
    return FALSE;
  value = g_strdup (gtk_entry_get_text (GTK_ENTRY (widget)));
  if ((strlen (value) > 0) && !gpc_app_check_keyword (gpc_connection, gpc_camera_makers, value, "GPC_CAMERA_MAKER")) {
    if (gpc_confirm_insert_refs) {
      message = g_strdup_printf (_("Insert value '%s' in camera makers reference table ?"), value);
      gnome_app_ok_cancel_modal (GNOME_APP (gpc_app), message, camera_maker_validate_callback, value);
      g_free (message);
    }
    else
      camera_maker_validate_callback (0, value);
  }
  return FALSE;
}


gboolean
on_camera_model_combo_entry_focus_in_event (GtkWidget       *widget,
                                            GdkEventFocus   *event,
                                            gpointer         user_data)
{
  gchar *value;

  if (!gpc_film_infos || gpc_film_updating)
    return FALSE;
  value = g_strdup (gpc_film_get_camera_model (gpc_film_infos));
  if (!gpc_camera_maker_codes)
    gpc_camera_maker_codes = gpc_app_get_maker_codes (gpc_connection, "GPC_CAMERA_MODEL", gpc_film_get_camera_maker (gpc_film_infos));
  gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_film_dialog, "camera_model_combo")), gpc_camera_maker_codes);
  gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "camera_model_combo_entry")), value);
  return FALSE;
}


void
on_camera_model_combo_entry_changed    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  if (!gpc_film_infos || gpc_film_updating)
    return;
  gpc_film_set_camera_model (gpc_film_infos, gtk_entry_get_text (GTK_ENTRY (editable)));
  gpc_film_modified = TRUE;
}


void
camera_model_validate_callback (gint reply, gpointer data)
{
  switch (reply) {
    case  0 : gpc_camera_maker_codes = g_list_insert_sorted (gpc_camera_maker_codes, (gchar *) data, (GCompareFunc) g_strcasecmp);
              gpc_added_camera_maker_codes = g_list_insert_sorted (gpc_added_camera_maker_codes, g_strdup ((gchar *) data), (GCompareFunc) g_strcasecmp);
              gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_film_dialog, "camera_model_combo")), gpc_camera_maker_codes);
              gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "camera_model_combo_entry")), (gchar *) data);
              break;
    default : gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "camera_model_combo_entry")), "");
              g_free (data);
  }
}


gboolean
on_camera_model_combo_entry_focus_out_event (GtkWidget       *widget,
                                             GdkEventFocus   *event,
                                             gpointer         user_data)
{
  gchar      *value;
  gchar      *message;

  if (!gpc_film_infos || gpc_film_updating)
    return FALSE;
  value = g_strdup (gtk_entry_get_text (GTK_ENTRY (widget)));
  if ((strlen (value) > 0) && !gpc_app_check_keyword (gpc_connection, gpc_camera_maker_codes, value, "GPC_CAMERA_MODEL")) {
    if (gpc_confirm_insert_refs) {
      message = g_strdup_printf (_("Insert value '%s' in %s camera model's table ?"), value, gpc_film_get_camera_maker (gpc_film_infos));
      gnome_app_ok_cancel_modal (GNOME_APP (gpc_app), message, camera_model_validate_callback, value);
      g_free (message);
    }
    else
      camera_model_validate_callback (0, value);
  }
  return FALSE;
}


void
on_period_entry_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
  if (!gpc_film_infos || gpc_film_updating)
    return;
  gpc_film_set_period (gpc_film_infos, gtk_entry_get_text (GTK_ENTRY (editable)));
  gpc_film_modified = TRUE;
}


void
on_film_description_text_changed       (GtkEditable     *editable,
                                        gpointer         user_data)
{
  if (!gpc_film_infos || gpc_film_updating)
    return;
  gpc_film_set_description (gpc_film_infos, gtk_editable_get_chars (editable, 0, -1));
  if (films_clist)
    gtk_clist_set_text (films_clist, gpc_film_selection, 2, g_strdup (gpc_film_get_description (gpc_film_infos)));
  gpc_film_modified = TRUE;
}


gboolean
on_film_keywords_combo_entry_key_press_event (GtkWidget       *widget,
                                         GdkEventKey     *event,
                                         gpointer         user_data)
{
  if (event->keyval == GDK_Return) {
    on_film_add_keyword_button_clicked (NULL, NULL);
    event->keyval = GDK_End;
    gtk_editable_select_region (GTK_EDITABLE (widget), 0, -1);
  }
  return FALSE;
}


void
on_film_keywords_clist_select_row      (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gpc_film_keyword_selection = row;
}


void
on_film_delete_keyword_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget   *list;
  GList       *keywords;
  GList       *deleted;
  gchar       *value;

  if (!gpc_film_infos || (gpc_film_keyword_selection < 0))
    return;
  list = lookup_widget (gpc_film_dialog, "keywords_clist");
  gtk_clist_get_text (GTK_CLIST (list), gpc_film_keyword_selection, 0, &value);
  keywords = gpc_film_get_keywords (gpc_film_infos);
  deleted = g_list_find_custom (keywords, value, (GCompareFunc) g_strcasecmp);
  if (deleted)
    keywords = g_list_remove_link (keywords, deleted);
  gpc_film_set_keywords (gpc_film_infos, keywords, FALSE);
  gtk_clist_remove (GTK_CLIST (list), gpc_film_keyword_selection);
  gpc_film_keyword_selection = -1;
  gpc_film_modified = TRUE;
}


void
film_keywords_validate_callback (gint reply, gpointer data)
{
  GList       *keywords;
  gchar       *fields[2];

  switch (reply) {
    case  0 : if (g_list_find_custom (gpc_keywords, (gchar *) data, (GCompareFunc) g_strcasecmp) == NULL) {
                gpc_keywords = g_list_insert_sorted (gpc_keywords, (gchar *) data, (GCompareFunc) g_strcasecmp);
                gpc_added_keywords = g_list_insert_sorted (gpc_added_keywords, g_strdup ((gchar *) data), (GCompareFunc) g_strcasecmp);
                gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_film_dialog, "keywords_combo")), gpc_keywords);
		if (gpc_image_dialog)
                  gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_image_dialog, "keywords_combo")), gpc_keywords);
                gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "keywords_combo_entry")), (gchar *) data);
              }
              keywords = gpc_film_get_keywords (gpc_film_infos);
              if (g_list_find_custom (keywords, (gchar *) data, (GCompareFunc) g_strcasecmp) == NULL) {
                keywords = g_list_insert_sorted (keywords, g_strdup ((gchar *) data), (GCompareFunc) g_strcasecmp);
                gpc_film_set_keywords (gpc_film_infos, keywords, FALSE);
                fields[0] = (gchar *) data;
                fields[1] = NULL;
                gtk_clist_append (GTK_CLIST (lookup_widget (gpc_film_dialog, "keywords_clist")), fields);
                gpc_film_modified = TRUE;
              }
              break;
    default : gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_film_dialog, "keywords_combo_entry")), "");
              g_free (data);
  }
}


void
on_film_add_keyword_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  gchar       *value;
  gchar       *message;

  if (!gpc_film_infos || gpc_film_updating)
    return;
  value = gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (gpc_film_dialog, "keywords_combo_entry")), 0, -1);
  if (strlen (value) > 0) {
    if ((g_list_find_custom (gpc_added_keywords, value, (GCompareFunc) g_strcasecmp) == NULL) &&
        (g_list_find_custom (gpc_keywords, value, (GCompareFunc) g_strcasecmp) == NULL)) {
      if (gpc_confirm_insert_refs) {
        message = g_strdup_printf (_("Insert value '%s' in keywords reference table ?"), value);
        gnome_app_ok_cancel_modal (GNOME_APP (gpc_app), message, film_keywords_validate_callback, value);
        g_free (message);
      }
      else
        film_keywords_validate_callback (0, value);
    }
    else
      film_keywords_validate_callback (0, value);
  }
  else
    g_free (value);
}


void
on_film_cancel_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  gchar *str;

  if (!gpc_film_infos || !gpc_film_modified)
    return;
  gpc_list_free (gpc_film_maker_codes);
  gpc_film_maker_codes = NULL;
  gpc_list_free (gpc_camera_maker_codes);
  gpc_camera_maker_codes = NULL;
  gpc_film_infos_free (gpc_film_infos);
  if (gtk_clist_get_text(films_clist, gpc_film_selection, 0, &str)) {
    gpc_film_infos = gpc_film_get_infos (gpc_connection, atoi (str));
    gpc_film_dialog_update (gpc_film_infos);
    if (films_clist) {
      gtk_clist_set_text (films_clist, gpc_film_selection, 1, g_strdup (gpc_film_get_number (gpc_film_infos)));
      gtk_clist_set_text (films_clist, gpc_film_selection, 2, g_strdup (gpc_film_get_description (gpc_film_infos)));
    }
  }
}


void
on_film_hide_button_clicked                 (GtkButton       *button,
                                             gpointer         user_data)
{
  gpc_film_dialog_save_options ();
  gtk_widget_destroy (gpc_film_dialog);
  gpc_film_dialog = NULL;
}



void
on_film_apply_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  if ((gpc_connection != NULL) &&
      (pg_connection_is_active (gpc_connection)) &&
      (gpc_film_infos != NULL) &&
      (gpc_film_modified))
    gpc_film_infos_store (gpc_connection, gpc_film_infos);
}


void
swap_film_table_visibility (gchar *tablename, gchar *pixmapname)
{
  GtkWidget *table;
  GtkWidget *pixmap;
  gchar     *pixmapfile;
  gint       x;
  gint       y;

  gdk_window_get_root_origin (GTK_WIDGET (gpc_film_dialog)->window, &x, &y);
  table = lookup_widget (gpc_film_dialog, tablename);
  pixmap = lookup_widget (gpc_film_dialog, pixmapname);
  if (GTK_WIDGET_VISIBLE (table)) {
    gtk_widget_hide (table);
    pixmapfile = gnome_pixmap_file ("gphotocoll/arrow-right.xpm");
    gnome_pixmap_load_file (GNOME_PIXMAP (pixmap), pixmapfile);
  }
  else {
    gtk_widget_show (table);
    pixmapfile = gnome_pixmap_file ("gphotocoll/arrow-down.xpm");
    gnome_pixmap_load_file (GNOME_PIXMAP (pixmap), pixmapfile);
  }
  g_free (pixmapfile);
  gdk_window_move (GTK_WIDGET (gpc_film_dialog)->window, x, y);
}


void
on_film_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  swap_film_table_visibility ("film_table", "film_pixmap");
}


void
on_film_classification_button_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
  swap_film_table_visibility ("classification_table", "classification_pixmap");
}


void
on_film_general_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  swap_film_table_visibility ("general_table", "general_pixmap");
}


void
on_film_keywords_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
  swap_film_table_visibility ("keywords_table", "keywords_pixmap");
}
