<?php

function minimum_version($vercheck)
{
	$minver = (int)str_replace('.', '', $vercheck);
	$curver = (int)str_replace('.', '', phpversion());

	if($curver >= $minver){
		return (true);
	}

	return (false);
}


function check_schema_version($description, $version)
{
    $desc= preg_replace("/^.* DESC\s+\(*\s*'([^']+)'\s*\)*.*$/", '\\1', $description);

    return preg_match("/\(v$version\)/", $desc);
}


function schema_check($server, $admin, $password)
{
    global $config;

        $messages= array();
        $required_classes= array(
                "gosaObject"            => array("version" => "2.1"),
                "gosaAccount"           => array("version" => "2.1.2"),
                "gosaLockEntry"         => array("version" => "2.1"),
                "gosaCacheEntry"        => array("version" => "2.1"),
                "gosaDepartment"        => array("version" => "2.1"),

                "goFaxAccount"          => array("version" => "1.0.4", "class" => "gofaxAccount"),
                "goFaxSBlock"           => array("version" => "1.0.4", "class" => "gofaxAccount"),
                "goFaxRBlock"           => array("version" => "1.0.4", "class" => "gofaxAccount"),

                "gosaUserTemplate"      => array("version" => "2.1", "class" => "posixAccount"),
                "gosaMailAccount"       => array("version" => "2.1", "class" => "mailAccount"),
                "gosaProxyAccount"      => array("version" => "2.1.2", "class" => "proxyAccount"),
                "gosaApplication"       => array("version" => "2.1", "class" => "appgroup"),
                "gosaApplicationGroup"  => array("version" => "2.1", "class" => "appgroup"),

                "GOhard"                => array("version" => "2.1", "class" => "terminals"),
                "gotoTerminal"          => array("version" => "2.0", "class" => "terminals"),
                "goServer"              => array("version" => "2.1"),
                "goTerminalServer"      => array("version" => "2.1", "class" => "terminals"),
                "goNfsServer"           => array("version" => "2.1", "class" => "terminals"),
                "goNtpServer"           => array("version" => "2.1", "class" => "terminals"),
                "goSyslogServer"        => array("version" => "2.1", "class" => "terminals"),
                "goLdapServer"          => array("version" => "2.1"),
                "goCupsServer"          => array("version" => "2.1", "class" => array("posixAccount", "terminals")),
                "goImapServer"          => array("version" => "2.1", "class" => array("mailAccount", "mailgroup")),
                "goKrbServer"           => array("version" => "2.1"),
                "goFaxServer"           => array("version" => "2.1", "class" => "gofaxAccount")
                );

        /* Build LDAP connection */
        $ds= ldap_connect ($server);
        if (!$ds) {
                return (array(_("Can't bind to LDAP. No schema check possible!")));
        }
    ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
        $r= ldap_bind ($ds, $admin, $password);

        /* Get base to look for schema */
        $sr= ldap_read ($ds, "", "objectClass=*", array("subschemaSubentry"));
        $attr= ldap_get_entries($ds,$sr);
        if (!isset($attr[0]['subschemasubentry'][0])){
                return (array(_("Can't get schema information from server. No schema check possible!")));
        }

        /* Get list of objectclasses */
        $objectclasses= array();
        $sr= ldap_read ($ds, "cn=subschema", "objectClass=*", array("objectclasses"));
        $attrs= ldap_get_entries($ds,$sr);
        if (!isset($attrs[0])){
                return (array(_("Can't get schema information from server. No schema check possible!")));
        }
        foreach ($attrs[0]['objectclasses'] as $val){
                $name= preg_replace("/^.* NAME\s+\(*\s*'([^']+)'\s*\)*.*$/", '\\1', $val);
                if ($name != $val){
                        $objectclasses[$name]= $val;
                }
        }
       /* Walk through objectclasses and check if they are needed or not */
        foreach ($required_classes as $key => $value){
        if (isset($value['class'])){
            if (!is_array($value['class'])){
                $classes= array($value['class']);
            } else {
                $classes= $value['class'];
            }

            /* Check if we are using the class that requires */
            foreach($classes as $class){
                if (!isset($objectclasses[$key])){
                                    $messages[$key]= sprintf(_("Optional objectclass '%s' required by plugin '%s' is not present in LDAP setup"), $key, $class);
                            } else {
                                    if (!check_schema_version($objectclasses[$key], $value['version'])){
                                            $messages[$key]= sprintf(_("Optional objectclass '%s' required by plugin '%s' does not have version %s"), $key, $class, $value['version']);
                                    }
                            }

            }
        } else {
            /* Required class */
            if (!isset($objectclasses[$key])){
                $messages[$key]= sprintf(_("Required objectclass '%s' is not present in LDAP setup"), $key);
            } else {
                if (!check_schema_version($objectclasses[$key], $value['version'])){
                    $messages[$key]= sprintf(_("Required objectclass '%s' does not have version %s"), $key, $value['version']);
                }
            }
        }
        }

    /* Check for correct samba parameters */
    if (!isset($objectclasses['sambaSamAccount'])){
        $messages['samba3']= _("SAMBA 3 support disabled, no schema seems to be installed");
    }
    if (!isset($objectclasses['sambaAccount'])){
        $messages['samba2']= _("SAMBA 2 support disabled, no schema seems to be installed");
    }

    /* Check pureftp/dns/ */
    if (!isset($objectclasses['PureFTPdUser'])){
        $messages['pureftp']= _("Support for pureftp disabled, no schema seems to be installed");
    }
    if (!isset($objectclasses['gosaWebdavAccount'])){
        $messages['webdav']= _("Support for WebDAV disabled, no schema seems to be installed");
    }
    if (!isset($objectclasses['phpgwAccount'])){
        $messages['phpgroupware']= _("Support for phpgroupware disabled, no schema seems to be installed");
    }
    if (!isset($objectclasses['goFonAccount'])){
        $messages['phoneaccount']= _("Support for gofon disabled, no schema seems to be installed");
    }

        return ($messages);
}



function check(&$faults, $message, $description, $test, $required= TRUE)
{
	$msg= "<table class='check'><tr><td class='check' style='font-size:14px;'>$message</td><td rowspan=2 style='vertical-align:middle; text-align:center;width:45px;'>";
	if ($test){
		$msg.= _("OK")."<br>";
	} else {
		if (!$required){
			$msg.="<font color=red>"._("Ignored")."</font><br>";
		} else {
			$msg.="<font color=red>"._("Failed")."</font><br>";
			$faults++;
		}
	}
	$msg.= "</td></tr><tr><td class='check' style='padding-left:20px;background-color:#F0F0F0;'>$description</td></tr></table><br>";

	return $msg;
}

function perform_php_checks(&$faults)
{
	global $check_globals;
	
	$faults= 0;
	$msg= "";

	$msg.= "<h1>"._("PHP setup inspection")."</h1>";
	$msg.= check (	$faults, _("Checking for PHP version (>=4.1.0)"),
			_("PHP must be of version 4.1.0 or above for some functions and known bugs in PHP language."),
			minimum_version('4.1.0'));

	$msg.= check (	$faults, _("Checking if register_globals is set to 'off'"),
			_("register_globals is a PHP mechanism to register all global varibales to be accessible from scripts without changing the scope. This may be a security risk. GOsa will run in both modes."),
			$check_globals == 0, FALSE);

	$msg.= check (	$faults, _("Checking for ldap module"),
			_("This is the main module used by GOsa and therefore really required."),
			function_exists('ldap_bind'));

	$msg.= check (	$faults, _("Checking for gettext support"),
			_("Gettext support is required for internationalized GOsa."), function_exists('bindtextdomain'));

	$msg.= check (	$faults, _("Checking for mhash module"),
			_("To use SSHA encryption, you'll need this module. If you are just using crypt or md5 encryption, ignore this message. GOsa will run without it."),
			function_exists('mhash'), FALSE);

	$msg.= check (	$faults, _("Checking for gd module"),
			_("GOsa needs this module for recalculating image sizes provided for users as jpegPhoto."),
			function_exists('imagecreate'));
	$msg.= check (	$faults, _("Checking for imap module"),
			_("The IMAP module is needed to communicate with the IMAP server. It gets status informations, creates and deletes mail users."),
			function_exists('imap_open'));
	$msg.= check (	$faults, _("Checking for getacl in imap"),
			_("The getacl support is needed for shared folder permissions. The standard IMAP module is not capable of reading acl's. You need a recend PHP version for this feature."),
			function_exists('imap_getacl'), FALSE);
	$msg.= check (	$faults, _("Checking for mysql module"),
			_("MySQL support is needed for reading GOfax reports from databases."),
			function_exists('mysql_query'), FALSE);
	$msg.= check (	$faults, _("Checking for cups module"),
			_("In order to read available printers from IPP protocol instead of printcap files, you've to install the CUPS module."),
			function_exists('cups_get_dest_list'), FALSE);
	$msg.= check (	$faults, _("Checking for kadm5 module"),
			_("Managing users in kerberos requires the kadm5 module which is downloadable via PEAR network."),
			function_exists('kadm5_init_with_password'), FALSE);
	return ($msg);
}

  
function perform_additional_checks(&$faults)
{
	# Programm check
	$msg= "<h1>"._("Checking for some additional programms")."</h1>";
  
	# Image Magick
	$query= "LC_ALL=C LANG=C convert -help";
	$output= shell_exec ($query);
	$lines= split ("\n", $output);
	$version= preg_replace ("/^Version:[^I]+ImageMagick ([^\s]+).*/", "\\1", $lines[0]);
	list($major, $minor)= split("\.", $version);
	$msg.= check (	$faults, _("Checking for ImageMagick (>=5.4.0)"),
			_("ImageMagick is used to convert user supplied images to fit the suggested size and the unified JPEG format."),
			($major > 5 || ($major == 5 && $minor >= 4)));
    
	# Check for fping
	$query= "LC_ALL=C LANG=C fping -v 2>&1";
	$output= shell_exec ($query);
	$have_fping= preg_match("/^fping:/", $output);
	$msg.= check (	$faults, _("Checking for fping utility"),
			_("The fping utility is only used if you've got a thin client based terminal environment running."),
			$have_fping, FALSE);

	# Check for smb hash generation tool
	$query= "mkntpwd 2>&1";
	$output= shell_exec ($query);
	$have_mkntpwd= preg_match("/^Usage: mkntpwd /", $output);
	$alt = 0;
  
	if (!$have_mkntpwd){
		$query= "LC_ALL=C LANG=C perl -MCrypt::SmbHash -e 'ntlmgen \"PASSWD\", \$lm, \$nt; print \"\${lm}:\${nt}\\n\";' &>/dev/null";
		system ($query, $ret);
		$alt= ($ret == 0);
	}

	$msg.= check (	$faults, _("Checking for a way to generate LM/NT password hashes"),
			_("In order to use SAMBA 2/3, you've to install some additional packages to generate password hashes."),
			($have_mkntpwd || $alt));

	return $msg;
}

