#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# printer/win32raw.py
#
# DESCRIPTION:
# Basic destination adapter for writing raw data (text/ps/pcl/esc-p) to win32 printer
#
# NOTES:
#


from gnue.reports import VERSION
from gnue.reports.base.GROutputAdapter import DestinationAdapter as Base
from gnue.common.apps import GDebug
import sys, os, string
import win32print, win32ui
from pywin.mfc import window, dialog

PRINTDLGORD = 1538
PRINTER = 1139

class PrintDialog(dialog.Dialog):
  def __init__(self, dlgID, dllid=None):
    printSetupOnly = 0
    flags=(win32ui.PD_ALLPAGES|
              win32ui.PD_USEDEVMODECOPIES|
              win32ui.PD_NOPAGENUMS|
              win32ui.PD_HIDEPRINTTOFILE|
              win32ui.PD_NOSELECTION)

    parent=None
    dlg = win32ui.CreatePrintDialog(dlgID, printSetupOnly, flags, parent, dllid)
    window.Wnd.__init__(self, dlg)
    self.HookCommands()
    self.bHaveInit = None

  def OnOK(self):
    self._obj_.OnOK()
    self['deviceName'] = self.GetDlgItem(PRINTER).GetWindowText()


class DestinationAdapter(Base):

  #
  # Typically, a transform adapter will call EITHER
  # getOutputHandle or getOutputFile, not both.
  #
  # return a stream handle for outut by
  # the transform adapter
  #
  def getOutputHandle(self):
    self.usingHandle = 1
    self.input, self.tempfile = self.createTempFile()
    return self.input

  #
  # return a file name for outut by the
  # transform adapter
  #
  def getOutputFile(self):
    self.usingHandle = 0
    self.input, self.tempfile = self.createTempFile()
    self.input.close()
    return self.tempfile

  #
  # Wrap up
  #
  def close(self, mimetype='plain/text'):

    if self.usingHandle:
      self.input.close()

    file = self.tempfile

    print_to = string.replace(string.replace(self.destination, "`",""),';','')
    if print_to == '-':
      pDialog = PrintDialog(PRINTDLGORD)
      pDialog.DoModal()
      try:
        # OK selected
        print_to = pDialog['deviceName']
      except KeyError:
        # Cancel selected
        self.deleteTempFile(self.tempfile)
        return
        

    hprinter = win32print.OpenPrinter(print_to)
    win32print.StartDocPrinter(hprinter, 1, ('GNUe report', None, 'raw'))

    infile = open(file, 'r')
    buf = infile.readline()
    while(buf):
      win32print.WritePrinter(hprinter, buf)
      buf = infile.readline()
    infile.close()

    win32print.EndDocPrinter(hprinter)
    win32print.ClosePrinter(hprinter)

    self.deleteTempFile(self.tempfile)

