#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# TableEditor.py
#
# DESCRIPTION:
#
# NOTES:
#


import sys, os, string
from wxPython.wx import *
from wxPython.grid import *
from gnue.common.apps import GDebug
from gnue.common.formatting import GTypecast
from gnue.common.logic.GTrigger import GTrigger
from gnue.common.definitions.GParserHelpers import GContent
from gnue.designer.base.ToolBase import *
from gnue.designer.base.uihelpers.GridCellEditors import *

Columns = [  ('name','Name'),
             ('type','Data Type'),
             ('length','Length'),
             ('precision','Precision'),
             ('defaultwith','Default\nwith'),
             ('default','Default\nvalue'),
             ('nullable','Allow\nEmpty?')  ]
numcols = len(Columns)

class TableEditor (ToolBase):

  runtime_section = 'SchemaTableEditor'
  uses_feedback_bar = 1
  default_dock = 'right-0'

  def init(self):
    self.panel = wxPanel(self,-1,style=wxSIMPLE_BORDER, pos=wxPoint(6,6))

    self.object = None
    self.table = None

    self.objectList = []
    self.objectMap = {}

    # Set up our grid
    self.grid = wxGrid(self.panel, -1, pos=wxPoint(0,0))
    self.grid.CreateGrid(1,numcols)

    for i in range(numcols):
      self.grid.SetColLabelValue(i,Columns[i][1])

    self.grid.SetRowLabelSize(32)

    EVT_GRID_CELL_CHANGE(self.grid, self.OnCellChange)
    EVT_GRID_CELL_LEFT_DCLICK(self.grid, self.OnLeftDClick)
    EVT_SIZE(self, self.onSize)

    # EventAware provided by ToolBase
    self.registerEventListeners({
                       'ObjectSelected'      : self.onSetCurrentObject,
                       'ObjectCreated'       : self.onCreateObject,
                       'ObjectModified'      : self.onModifyObject,
                       'ObjectDeleted'       : self.onDeleteObject,
                      })

    self.rootObject.walk(self.inventoryObject)

    self.saveRuntimeSettings()

  def onSetCurrentObject (self, event):
    object = event.object
    handler = event.originator
    table = object.findParentOfType('GSTable')
    if table and table != self.table:
      self._setCurrentTable(table)

  def _setCurrentTable(self, object):
    ##self.setFeedback("%s Table" % (object.name))

    self.table = object

    try:
      self.triggerList = object._validTriggers
    except AttributeError:
      self.triggerList = {}

    # Speed up the process by not refreshing the grid yet
    self.grid.BeginBatch()

    # Delete any old rows from a previous object
    nr = self.grid.GetNumberRows()
    if nr:
      self.grid.DeleteRows(0,nr)

    # Create the number of rows we'll need
    self.grid.InsertRows(0,len(object._fieldList))

    i = 0
    for field in object._fieldList:
      for c in range(numcols):
        attr = Columns[c][0]
##        self.grid.SetCellEditor(i, c, EventCellEditor(self.grid,self.triggerTypes))
        try:
          self.grid.SetCellValue(i,c, "%s" % field.__dict__[attr])
        except KeyError:
          self.grid.SetCellValue(i,c, '')
      i += 1


    # Redraw the grid
    self.grid.EndBatch()
    try:
      self.grid.ForceRefresh()  # Added in 2.3.1
    except AttributeError:
      pass


  def onCreateObject (self, event):
    self.inventoryObject(event.object)


  def onModifyObject (self, event):
    object = event.object
    handler = event.originator
    if object == None:
      return
    if isinstance(object,GTrigger) and \
       object.type.upper() == 'NAMED' and \
       event.new.has_key('name'):
      try:
        del self.namedMap[event.old['name']]
      except KeyError:
        pass
      self.namedMap[object.name] = object
      self._setCurrentTable(self.object)

##    if handler != self and self.object == object:
##      self._setCurrent(object)


  def onDeleteObject (self, event):
    object = event.object
    handler = event.originator
    if object == None:
      return
    if handler != __name__:
      pass


  def inventoryObject(self, object):
    if object._type == 'GSTable' and not self.table:
      self._setCurrentTable(object)


  def onSize(self, event):
    x,y = self.GetClientSizeTuple()
    self.panel.SetSize((x-12,y-12))
    self.grid.SetSize(self.panel.GetClientSizeTuple())
    w,h = self.grid.GetClientSizeTuple()
##    self.grid.SetColSize(0, w - self.grid.GetRowLabelSize())
    try:
      self.grid.ForceRefresh()  # Added in 2.3.1
    except AttributeError:
      pass



  # Force a grid cell into Edit mode when Double-Clicked
  def OnLeftDClick(self,evt):
    if self.grid.CanEnableCellControl():
      self.grid.EnableCellEditControl()


  def _generateName(self, object):
    parent = object._parent
    name = '%s.%s (%s-Level Trigger)' % (parent.name, parent._validTriggers[object.type.upper()], parent._type[2:].capitalize())
    return name


  def OnCellChange(self, evt):
    field = self.table._fieldList[evt.GetRow()]
    value = self.grid.GetCellValue(evt.GetRow(), evt.GetCol())

    print field, value


  def saveRuntimeSettings(self):
    props = {}
    for i in range(numcols):
      props['GridCol%s' % i] = self.grid.GetColSize(i)
    return (self.runtime_section, props)


