/* $Id: d_bjt.model,v 24.23 2004/02/01 21:12:55 al Exp $ -*- C++ -*-
 * Copyright (C) 2002 Albert Davis
 * Author: Albert Davis <aldavis@ieee.org>
 *
 * This file is part of "Gnucap", the Gnu Circuit Analysis Package
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *------------------------------------------------------------------
 * Berkeley BJT model
 * Derived from Spice code, both from 2g6 and 3f4
 * Recoded for Gnucap model compiler, Al Davis, 2002
 *------------------------------------------------------------------
 * data structures and defaults for bjt model.
 *
 * netlist syntax:
 * device:  qxxxx c b e s mname <device args>
 * model:   .model mname NPN <args>
 *	or  .model mname PNP <args>
 *
 * known BUGs
 * 1. excess phase partially implemented, disabled, as if PTF == 0.
 */
/* This file is automatically generated. DO NOT EDIT */
#ifndef D_BJT_H_INCLUDED
#define D_BJT_H_INCLUDED

#include "d_diode.h"
  class DEV_BJT;
  class DEV_CPOLY_G;
  class DEV_RESISTANCE;
  class DEV_FPOLY_CAP;
/*--------------------------------------------------------------------------*/
class SDP_BJT
  :public SDP_DIODE{
public:
  explicit SDP_BJT(const COMMON_COMPONENT*);
public:
};
/*--------------------------------------------------------------------------*/
class TDP_BJT{
public:
  explicit TDP_BJT(const DEV_BJT*);
public:
  double vt;	// 
  double ibc;	// BJTtSatCur
  double ibe;	// BJTtSatCur
  double BetaF;	// BJTtBetaF
  double BetaR;	// BJTtBetaR
  double BEleakCur;	// BJTtBEleakCur
  double BCleakCur;	// BJTtBCleakCur
  double BEpot;	// BJTtBEpot
  double BEcap;	// BJTtBEcap
  double DepCap;	// 
  double f1;	// 
  double BCpot;	// BJTtBCpot
  double BCcap;	// BJTtBCcap
  double f4;	// 
  double f5;	// 
  double Vcrit;	// 
};
/*--------------------------------------------------------------------------*/
class MODEL_BJT
  :public MODEL_DIODE{
public:
  // using generated copy constructor, should be unreachable
  explicit MODEL_BJT();
  ~MODEL_BJT() {--_count;}
public: // override virtual
  bool      parse_front(CS&);
  bool      parse_params(CS&);
  void      parse_finish();
  SDP_CARD* new_sdp(const COMMON_COMPONENT* c)const;
  void      print_front(OMSTREAM&)const;
  void      print_params(OMSTREAM&)const;
  void      print_calculated(OMSTREAM&)const;
  bool      is_valid(const COMMON_COMPONENT*)const;
  void      tr_eval(COMPONENT*)const;
public: // not virtual
  static int count() {return _count;}
private: // strictly internal
  static int _count;
public: // input parameters
  double bf;	// Ideal forward beta
  double br;	// Ideal reverse beta
  double ibc;	// bc Saturation Current
  double ibe;	// be Saturation Current
  double is;	// Saturation Current
  double nf;	// Forward emission coefficient
  double nr;	// Reverse emission coefficient
  double vaf;	// Forward Early voltage
  double var;	// Reverse Early voltage
  double isc;	// B-C leakage saturation current
  double c4;	// obsolete, don't use
  double nc;	// B-C leakage emission coefficient
  double ise;	// B-E leakage saturation current
  double c2;	// obsolete, don't use
  double ne;	// B-E leakage emission coefficient
  double ikf;	// Forward beta roll-off corner current
  double ikr;	// reverse beta roll-off corner current
  double irb;	// Current for base resistance=(rb+rbm)/2
  double rb;	// Zero bias base resistance
  double rbm;	// Minimum base resistance
  double re;	// Emitter resistance
  double rc;	// Collector resistance
  double cbcp;	// external BC capacitance
  double cbep;	// external BE capacitance
  double cbsp;	// external BS capacitance (lateral)
  double ccsp;	// external BS capacitance (vertical)
  double cjc;	// Zero bias B-C depletion capacitance
  double cje;	// Zero bias B-E depletion capacitance
  double cjs;	// Zero bias C-S capacitance
  double fc;	// Forward bias junction fit parameter
  double mjc;	// B-C junction grading coefficient
  double mje;	// B-E junction grading coefficient
  double mjs;	// Substrate junction grading coefficient
  double vjc;	// B-C built in potential
  double vje;	// B-E built in potential
  double vjs;	// Substrate junction built in potential
  double xcjc;	// Fraction of B-C cap to internal base
  double itf;	// High current dependence of TF
  double ptf;	// Excess phase
  double tf;	// Ideal forward transit time
  double tr;	// Ideal reverse transit time
  double vtf;	// Voltage giving VBC dependence of TF
  double xtf;	// Coefficient for bias dependence of TF
  double xtb;	// Forward and reverse beta temp. exp.
  double xti;	// Temp. exponent for IS
  double eg;	// Energy gap for IS temp. dependency
public: // calculated parameters
  polarity_t polarity;	// 
  double invearlyvoltf;	// Inverse early voltage:forward
  double invearlyvoltr;	// Inverse early voltage:reverse
  double invrollofff;	// Inverse roll off - forward
  double invrolloffr;	// Inverse roll off - reverse
  double transtimevbcfact;	// Transit time VBC factor
  double excessphasefactor;	// Excess phase fact.
  double xfc;	// 
  double f2;	// 
  double f3;	// 
  double f6;	// 
  double f7;	// 
};
/*--------------------------------------------------------------------------*/
class COMMON_BJT
  :public COMMON_COMPONENT{
public:
  explicit COMMON_BJT(const COMMON_BJT& p);
  explicit COMMON_BJT(int c=0);
           ~COMMON_BJT();
  bool        operator==(const COMMON_COMPONENT&)const;
  COMMON_COMPONENT* clone()const {return new COMMON_BJT(*this);}
  void        parse(CS&);
  void        print(OMSTREAM&)const;
  void        expand(const COMPONENT*);
  const char* name()const {return "bjt";}
  const SDP_CARD* sdp()const {assert(_sdp); return _sdp;}
  bool      has_sdp()const {return _sdp;}
  static int  count() {return _count;}
private: // strictly internal
  static int _count;
public: // input parameters
  double m;	// device multiplier
  double area;	// area factor
  bool off;	// device initially off
  double icvbe;	// Initial B-E voltage
  double icvce;	// Initial C-E voltage
  double temp;	// instance temperature
public: // calculated parameters
  const SDP_CARD* _sdp;
  double oik;	// 
  double oikr;	// 
public: // attached commons
};
/*--------------------------------------------------------------------------*/
class DEV_BJT : public BASE_SUBCKT {
private:
  explicit DEV_BJT(const DEV_BJT& p);
public:
  explicit DEV_BJT();
           ~DEV_BJT() {--_count;}
private: // override virtual
  char      id_letter()const {return 'Q';}
  const char* dev_type()const{return "bjt";}
  int       max_nodes()const  {return 4;}
  int       min_nodes()const  {return 3;}
  int       out_nodes()const  {return _net_nodes;}
  int       matrix_nodes()const {return 0;}
  int       net_nodes()const {return _net_nodes;}
  int       int_nodes()const{return 3;}
  CARD*     clone()const     {return new DEV_BJT(*this);}
  void      parse(CS&);
  void      print(OMSTREAM&,int)const;
  void      expand();
  //void    map_nodes();     //BASE_SUBCKT
  //void    precalc();       //BASE_SUBCKT
  //void    dc_begin();      //BASE_SUBCKT
  //void    tr_begin();      //BASE_SUBCKT
  //void    tr_restore();    //BASE_SUBCKT
  void      dc_advance() {set_not_converged(); BASE_SUBCKT::dc_advance();}
  void      tr_advance() {set_not_converged(); BASE_SUBCKT::tr_advance();}
  bool      tr_needs_eval();
  void      tr_queue_eval() {if(tr_needs_eval()){q_eval();}}
  bool      do_tr();
  //void    tr_load();       //BASE_SUBCKT
  //double  tr_review();     //BASE_SUBCKT
  //void    tr_accept();     //BASE_SUBCKT
  //void    tr_unload();     //BASE_SUBCKT
  double    tr_probe_num(CS&)const;
  //void    ac_begin();      //BASE_SUBCKT
  //void    do_ac();         //BASE_SUBCKT
  //void    ac_load();       //BASE_SUBCKT
  //XPROBE  ac_probe_ext(CS&)const;//CKT_BASE/nothing
public:
  static int  count() {return _count;}
public: // may be used by models
  void limit(double vnew, double *vold, double vt, double vcrit);
private: // not available even to models
  static int _count;
  int _net_nodes;
public: // input parameters
public: // calculated parameters
  double vbe;	// B-E voltage
  double vbc;	// B-C voltage
  double vbx;	// B-C voltage (ext base)
  double vcs;	// C-S voltage
  double cce;	// collector-emitter current
  double cce_cpoly;	// 
  double go;	// Small signal output conductance
  double gm;	// Small signal transconductance
  double cpi;	// emitter-base current
  double cpi_cpoly;	// 
  double gpi;	// Small signal input conductance - pi
  double cmu;	// collector-base current
  double cmu_cpoly;	// 
  double gmu;	// Small signal conductance - mu
  double ix_cpoly;	// Current offset at base node, constant
  double gx;	// dix/dvbb Conductance from base to internal base
  double qbx;	// Charge storage B-X junction
  double cqbx;	// Cap. due to charge storage in B-X jct.
  double qbc;	// Charge storage B-C junction
  double cqbc;	// Cap. due to charge storage in B-C jct.
  double qcs;	// Charge storage C-S junction
  double cqcs;	// Cap. due to charge storage in C-S jct.
  double qbe;	// Charge storage B-E junction
  double cqbe;	// Cap. due to charge storage in B-E jct.
  double geqcb;	// d(Ieb)/d(Vcb)
  double cexbc_0;	// Total Capacitance in B-X junction
  double cexbc_1;	// 
  double cexbc_2;	// 
  double _dt_0;	// time step
  double _dt_1;	// 
public: // netlist
  DEV_CPOLY_G* _Ice;
  DEV_CPOLY_G* _Ipi;
  DEV_CPOLY_G* _Imu;
  DEV_FPOLY_CAP* _Cbx;
  DEV_FPOLY_CAP* _Cbc;
  DEV_FPOLY_CAP* _Ccs;
  DEV_FPOLY_CAP* _Cbe;
  DEV_RESISTANCE* _Rc;
  DEV_RESISTANCE* _Re;
  DEV_CPOLY_G* _Yb;
  DEV_CAPACITANCE* _Cbcp;
  DEV_CAPACITANCE* _Cbep;
  DEV_CAPACITANCE* _Cbsp;
  DEV_CAPACITANCE* _Ccsp;
private: // node list
  enum {n_col=0, n_base=1, n_emit=2, n_sub=3, n_icol=-1, n_ibase=-2, n_iemit=-3};
  node_t _nodes[7];
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
