#ifndef XMMS_PLAY_H
#define XMMS_PLAY_H

#ifdef ENABLE_XMMS
#include <xmms/xmmsctrl.h>
void xmms_play_init();
void xmms_play_song(MP3 *mp3, double pos);
void xmms_play_stop();
void xmms_play_pause();
void xmms_play_set_random();
void xmms_play_set_repeat();
void xmms_play_add_song(MP3 *mp3);
void xmms_play_del_song(MP3 *mp3);
void xmms_play_list_sync();
void xmms_play_list_load();
#else
#define xmms_play_init() while(0);
#define xmms_play_song(m,p) while(0);
#define xmms_play_stop() while(0);
#define xmms_play_pause() while(0)
#define xmms_play_set_random() while(0);
#define xmms_play_set_repeat() while(0);
#define xmms_play_add_song(m) while(0);
#define xmms_play_del_song(m) while(0);
#define xmms_play_list_sync() while(0)
#define xmms_play_list_load() while(0)
#endif

#endif
