/*
 * GNoise
 *
 * Copyright (C) 1999-2001 Dwight Engen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: dlgmarkers.c,v 1.1 2002/01/13 02:51:16 dengen Exp $
 *
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gnoise.h"
#include "gtkwavedisplay.h"
#include "gtkwaveset.h"

void on_dlgmarkers_delete(GtkButton *button, gpointer user_data);
void on_dlgmarkers_insert(GtkButton *button, gpointer user_data);

static GtkWidget *dlg_markers = NULL;

void on_dlgmarkers(GtkMenuItem *menuitem, gpointer user_data)
{
    GtkWaveSet *ws;
    if ((!file_open) || (dlg_markers != NULL))
	return;

    ws = GTK_WAVE_SET(user_data);
    dlg_markers = create_MarkersDialog();
    gtk_signal_connect(GTK_OBJECT(lookup_widget(dlg_markers, "Delete")),
		       "clicked", GTK_SIGNAL_FUNC (on_dlgmarkers_delete),
		       ws);
    gtk_signal_connect(GTK_OBJECT(lookup_widget(dlg_markers, "Insert")),
		       "clicked", GTK_SIGNAL_FUNC (on_dlgmarkers_insert),
		       ws);

    gtk_widget_show(dlg_markers);
}

gboolean on_dlgmarkers_destroy(GtkWidget *widget, GdkEvent *event,
			       gpointer user_data)
{
    dlg_markers = NULL;
    return FALSE;
}


void on_dlgmarkers_insert(GtkButton *button, gpointer user_data)
{
    smpl_indx		 start;
    smpl_indx		 end;
    smpl_indx		 i;
    int			 sbval;
    smpl_indx		 mod;
    char		*label;
    GtkSpinButton	*sb;
    GtkToggleButton	*tb;
    GtkOptionMenu	*om;

    ws = GTK_WAVE_SET(user_data);
    if (!file_open || !ws)
	return;

    /* determine if action is constrained to the selection */
    tb = GTK_TOGGLE_BUTTON(lookup_widget(dlg_markers, "ApplyToSelection"));
    if (tb->active)
    {
	/* FIXME: channel bond assumed... */
	start = ws->wd[0]->selection_start;
	end   = ws->wd[0]->selection_end;
    }
    else
    {
	start = 0;
	end = ws->sb->info.samples;
    }

    /* determine how often to place a marker (every what'th sample) */
    sb = GTK_SPIN_BUTTON(lookup_widget(dlg_markers, "ModFactor"));
    sbval = gtk_spin_button_get_value_as_int(sb);

    om = GTK_OPTION_MENU(lookup_widget(dlg_markers, "Unit"));
    gtk_label_get(GTK_LABEL(GTK_BIN(om)->child), &label);

    if (!strcmp(label, "Samples"))
	mod = sbval;
    else if (!strcmp(label, "Minutes"))
	mod = sbval * ws->sb->info.sample_rate * 60;
    else if (!strcmp(label, "Seconds"))
	mod = sbval * ws->sb->info.sample_rate;
    else
    {
	if (!strcmp(label, "CD sectors"))
	    sbval = 2352;
	if (!strcmp(label, "kBytes"))
	    sbval *= 1024;
	if (!strcmp(label, "MBytes"))
	    sbval *= 1024 * 1024;
	if (!strcmp(label, "GBytes"))
	    sbval *= 1024 * 1024 * 1024;

	/* assume bytes */
	mod = sbval / ((ws->sb->info.sample_bits / 8) * ws->sb->info.channels);
    }

    i = ((start + mod - 1) / mod)*mod ;

    for(; i < end; i+= mod)
    {
	if (i != 0)
	    gtk_wave_set_marker_add(ws, i);
    }
}


void on_dlgmarkers_delete(GtkButton *button, gpointer user_data)
{
    GtkWaveSet		*ws;
    GtkToggleButton	*tb;

    ws = GTK_WAVE_SET(user_data);
    if (!file_open || !ws)
	return;

    /* determine if action is constrained to the selection */
    tb = GTK_TOGGLE_BUTTON(lookup_widget(dlg_markers, "ApplyToSelection"));
    if (tb->active)
	gtk_wave_set_marker_del_sel(ws);
    else
	gtk_wave_set_marker_del_all(ws);
}
