/* popup_menu.c
 *
 * Copyright (C) 2000 Frdric LESPEZ & Renaud CHAILLAT
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <gnome.h>

#include "gnobog_popup_menu.h"
#include "gnobog_arborescence.h"
#include "gnobog_bookmarks.h"
#include "gnobog_edit.h"
#include "gnobog_open_file_dialog.h"
#include "gnobog_app.h"
#include "gnobog_menus.h"
#include "pixmaps/title.xpm"

static GtkWidget* popup = NULL;

static void gnobog_popup_cb_edit (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_toggle_selection (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_show_content (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_show_all (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_copy (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_paste (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_open_document (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_save_document (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_save_document_as (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_save_document_copy_as (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_nothing (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_new_bookmark (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_new_folder (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_new_separator (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_paste_after (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_paste_before (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_paste_into (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_paste_as_new (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_new_document_window (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_toggle_split_view (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_toggle_locations (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_toggle_titles (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_expand_all (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_collapse_all (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_select_all (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_unselect_all (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_netscape_existing (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_netscape_new (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_mozilla_existing (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_mozilla_new (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_galeon_existing (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_galeon_new (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_gnome_handler (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_nautilus_existing (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_nautilus_new (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_konqueror_new (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_opera_existing (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_opera_new (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_lynx_new (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_links_new (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_gftp_new (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_ncftp_new (GtkWidget* widget, gpointer data);
static void gnobog_popup_cb_browse_in_lftp_new (GtkWidget* widget, gpointer data);

/*
 * Menus Definitions
 */

/* SubMenus */
static GnomeUIInfo
browse_submenu [] = {
  GNOMEUIINFO_ITEM_NONE (N_("in Netscape"),                              /* Menu Label */
                         N_("Browse in Netscape existing window"),       /* Tooltips   */
                         gnobog_popup_cb_browse_in_netscape_existing),   /* Callback   */
  GNOMEUIINFO_ITEM_NONE (N_("in Netscape (new window)"),
                         N_("Browse in Netscape new window"),
                         gnobog_popup_cb_browse_in_netscape_new),                               
  GNOMEUIINFO_ITEM_NONE (N_("in Mozilla"),
                         N_("Browse in Mozilla existing window"),
                         gnobog_popup_cb_browse_in_mozilla_existing),
  GNOMEUIINFO_ITEM_NONE (N_("in Mozilla (new window)"),
                         N_("Browse in Mozilla new window"),
                         gnobog_popup_cb_browse_in_mozilla_new),
  GNOMEUIINFO_ITEM_NONE (N_("in Galeon"),
                         N_("Browse in Galeon existing window"),
                         gnobog_popup_cb_browse_in_galeon_existing),
  GNOMEUIINFO_ITEM_NONE (N_("in Galeon (new window)"),
                         N_("Browse in Galeon new window"),
                         gnobog_popup_cb_browse_in_galeon_new),
  GNOMEUIINFO_ITEM_NONE (N_("in Gnome URL Handler"),
                         N_("Browse in Gnome URL Handler"),
                         gnobog_popup_cb_browse_in_gnome_handler),
//  GNOMEUIINFO_ITEM_NONE (N_("in Nautilus"),
//                         N_("Browse in Nautilus existing window"),
//                         gnobog_popup_cb_browse_in_nautilus_existing),
  GNOMEUIINFO_ITEM_NONE (N_("in Nautilus (new window)"),
                         N_("Browse in Nautilus new window"),
                         gnobog_popup_cb_browse_in_nautilus_new),
  GNOMEUIINFO_ITEM_NONE (N_("in Konqueror (new window)"),
                         N_("Browse in Konqueror new window"),
                         gnobog_popup_cb_browse_in_konqueror_new),
  GNOMEUIINFO_ITEM_NONE (N_("in Opera"),
                         N_("Browse in Opera existing window"),
                         gnobog_popup_cb_browse_in_opera_existing),
  GNOMEUIINFO_ITEM_NONE (N_("in Opera (new window)"),
                         N_("Browse in Opera new window"),
                         gnobog_popup_cb_browse_in_opera_new),
  GNOMEUIINFO_ITEM_NONE (N_("in Lynx"),
                         N_("Browse in Lynx"),
                         gnobog_popup_cb_browse_in_lynx_new),
  GNOMEUIINFO_ITEM_NONE (N_("in Links"),
                         N_("Browse in Links"),
                         gnobog_popup_cb_browse_in_links_new),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_NONE (N_("in gFtp"),
                         N_("Browse in gFtp"),
                         gnobog_popup_cb_browse_in_gftp_new),
  GNOMEUIINFO_ITEM_NONE (N_("in NcFtp"),
                         N_("Browse in NcFtp"),
                         gnobog_popup_cb_browse_in_ncftp_new),
  GNOMEUIINFO_ITEM_NONE (N_("in lftp"),
                         N_("Browse in lftp"),
                         gnobog_popup_cb_browse_in_lftp_new),
  GNOMEUIINFO_END
};

static GnomeUIInfo
bookmarks_submenu [] = {
  GNOMEUIINFO_ITEM_NONE (N_("Edit"),
                         N_("Edit bookmark properties"),
                         gnobog_popup_cb_edit),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_NONE (N_("Set as root"),
                         N_("Show only this folder content"),
                         gnobog_popup_cb_show_content),
  GNOMEUIINFO_ITEM_NONE (N_("Show all"),
                         N_("Show entire tree"),
                         gnobog_popup_cb_show_all),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_NONE (N_("Expand All"),
                         N_("Expand all from here"),
                         gnobog_popup_cb_expand_all),
  GNOMEUIINFO_ITEM_NONE (N_("Collapse All"),
                         N_("Collapse all from here"),
                         gnobog_popup_cb_collapse_all),
  //  GNOMEUIINFO_SEPARATOR,
  //  GNOMEUIINFO_ITEM_NONE (N_("Send by mail"),
  //                         N_("Send by mail"),
  //                         gnobog_popup_cb_nothing),
  //  GNOMEUIINFO_ITEM_NONE (N_("Send by ftp"),
  //                         N_("Send by ftp"),
  //                         gnobog_popup_cb_nothing),
  //  GNOMEUIINFO_ITEM_NONE (N_("Send by http"),
  //                         N_("Send by http"),
  //                         gnobog_popup_cb_nothing),
  GNOMEUIINFO_END
};

static GnomeUIInfo
show_submenu [] = {
  GNOMEUIINFO_TOGGLEITEM (N_("Locations"),
                          N_("View or hide locations"),
                          gnobog_popup_cb_toggle_locations, title_xpm),
  GNOMEUIINFO_TOGGLEITEM (N_("Titles"),
                          N_("View or hide columns titles"),
                          gnobog_popup_cb_toggle_titles, title_xpm),
  //  GNOMEUIINFO_TOGGLEITEM (N_("Toolbar"),
  //                          N_("View or hide toolbar"),
  //                          gnobog_popup_cb_nothing, title_xpm),
  GNOMEUIINFO_END
};

static GnomeUIInfo
edition_submenu [] = {
  GNOMEUIINFO_TOGGLEITEM           (N_("Extended Selection"),
				    N_("Toggle extended selection mode"),
				    gnobog_popup_cb_toggle_selection, title_xpm),
  GNOMEUIINFO_MENU_SELECT_ALL_ITEM (gnobog_popup_cb_select_all, NULL),
  GNOMEUIINFO_ITEM_NONE            (N_("Unselect all"),
				    N_("Unselect currently selected bookmarks"),
				    gnobog_popup_cb_unselect_all),

  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_CUT_ITEM        (gnobog_popup_cb_cut, NULL),
  GNOMEUIINFO_MENU_COPY_ITEM       (gnobog_popup_cb_copy, NULL),
  GNOMEUIINFO_MENU_PASTE_ITEM      (gnobog_popup_cb_paste, NULL),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_NONE            (N_("Paste As a New Document"),
				    N_("Paste as a New Document"),
				    gnobog_popup_cb_paste_as_new),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_NONE            (N_("Paste After"),
				    N_("Paste after selected bookmark"),
				    gnobog_popup_cb_paste_after),
  GNOMEUIINFO_ITEM_NONE            (N_("Paste Before"),
				    N_("Paste before selected bookmark"),
				    gnobog_popup_cb_paste_before),
  GNOMEUIINFO_ITEM_NONE            (N_("Paste Into"),
				    N_("Paste into selected bookmark"),
				    gnobog_popup_cb_paste_into),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_CLEAR_ITEM      (gnobog_popup_cb_clear, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo
new_submenu [] = {
  GNOMEUIINFO_ITEM_NONE (N_("New Bookmark"),
                         N_("Insert a new bookmark"),
                         gnobog_popup_cb_new_bookmark),
  GNOMEUIINFO_ITEM_NONE (N_("New Folder"),
                         N_("Insert a new folder"),
                         gnobog_popup_cb_new_folder),
  GNOMEUIINFO_ITEM_NONE (N_("New Separator"),
                         N_("Insert a new separator"),
                         gnobog_popup_cb_new_separator),
  GNOMEUIINFO_END
};

static GnomeUIInfo
window_submenu [] = {
  GNOMEUIINFO_ITEM_NONE  (N_("New window"),
                          N_("Create a new window for this document"),
                          gnobog_popup_cb_new_document_window),
  GNOMEUIINFO_TOGGLEITEM (N_("Split"),
                          N_("Split or unsplit curent view"),
                          gnobog_popup_cb_toggle_split_view, title_xpm),
  GNOMEUIINFO_END
};

static GnomeUIInfo
file_submenu [] = {
  GNOMEUIINFO_MENU_OPEN_ITEM    (gnobog_popup_cb_open_document, NULL),
  GNOMEUIINFO_MENU_SAVE_ITEM    (gnobog_popup_cb_save_document, NULL),
  GNOMEUIINFO_MENU_SAVE_AS_ITEM (gnobog_popup_cb_save_document_as, NULL),
  GNOMEUIINFO_ITEM_NONE         (N_("Save Copy As"),
                                 N_("Save Copy As"),
                                 gnobog_popup_cb_save_document_copy_as),
  GNOMEUIINFO_END
};


/* Toplevel Menu */
static GnomeUIInfo 
popup_menu [] = {
  GNOMEUIINFO_SUBTREE (N_("Bookmarks"), bookmarks_submenu),
  GNOMEUIINFO_SUBTREE (N_("Browse"), browse_submenu),
  GNOMEUIINFO_SUBTREE (N_("Show"), show_submenu),
  GNOMEUIINFO_SUBTREE (N_("Selection"), edition_submenu),
  GNOMEUIINFO_SUBTREE (N_("New"), new_submenu),
  GNOMEUIINFO_SUBTREE (N_("Window"), window_submenu),
  GNOMEUIINFO_MENU_FILE_TREE  (file_submenu),
  GNOMEUIINFO_END
};

/*
 * End of Menus Definitions
 */

void
gnobog_popup_menu_set (GtkWidget* app)
{
  g_return_if_fail (app != NULL);

  popup = gnome_popup_menu_new_with_accelgroup (popup_menu, 
						GNOME_APP (app)->accel_group);
}

GtkWidget*
gnobog_popup_menu_get_popup (void)
{
  return popup;
}


/* TODO: we should use some #define for path strings */
void
gnobog_popup_menu_do_popup (GtkWidget* view,
			    GdkEventButton* event, 
			    gpointer data)
{
  GtkWidget*  save_as_item;
  GtkWidget*  paste_item;  /* all paste-like menu items */
  GtkWidget*  edit_item;   /* all items that need a selection */
  GtkWidget*  window_split_item;
  GtkWidget*  extended_selection_item;
  GtkWidget*  show_locations_item;
  GtkWidget*  show_titles_item;
  //  GtkWidget*  show_toolbar_item;
  gint        selection_mode;
  gboolean    titles_visibility;
  gboolean    locations_visibility;
  gboolean    clipboard_full;
  gboolean    selection_exists;
  gpointer    splitted_window;


  /* Set unsensitive inappropriate menu items 
   * TODO:
   * - should ask view (i.e. arbo for now) to know what's appropriate
   * - should take view as a parameter and not directly arbo, we need 
   *   to abstract the view
   */

  /* TODO: drop_zone should *not* be a special case, we must add flags on 
   *       bookmarks objects
   */
  save_as_item = gnobog_menus_get_menu_item_from_path (popup, "_File/Save _As...");
  if ( NULL != save_as_item ) {
    if ( GNOBOG_ARBORESCENCE(view)->bookmarks_watched == (GnobogBookmarks*)data ) {
      gtk_widget_set_sensitive (save_as_item, FALSE);
    } else {
      gtk_widget_set_sensitive (save_as_item, TRUE);
    }
  }

  /* Active only if there's something to paste */
  clipboard_full =  !gnobog_app_is_clipboard_empty ();
  paste_item = gnobog_menus_get_menu_item_from_path (popup, 
						     "Selection/Paste As a New Document"); 
  if ( NULL != paste_item ) { 
    gtk_widget_set_sensitive (paste_item, clipboard_full); 
  } 
  paste_item = gnobog_menus_get_menu_item_from_path (popup, 
						     "Selection/_Paste"); 
  if ( NULL != paste_item ) { 
    gtk_widget_set_sensitive (paste_item, clipboard_full); 
  } 
  paste_item = gnobog_menus_get_menu_item_from_path (popup, 
						     "Selection/Paste After"); 
  if ( NULL != paste_item ) { 
    gtk_widget_set_sensitive (paste_item, clipboard_full); 
  } 
  paste_item = gnobog_menus_get_menu_item_from_path (popup, 
						     "Selection/Paste Before"); 
  if ( NULL != paste_item ) { 
    gtk_widget_set_sensitive (paste_item, clipboard_full); 
  } 
  paste_item = gnobog_menus_get_menu_item_from_path (popup, 
						     "Selection/Paste Into"); 
  if ( NULL != paste_item ) { 
    gtk_widget_set_sensitive (paste_item, clipboard_full); 
  } 


  /* Active only if there's something selected */
  selection_exists = gnobog_arborescence_selection_exists (GNOBOG_ARBORESCENCE (view));
  edit_item = gnobog_menus_get_menu_item_from_path (popup, 
						    "Bookmarks/Edit"); 
  if ( NULL != edit_item ) { 
    gtk_widget_set_sensitive (edit_item, selection_exists); 
  } 
  edit_item = gnobog_menus_get_menu_item_from_path (popup, 
						    "Bookmarks/Set as root"); 
//  if ( NULL != edit_item ) { 
//    gtk_widget_set_sensitive (edit_item, selection_exists); 
//  } 
//  edit_item = gnobog_menus_get_menu_item_from_path (popup, 
//						    "Bookmarks/Show all"); 
  if ( NULL != edit_item ) { 
    gtk_widget_set_sensitive (edit_item, selection_exists); 
  } 
  edit_item = gnobog_menus_get_menu_item_from_path (popup, 
						    "Browse"); 
  if ( NULL != edit_item ) { 
    gtk_widget_set_sensitive (edit_item, selection_exists); 
  } 
  edit_item = gnobog_menus_get_menu_item_from_path (popup, 
						    "Selection/Unselect all"); 
  if ( NULL != edit_item ) { 
    gtk_widget_set_sensitive (edit_item, selection_exists); 
  } 
  edit_item = gnobog_menus_get_menu_item_from_path (popup, 
						    "Selection/Copy"); 
  if ( NULL != edit_item ) { 
    gtk_widget_set_sensitive (edit_item, selection_exists); 
  } 
  edit_item = gnobog_menus_get_menu_item_from_path (popup, 
						    "Selection/Cut"); 
  if ( NULL != edit_item ) { 
    gtk_widget_set_sensitive (edit_item, selection_exists); 
  } 
  edit_item = gnobog_menus_get_menu_item_from_path (popup, 
						    "Selection/C_lear"); 
  if ( NULL != edit_item ) { 
    gtk_widget_set_sensitive (edit_item, selection_exists); 
  } 



  /* Set toggle buttons in the right state */
  //  show_toolbar_item = gnobog_menus_get_menu_item_from_path (popup, "Show/Toolbar");
  //  if ( NULL != show_toolbar_item ) {
  //    gtk_widget_set_sensitive (show_toolbar_item, FALSE);
  //  }
  extended_selection_item = gnobog_menus_get_menu_item_from_path (popup,
								  "Selection/Extended Selection");
  if ( NULL != extended_selection_item ) {
    selection_mode = gnobog_arborescence_get_selection_mode (GNOBOG_ARBORESCENCE(view));
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (extended_selection_item), 
				    (DND_TIMER_ONLY_MODE == selection_mode));
  }
  show_titles_item  = gnobog_menus_get_menu_item_from_path (popup,
							    "Show/Titles");
  if ( NULL != show_titles_item ) {
    titles_visibility = gnobog_arborescence_get_titles_visibility (GNOBOG_ARBORESCENCE(view));
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (show_titles_item), 
				    titles_visibility);
  }
  show_locations_item  = gnobog_menus_get_menu_item_from_path (popup,
							       "Show/Locations");
  if ( NULL != show_locations_item ) {
    locations_visibility = gnobog_arborescence_get_column_visibility (GNOBOG_ARBORESCENCE(view), 
								      2);
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (show_locations_item), 
				    locations_visibility);
  }
  window_split_item  = gnobog_menus_get_menu_item_from_path (popup,
							       "Window/Split");
  if ( NULL != window_split_item ) {
    splitted_window = gtk_object_get_data (GTK_OBJECT (view),
					   "splitted window");
    if ( NULL == splitted_window ) splitted_window = GINT_TO_POINTER (FALSE);
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (window_split_item), 
				    GPOINTER_TO_INT (splitted_window));
  }


  /* Show Popup 
   * We don't need to pass the view as data anymore, since we 
   * keep a pointer to the active view (for keyboard accelerators)
   */
  gnome_popup_menu_do_popup (popup, NULL, NULL, event, NULL);

}







static void
gnobog_popup_cb_nothing (GtkWidget* widget, 
			 gpointer data)
{
  GtkWidget*    dialog;
  dialog = gnome_ok_dialog (_("This does nothing; it is only a demonstration."));
  return;
}

/* 'Edit' callback */
static void
gnobog_popup_cb_edit (GtkWidget* widget, 
		      gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_ui_edit_bookmark_properties (bookmarks, bookmarks_node);
  }
}

static void
gnobog_popup_cb_toggle_selection (GtkWidget* extended_selection_item, 
				  gpointer data)
{
  GnobogArborescence*   arborescence;
  GtkCheckMenuItem*     check_menu_item;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  if ( NULL != extended_selection_item ) {
    check_menu_item = GTK_CHECK_MENU_ITEM (extended_selection_item);
    if ( TRUE == check_menu_item->active ) {
      gnobog_arborescence_set_selection_mode (arborescence, DND_TIMER_ONLY_MODE);
    } else {
      gnobog_arborescence_set_selection_mode (arborescence, WINDOWS_MODE);
    }
  }

  /* old        
  if ( gnobog_arborescence_get_selection_mode (arborescence) == WINDOWS_MODE ) {
    gnobog_arborescence_set_selection_mode (arborescence, DND_TIMER_ONLY_MODE);
  } else {
    gnobog_arborescence_set_selection_mode (arborescence, WINDOWS_MODE);
  }
  */
}

static void
gnobog_popup_cb_show_content (GtkWidget* widget, 
			      gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;
  GList*                                content_list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    content_list = gnobog_bookmarks_get_folder_content (bookmarks, bookmarks_node);
    if (content_list != NULL) {
      gnobog_arborescence_clear (arborescence, NULL);
      gnobog_arborescence_list_insert (arborescence, NULL, INSERT_INTO, content_list, NULL);
      gnobog_arborescence_unselect_all (arborescence);
      gtk_ctree_expand_to_depth (GTK_CTREE(arborescence), NULL, 3);
    }
  }
}

static void
gnobog_popup_cb_show_all (GtkWidget* widget, 
			  gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarks*      bookmarks;
  GList*                                content_list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  bookmarks = arborescence->bookmarks_watched;

  /* should work as _get_list */
  content_list = gnobog_bookmarks_get_folder_content (bookmarks, NULL);
  if (content_list != NULL) {
    gnobog_arborescence_clear (arborescence, NULL);
    gnobog_arborescence_list_insert (arborescence, NULL, INSERT_INTO, content_list, NULL);
    gnobog_arborescence_unselect_all (arborescence);
    gtk_ctree_expand_to_depth (GTK_CTREE(arborescence), NULL, 3);
  }
}

static void 
gnobog_popup_cb_open_document (GtkWidget* widget, 
			       gpointer data)
{
  gnobog_ui_open_file (widget, gnobog_app_get_app ());
}

static void
gnobog_popup_cb_save_document ( GtkWidget* widget, gpointer data )
{
  GnobogArborescence*   arborescence;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  gnobog_app_document_save (arborescence->bookmarks_watched);

  /* TODO: tell user if save was successful */
}


static void
gnobog_popup_cb_save_document_as (GtkWidget* widget, 
				  gpointer data)
{
  GnobogArborescence*   arborescence;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
                
  gnobog_app_document_save_as (arborescence->bookmarks_watched);
}


static void 
gnobog_popup_cb_save_document_copy_as (GtkWidget* widget, 
				       gpointer data)
{
  GnobogArborescence*   arborescence;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
                
  gnobog_app_document_save_copy_as (arborescence->bookmarks_watched);
}

void
gnobog_popup_cb_clear (GtkWidget* widget, 
		       gpointer data)
{
  GnobogArborescence*   arborescence;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    gnobog_bookmarks_list_delete (arborescence->bookmarks_watched, list);
  }
}

void
gnobog_popup_cb_cut (GtkWidget* widget, 
		     gpointer data)
{
  GnobogArborescence*   arborescence;
  GList*                                list;
        
  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    gnobog_app_copy_to_clipboard (arborescence->bookmarks_watched, list);
    gnobog_bookmarks_list_delete (arborescence->bookmarks_watched, list);
  }
}

static void
gnobog_popup_cb_copy (GtkWidget* widget, 
		      gpointer data)
{
  GnobogArborescence*   arborescence;
  GList*                list;
        
  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    gnobog_app_copy_to_clipboard (arborescence->bookmarks_watched, list);
  }
}

static void
gnobog_popup_cb_paste (GtkWidget* widget, 
		       gpointer data)
{
  GnobogArborescence*   arborescence;
  GList*                list;
  GnobogBookmarksNode   anchor_node;
        
  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);

  if ( list != NULL ) {
    anchor_node = list->data;
  } else {
    anchor_node = NULL; /* root */
  }
  gnobog_app_paste_from_clipboard (arborescence->bookmarks_watched,
				   anchor_node, 
				   INSERT_DEFAULT_MODE);
}

static void
gnobog_popup_cb_paste_after (GtkWidget* widget, 
			     gpointer data)
{
  GnobogArborescence*   arborescence;
  GList*                list;
  GnobogBookmarksNode   anchor_node;
        
  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    anchor_node = list->data;
    gnobog_app_paste_from_clipboard ( arborescence->bookmarks_watched,
                                      anchor_node, INSERT_AFTER );
  }
}

static void
gnobog_popup_cb_paste_before (GtkWidget* widget, 
			      gpointer data)
{
  GnobogArborescence*   arborescence;
  GList*                                list;
  GnobogBookmarksNode   anchor_node;
        
  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    anchor_node = list->data;
    gnobog_app_paste_from_clipboard ( arborescence->bookmarks_watched,
                                      anchor_node, INSERT_BEFORE );
  }
}

static void
gnobog_popup_cb_paste_into (GtkWidget* widget, 
			    gpointer data)
{
  GnobogArborescence*   arborescence;
  GList*                                list;
  GnobogBookmarksNode   anchor_node;
        
  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    anchor_node = list->data;
    gnobog_app_paste_from_clipboard ( arborescence->bookmarks_watched,
                                      anchor_node, INSERT_INTO );
  }
}

static void
gnobog_popup_cb_paste_as_new (GtkWidget* widget, 
			      gpointer data)
{
  GnobogArborescence*   arborescence;
  GList*                list;
        
  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    gnobog_app_copy_to_clipboard (arborescence->bookmarks_watched, list);
    gnobog_app_document_new_from_selection ();
  }
}


static void
gnobog_popup_cb_new_bookmark (GtkWidget* widget, 
			      gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   anchor_node;
  GnobogBookmarks*              bookmarks;
  GList*                                        list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    anchor_node = list->data;
  } else {
    anchor_node = NULL;
  }

  gnobog_ui_insert_new_bookmark (bookmarks, anchor_node);
}

static void
gnobog_popup_cb_new_folder (GtkWidget* widget, 
			    gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   anchor_node;
  GnobogBookmarks*              bookmarks;
  GList*                                        list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    anchor_node = list->data;
  } else {
    anchor_node = NULL;
  }

  gnobog_ui_insert_new_folder (bookmarks, anchor_node);
}

static void
gnobog_popup_cb_new_separator (GtkWidget* widget, 
			       gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   anchor_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    anchor_node = list->data;
  } else {
    anchor_node = NULL;
  }

  gnobog_bookmarks_node_insert_new_separator (bookmarks, anchor_node, INSERT_DEFAULT_MODE);
}



static void
gnobog_popup_cb_new_document_window (GtkWidget* widget, 
				     gpointer data)
{
  GnobogArborescence*   arborescence;
                        
  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  gnobog_app_document_window_new (arborescence->bookmarks_watched);
}


/* TODO: see gnobog_app_split_view TODO, don't spend time on the current implementation... */
static void
gnobog_popup_cb_toggle_split_view (GtkWidget* window_split_item, 
				   gpointer data)
{
  GnobogArborescence*   arborescence;
  GtkCheckMenuItem*     check_menu_item;
  gpointer    splitted_window;
        
  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  /* Quick hack to not be a toggle anymore, and react 
   * appropriately to the state of the toggle menu item.
   */
  splitted_window = gtk_object_get_data (GTK_OBJECT (arborescence),
					 "splitted window");
  if ( NULL == splitted_window ) splitted_window = GINT_TO_POINTER (FALSE);
                        
        
  if ( NULL != window_split_item ) {
    check_menu_item = GTK_CHECK_MENU_ITEM (window_split_item);
    if ( (TRUE == check_menu_item->active && FALSE == GPOINTER_TO_INT(splitted_window)) ||
	 (FALSE == check_menu_item->active && TRUE == GPOINTER_TO_INT(splitted_window))   ) {
      gnobog_app_toggle_split_view (arborescence);
    } 
  }
}

static void
gnobog_popup_cb_toggle_locations (GtkWidget* show_locations_item, 
				  gpointer data)
{
  GnobogArborescence*   arborescence;
  GtkCheckMenuItem*     check_menu_item;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  if ( NULL != show_locations_item ) {
    check_menu_item = GTK_CHECK_MENU_ITEM (show_locations_item);
    if ( TRUE == check_menu_item->active ) {
      gnobog_arborescence_set_column_visibility (arborescence, 2, TRUE);
    } else {
      gnobog_arborescence_set_column_visibility (arborescence, 2, FALSE);
    }
  }
}

static void
gnobog_popup_cb_toggle_titles (GtkWidget* show_titles_item, 
			       gpointer data)
{
  GnobogArborescence*   arborescence;
  GtkCheckMenuItem*     check_menu_item;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  if ( NULL != show_titles_item ) {
    check_menu_item = GTK_CHECK_MENU_ITEM (show_titles_item);
    if ( TRUE == check_menu_item->active ) {
      gnobog_arborescence_set_titles_visibility (arborescence, TRUE);
    } else {
      gnobog_arborescence_set_titles_visibility (arborescence, FALSE);
    }
  }
}

static void
gnobog_popup_cb_select_all (GtkWidget* widget, 
			    gpointer data)
{
  GnobogArborescence*   arborescence;
                        
  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  gnobog_arborescence_select_all (arborescence);
}

static void
gnobog_popup_cb_unselect_all (GtkWidget* widget, 
			      gpointer data)
{
  GnobogArborescence*   arborescence;
                        
  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  gnobog_arborescence_unselect_all (arborescence);
}


static void
gnobog_popup_cb_expand_all (GtkWidget* widget, 
			    gpointer data)
{
  GnobogArborescence*   arborescence;
                        
  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  gtk_ctree_expand_recursive (GTK_CTREE(arborescence), NULL);
}

static void
gnobog_popup_cb_collapse_all (GtkWidget* widget, 
			      gpointer data)
{
  GnobogArborescence*   arborescence;
                        
  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  gtk_ctree_collapse_recursive ( GTK_CTREE(arborescence), NULL );
}

/* TODO TODO TODO TODO */
//static void
//gnobog_popup_cb_expand_all_to_selected_node_depth (GtkWidget* widget, gpointer data)
//{
//      GnobogArborescence*     arborescence;
//                      
//      g_return_if_fail (GNOBOG_IS_ARBORESCENCE (data));
//
//      arborescence = GNOBOG_ARBORESCENCE (data);
//      gtk_ctree_expand_to_depth (GTK_CTREE(arborescence), NULL, 3);
//}

static void
gnobog_popup_cb_browse_in_netscape_existing (GtkWidget* widget, 
					     gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           NETSCAPE_BROWSER,
                                           FALSE);
  }
}

static void
gnobog_popup_cb_browse_in_netscape_new (GtkWidget* widget, 
					gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           NETSCAPE_BROWSER,
                                           TRUE);
  }
}

static void
gnobog_popup_cb_browse_in_mozilla_existing (GtkWidget* widget, 
					    gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           MOZILLA_BROWSER,
                                           FALSE);
  }
}

static void
gnobog_popup_cb_browse_in_mozilla_new (GtkWidget* widget, 
				       gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           MOZILLA_BROWSER,
                                           TRUE);
  }
}

static void
gnobog_popup_cb_browse_in_galeon_existing (GtkWidget* widget, 
					   gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           GALEON_BROWSER,
                                           FALSE);
  }
}

static void
gnobog_popup_cb_browse_in_galeon_new (GtkWidget* widget, 
				      gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           GALEON_BROWSER,
                                           TRUE);
  }
}

static void
gnobog_popup_cb_browse_in_gnome_handler (GtkWidget* widget, 
					 gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           GNOME_HANDLER_BROWSER,
                                           FALSE);
  }
}

static void
gnobog_popup_cb_browse_in_nautilus_existing (GtkWidget* widget, 
					     gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           NAUTILUS_BROWSER,
                                           FALSE);
  }
}

static void
gnobog_popup_cb_browse_in_nautilus_new (GtkWidget* widget, 
					gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           NAUTILUS_BROWSER,
                                           TRUE);
  }
}

static void
gnobog_popup_cb_browse_in_konqueror_new (GtkWidget* widget, 
					 gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           KONQUEROR_BROWSER,
                                           TRUE);
  }
}

static void
gnobog_popup_cb_browse_in_opera_existing (GtkWidget* widget,
				     gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           OPERA_BROWSER,
                                           FALSE);
  }
}

static void
gnobog_popup_cb_browse_in_opera_new (GtkWidget* widget,
				     gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());

  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           OPERA_BROWSER,
                                           TRUE);
  }
}

static void
gnobog_popup_cb_browse_in_lynx_new (GtkWidget* widget, 
				    gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           LYNX_BROWSER,
                                           TRUE);
  }
}

static void
gnobog_popup_cb_browse_in_links_new (GtkWidget* widget, 
				     gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           LINKS_BROWSER,
                                           TRUE);
  }
}

static void
gnobog_popup_cb_browse_in_gftp_new (GtkWidget* widget, 
				    gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           GFTP_BROWSER,
                                           TRUE);
  }
}

static void
gnobog_popup_cb_browse_in_ncftp_new (GtkWidget* widget, 
				     gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           NCFTP_BROWSER,
                                           TRUE);
  }
}

static void
gnobog_popup_cb_browse_in_lftp_new (GtkWidget* widget, 
				    gpointer data)
{
  GnobogArborescence*   arborescence;
  GnobogBookmarksNode   bookmarks_node;
  GnobogBookmarks*      bookmarks;
  GList*                                list;

  arborescence = GNOBOG_ARBORESCENCE (gnobog_app_get_active_view ());
        
  bookmarks = arborescence->bookmarks_watched;

  list = gnobog_arborescence_get_sorted_bookmarks_node_selection (arborescence);
  if (list != NULL) {
    bookmarks_node = list->data;
    gnobog_bookmarks_node_view_in_browser (arborescence->bookmarks_watched,
                                           bookmarks_node,
                                           LFTP_BROWSER,
                                           TRUE);
  }
}
