.\" Copyright (c) 1993, 2000, 2003 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution
.TH databases 5 "August 2003" "GNATS @VERSION@" "GNATS configuration files"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
databases \- the known set of GNATS databases
.SH DESCRIPTION
The \fBdatabases\fR configuration file is a site-wide configuration
file containing the list of GNATS databases that are available either
on the host itself or remotely over the network, together with some
parameters associated with each database.  It is located in the
directory @PREFIX@/share/gnats.
.P
The file contains one line for each database. For databases located on
the host itself, each line consists of three fields separated by
colons:
.P
.RS
database name:short description:/path/to/database
.RE
.P
The first field is the database name.  This is the name used to
identify the database when invoking programs such as \fBquery-pr\fR or
\fBsend-pr\fR, either by using the \fB--database\fR option of the
program or by setting the \fBGNATSDB\fR environment variable to the
name of the database.  The second field is a short human-readable
description of the database contents, and the final field is the
directory where the database contents are kept.
.P
For a database that is located across a network, but which should be
accessible from this host, the entry for the database should look
like this:
.P
.RS
database name:short description of database::hostname:port
.RE
.P
The first two fields are the same as for local databases, the third
field is empty (notice the two adjacent `:' symbols, indicating an
empty field), the fourth field is the hostname of the remote GNATS
server, and the fifth field is the port number that the remote
GNATS server is running on.
.P
Note that if you add a new local database, you must create its data
directory, including appropriate subdirectories and administrative
files after adding an entry to \fBdatabases\fR.  This is best done
using the \fBmkdb\fR tool.
.P
Lines beginning with a # are ignored.
.P
The database name \fBdefault\fR is special; this is the entry used if
no database name is specified via a \fB--database\fR option or the
\fBGNATSDB\fR environment variable.
.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
.LP
.BR databases (5),
.BR dbconfig (5),
.BR delete-pr (8),
.BR edit-pr (1)
.BR file-pr (8),
.BR gen-index (8),
.BR gnats (7),
.BR gnatsd (8),
.BR mkcat (8),
.BR mkdb (8),
.BR pr-edit (8),
.BR query-pr (1),
.BR queue-pr (8),
.BR send-pr (1).
.SH COPYING
Copyright (c) 1993, 2000, 2003, Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
