/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <dirent.h>

#include "config.h"
#include "window.h"
#include "help.h"
#include "misc.h"
#include "settings.h"

GtkWidget *help_window = NULL;
GtkWidget *help_data;
char *locale;
char *help_file_dir = NULL;

char *get_locale() {
#define return_if_env(v) l = g_getenv(v); if (l && *l) return g_strdup(l)
	char *l;
	return_if_env("LC_ALL");
	return_if_env("LC_MESSAGES");
	return_if_env("LANG");
	return "C";
#undef return_if_env
}

void create_help_window();
void load_file_in_help_window(const char *filename);

void create_help_file_dir()
{
	char *s;

	if (!locale)
		locale = get_locale();

	if (help_file_dir)
		return;

	help_file_dir = g_strconcat(SHAREDIR, "/gmoo/help/", locale, NULL);
	if(is_dir(help_file_dir))
		return;
	g_free(help_file_dir);
	
	/* nl_NL@euro -> nl_NL */
	if ((s = strchr(locale, '@'))) {
	       	*s = '\0';
		help_file_dir = g_strconcat(SHAREDIR, "/gmoo/help/", locale, NULL);
		if(is_dir(help_file_dir))
			return;
		g_free(help_file_dir);
	}
	/* nl_NL -> nl */
	if ((s = strchr(locale, '_'))) {
	       	*s = '\0';
		help_file_dir = g_strconcat(SHAREDIR, "/gmoo/help/", locale, NULL);
		if(is_dir(help_file_dir))
			return;
		g_free(help_file_dir);
	}
	help_file_dir = g_strconcat(SHAREDIR, "/gmoo/help/C", NULL);
}

void gm_help_show(GtkWidget *w, const char *chapter) {
	GtkWindow *win;
	char *filename;

	if(debug) printf("Showing help for chapter \"%s\"\n", chapter);
	create_help_window();

	create_help_file_dir();
	filename = g_strconcat(help_file_dir, "/", chapter, NULL);
	load_file_in_help_window(filename);
	g_free(filename);

	win = GTK_WINDOW(gtk_widget_get_toplevel(w));
	gtk_window_set_modal(GTK_WINDOW(help_window), win->modal);

	gtk_widget_show(help_window);
}

void load_file_in_help_window(const char *filename) {
	extern GtkWidget *main_window;
	FILE *file;
	char buf[256];
	int len;
	int maxlen;
	// changed NULL to gtk_widget_get_style(main_window)->font;
	// also added extern GtkWidtget *main_window before method
	// this fixes:
	// Gdk-CRITICAL **: file gdkfont.c: line 452 (gdk_char_width):
	// assertion `font != NULL' failed.
	GdkFont *font = gtk_widget_get_style(main_window)->font;


	if((file = fopen(filename, "r"))) {
		if(debug) printf("\tLoading file \"%s\"\n", filename);
		maxlen = 0;
		while(fgets(buf, 255, file)) {
			len = strlen(buf);
			maxlen = MAX(maxlen, len);
			gtk_text_insert(GTK_TEXT(help_data), font, NULL, NULL, buf, len);
		}
		fclose(file);
	} else {
		if(debug) printf("\tLoading file \"%s\" failed\n", filename);
		gtk_text_insert(GTK_TEXT(help_data), font, NULL, NULL,
				"Couldn't open help file:\n", -1);
		gtk_text_insert(GTK_TEXT(help_data), font, NULL, NULL, filename, -1);
		maxlen = MAX(strlen(filename), 24);
	}
	len = gdk_char_width(font, 'M');
	gtk_widget_set_usize(help_data, maxlen * (len + 2), 300);
}

void help_close_window() {
	gtk_widget_destroy(help_window);
	help_window = NULL;
	if(debug) printf("Help window closed\n");
}

void create_help_window() {
	GtkWidget *vbox;
	GtkWidget *scrollw;
	GtkWidget *tmp;
	GtkWidget *hbb;

	if(help_window) {
		gtk_editable_delete_text(GTK_EDITABLE(help_data), 0,
					 gtk_text_get_length(GTK_TEXT(help_data)));
		if(debug) printf("\tReusing help window\n");
		return;
	}
	if(debug) printf("\tCreating help window\n");

	help_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_transient_for(GTK_WINDOW(help_window),
				     GTK_WINDOW(gm_window_get_window()));
	gtk_window_set_title(GTK_WINDOW(help_window), _("gmoo help"));
	gtk_window_set_position(GTK_WINDOW(help_window), GTK_WIN_POS_MOUSE);
	gtk_window_set_wmclass(GTK_WINDOW(help_window), "gmoo_help_dialog", "gmoo");
	gtk_signal_connect(GTK_OBJECT(help_window), "delete_event",
			   GTK_SIGNAL_FUNC(help_close_window), NULL);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(help_window), vbox);

	scrollw = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(scrollw);
	gtk_box_pack_start(GTK_BOX(vbox), scrollw, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(scrollw), 5);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollw),
				       GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	help_data = gtk_text_new(NULL, NULL);
	gtk_widget_show(help_data);
	gtk_container_add(GTK_CONTAINER(scrollw), help_data);
	GTK_WIDGET_UNSET_FLAGS(help_data, GTK_CAN_FOCUS);

	tmp = gtk_hseparator_new();
	gtk_widget_show(tmp);
	gtk_box_pack_start(GTK_BOX(vbox), tmp, FALSE, TRUE, 0);

	hbb = gtk_hbutton_box_new();
	gtk_widget_show(hbb);
	gtk_box_pack_start(GTK_BOX(vbox), hbb, FALSE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbb), 5);

	tmp = gtk_button_new_with_label(_("Ok"));
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(hbb), tmp);
	GTK_WIDGET_SET_FLAGS(tmp, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(tmp), "clicked",
			   GTK_SIGNAL_FUNC(help_close_window), NULL);

	gtk_widget_grab_default(tmp);
}


void gm_help_about() {
	GtkWidget *dialog1;
	GtkWidget *dialog_vbox1;
	GtkWidget *frame1;
	GtkWidget *table1;
	GtkWidget *hseparator1;
	GtkWidget *label3;
	GtkWidget *label4;
	GtkWidget *label5;
	GtkWidget *label6;
	GtkWidget *label7;
	GtkWidget *dialog_action_area1;
	GtkWidget *hbuttonbox1;
	GtkWidget *button1;

	dialog1 = gtk_dialog_new ();
	gtk_object_set_data (GTK_OBJECT (dialog1), "dialog1", dialog1);
	gtk_window_set_title (GTK_WINDOW (dialog1), _("About"));
	gtk_window_set_policy (GTK_WINDOW (dialog1), TRUE, TRUE, FALSE);

	dialog_vbox1 = GTK_DIALOG (dialog1)->vbox;
	gtk_object_set_data (GTK_OBJECT (dialog1), "dialog_vbox1", dialog_vbox1);
	gtk_widget_show (dialog_vbox1);

	frame1 = gtk_frame_new (NULL);
	gtk_widget_ref (frame1);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "frame1", frame1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), frame1, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);

	table1 = gtk_table_new (4, 2, FALSE);
	gtk_widget_ref (table1);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "table1", table1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table1);
	gtk_container_add (GTK_CONTAINER (frame1), table1);

	hseparator1 = gtk_hseparator_new ();
	gtk_widget_ref (hseparator1);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "hseparator1", hseparator1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hseparator1);
	gtk_table_attach (GTK_TABLE (table1), hseparator1, 0, 2, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	label3 = gtk_label_new (_("gmoo "VERSION));
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "label3", label3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_table_attach (GTK_TABLE (table1), label3, 0, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_misc_set_padding (GTK_MISC (label3), 5, 5);

	label4 = gtk_label_new (_("Author:"));
	gtk_widget_ref (label4);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "label4", label4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_table_attach (GTK_TABLE (table1), label4, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 5, 5);
	gtk_misc_set_alignment (GTK_MISC (label4), 7.45058e-09, 7.45058e-09);

	label5 = gtk_label_new (_("Gert Scholten"));
	gtk_widget_ref (label5);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "label5", label5,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label5);
	gtk_table_attach (GTK_TABLE (table1), label5, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label5), 7.45058e-09, 7.45058e-09);
	gtk_misc_set_padding (GTK_MISC (label5), 5, 5);

	label6 = gtk_label_new (_("Thanks to:"));
	gtk_widget_ref (label6);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "label6", label6,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label6);
	gtk_table_attach (GTK_TABLE (table1), label6, 0, 1, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label6), 7.45058e-09, 7.45058e-09);
	gtk_misc_set_padding (GTK_MISC (label6), 5, 5);

	label7 = gtk_label_new (_("Debian package maintainer\nand debug tester:\nPaul van Tilburg"));
	gtk_widget_ref (label7);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "label7", label7,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label7);
	gtk_table_attach (GTK_TABLE (table1), label7, 1, 2, 3, 4,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label7), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label7), 0, 0);
	gtk_misc_set_padding (GTK_MISC (label7), 5, 5);

	dialog_action_area1 = GTK_DIALOG (dialog1)->action_area;
	gtk_object_set_data (GTK_OBJECT (dialog1), "dialog_action_area1", dialog_action_area1);
	gtk_widget_show (dialog_action_area1);
	gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

	hbuttonbox1 = gtk_hbutton_box_new ();
	gtk_widget_ref (hbuttonbox1);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "hbuttonbox1", hbuttonbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbuttonbox1);
	gtk_box_pack_start (GTK_BOX (dialog_action_area1), hbuttonbox1, TRUE, TRUE, 0);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox1), GTK_BUTTONBOX_END);

	button1 = gtk_button_new_with_label (_("OK"));
	gtk_widget_ref (button1);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "button1", button1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button1);
	gtk_container_add (GTK_CONTAINER (hbuttonbox1), button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);

	gtk_signal_connect_object(GTK_OBJECT (dialog1), "delete_event",
				  GTK_SIGNAL_FUNC (gtk_widget_destroy),
				  GTK_OBJECT(dialog1));
	gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
				   GTK_SIGNAL_FUNC (gtk_widget_destroy),
				   GTK_OBJECT (dialog1));

	gtk_widget_grab_default (button1);


	gtk_widget_show(dialog1);
}
