// PREFS.H: Handle user preferences/configuration 
//             Can be overloaded by subclasses, e.g. GNOME config

// Copyright (C) 2001 Geoffrey Hutchison

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#ifndef PREFS_H
#define PREFS_H

/*################################################################################################*/

#include "config.h"

class prefs;
class console_prefs;

/*################################################################################################*/

/**	Various methods for setting or getting user prefs
	These may be overloaded by subclasses (e.g. GUI dialogues).
*/

class prefs
{
	protected:
	
	public:
	
	prefs(void) { }
	virtual ~prefs(void) { }

	// Set preferences (key, value(s)
	virtual void Add(const char *, const char *) = 0;
	virtual void Add(const char *, const int) = 0;
	virtual void Add(const char *, const double) = 0;
	virtual void Add(const char *, const bool) = 0;
	// Used for colors -- either RGB or RGBA
	virtual void Add(const char *, const float, const float, const float) = 0;
	virtual void Add(const char *, const float, const float, const float, const float) = 0;

	// Get preferences (key, default value)
	virtual char * Find(const char *, const char *) = 0;
	virtual int    Value(const char *, const int) = 0;
	virtual double Double(const char *, const double) = 0;
	virtual bool   Boolean(const char *, const bool) = 0;
	virtual float *ColorRGB(const char *, const float[3]) = 0;
	virtual float *ColorRGBA(const char *, const float[4]) = 0;
};

class console_prefs : public prefs
{
	protected:
	
	public:
	
	console_prefs(void);
	~console_prefs(void);

	void Add(const char *, const char *);
	void Add(const char *, const int);
	void Add(const char *, const double);
	void Add(const char *, const bool);
	void Add(const char *, const float, const float, const float);
	void Add(const char *, const float, const float, const float, const float);

	// Get preferences (key, default value)
	char * Find(const char *, const char *);		// this will allocate memory with new!!!
	int    Value(const char *, const int);
	double Double(const char *, const double);
	bool   Boolean(const char *, const bool);
	float *ColorRGB(const char *, const float[3]);		// this will allocate memory with new!!!
	float *ColorRGBA(const char *, const float[4]);		// this will allocate memory with new!!!
};

/*################################################################################################*/

#endif	// PREFS_H

// eof
