// MM3MDL.CPP

// Copyright (C) 2000 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "mm3mdl.h"
#include "mm2mdl.h"

/*################################################################################################*/

mm3_mdl::mm3_mdl(ostream * p1, class_factory & p2) : model_simple(p1, p2)
{
}

mm3_mdl::~mm3_mdl(void)
{
}

const char * mm3_mdl::GetProjectFileNameExtension(void)
{
	static const char ext[] = "mm3gp";
	return ext;
}

void mm3_mdl::Reduce(mm2_mdl * mdl, i32s chn)
{
	for (i32s n1 = 0;n1 < (i32s) mdl->chn_vector.size();n1++)
	{
		if (chn != NOT_DEFINED && chn != n1) continue;
		
		mm3_chn * curr_chn = new mm3_chn;
		
		char previous = 'L';
		i32s first_in_this_element = -1;
		
		for (i32s n2 = 0;n2 < (i32s) mdl->chn_vector[n1].res_vector.size();n2++)
		{
			char current;
			switch (mdl->chn_vector[n1].res_vector[n2].state)
			{
				case STATE_HELIX:	current = 'H'; break;
				case STATE_STRAND:	current = 'S'; break;
				default:		current = 'L';
			}
			
			if (previous != 'L')
			{
				if (current != previous)
				{
					mm3_sse * new_sse = NULL;
					
					switch (previous)
					{
						case 'H':
						new_sse = CreateHelix(mdl, n1, first_in_this_element, n2);
						break;
						
						case 'S':
						new_sse = CreateStrand(mdl, n1, first_in_this_element, n2);
						break;
					}
					
					if (new_sse != NULL)
					{
						curr_chn->sse_vector.push_back(* new_sse);
						delete new_sse;
					}
					
					previous = 'L';
					first_in_this_element = -1;
				}
			}
			else
			{
				if (current != 'L')
				{
					previous = current;
					first_in_this_element = n2;
				}
			}
		}
		
		chn_vector.push_back(* curr_chn);
		delete curr_chn;
	}
}

mm3_sse * mm3_mdl::CreateHelix(mm2_mdl * mdl, i32s chn, i32s r1, i32s r2)
{
	if (ostr != NULL)
	{
		(* ostr) << "helix " << chn << ": ";
		(* ostr) << r1 << " - " << r2 << endl;
	}
	
	v3d<fGL> posv(0.0, 0.0, 0.0); i32u pcount = 0;
	v3d<fGL> dirv(0.0, 0.0, 0.0); v3d<fGL> prev;
	
	mm3_sse * new_sse = new mm3_sse;
	new_sse->residues = r2 - r1; new_sse->type = mm3_sse::helix;
	
	for (i32s n1 = 0;n1 < new_sse->residues;n1++)
	{
		v3d<fGL> v1(mdl->chn_vector[chn].res_vector[r1 + n1].crd_vector[0][0].data);
		posv = posv + v1; pcount++;
	}
	
	for (i32s n1 = 0;n1 < new_sse->residues;n1++)
	{
		v3d<fGL> v1(mdl->chn_vector[chn].res_vector[r1 + n1 - 1].crd_vector[0][0].data);
		v3d<fGL> v2(mdl->chn_vector[chn].res_vector[r1 + n1 + 0].crd_vector[0][0].data);
		v3d<fGL> v3(mdl->chn_vector[chn].res_vector[r1 + n1 + 1].crd_vector[0][0].data);
		v3d<fGL> v4 = v2 - v1; v3d<fGL> v5 = v3 - v2; v3d<fGL> v6 = v4 - v5;
		
		if (!n1) prev = v6;
		else
		{
			dirv = dirv + prev.vpr(v6);
			prev = v6;
		}
	}
	
	posv = posv / (fGL) pcount;
	dirv = dirv / dirv.len();
	
	for (i32s n1 = 0;n1 < 3;n1++)
	{
		new_sse->center[n1] = posv[n1];
		new_sse->direction[n1] = dirv[n1];
	}
	
	return new_sse;
}

mm3_sse * mm3_mdl::CreateStrand(mm2_mdl * mdl, i32s chn, i32s r1, i32s r2)
{
	if (ostr != NULL)
	{
		(* ostr) << "strand " << chn << ": ";
		(* ostr) << r1 << " - " << r2 << endl;
	}
	
	v3d<fGL> posv(0.0, 0.0, 0.0); i32u pcount = 0;
	v3d<fGL> dirv(0.0, 0.0, 0.0);
	
	mm3_sse * new_sse = new mm3_sse;
	new_sse->residues = r2 - r1; new_sse->type = mm3_sse::strand;
	
	for (i32s n1 = 0;n1 < new_sse->residues;n1++)
	{
		v3d<fGL> v1(mdl->chn_vector[chn].res_vector[r1 + n1].crd_vector[0][0].data);
		posv = posv + v1; pcount++;
	}
	
	for (i32s n1 = 0;n1 < new_sse->residues;n1++)
	{
		v3d<fGL> v1(mdl->chn_vector[chn].res_vector[r1 + n1 - 1].crd_vector[0][0].data);
		v3d<fGL> v2(mdl->chn_vector[chn].res_vector[r1 + n1 + 1].crd_vector[0][0].data);
		dirv = dirv + (v2 - v1);
	}
	
	posv = posv / (fGL) pcount;
	dirv = dirv / dirv.len();
	
	for (i32s n1 = 0;n1 < 3;n1++)
	{
		new_sse->center[n1] = posv[n1];
		new_sse->direction[n1] = dirv[n1];
	}
	
	return new_sse;
}

/*################################################################################################*/

// eof
