/****************************************************************************
** eh_system.cc
**
** Michael S. Borella <mike@borella.net>
**
** Methods for the sytem call error handler class
**
****************************************************************************/

#include <string.h>
#include <errno.h>
#include "eh_system.h"

//---------------------------------------------------------------------------
//
// EH_system::EH_system()
//
// Constructor method.  Get system call error message.
//
//---------------------------------------------------------------------------

EH_system::EH_system(string s)
{
  char *syserr;

  // First, get the error string from the system
  syserr = strerror(errno);

  // add it to the user string
  s += ": ";
  while(*syserr != '\0')
    {
      s +=*syserr;
      syserr++;
    }

  action(s, "", 0);
}

//---------------------------------------------------------------------------
//
// EH_system::EH_system(string, string, int)
//
// Constructor method.  Get system call error message, dump file and line #
//
//---------------------------------------------------------------------------

EH_system::EH_system(string s, string f, int l)
{
  char *syserr;

  // First, get the error string from the system
  syserr = strerror(errno);

  // add it to the user string
  s += ": ";
  while(*syserr != '\0')
    {
      s +=*syserr;
      syserr++;
    }

  action(s, f, l);
}
