// This file is part of a XSLT engine working on Gdome documents. In fact,
// it just maps Gdome documents to libxml documents back and forth, and
// applies the transformation on libxml documents using libxlt.
// 
// Copyright (C) 2002: Luca Padovani <lpadovan@cs.unibo.it>
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// For more information, please send an email to lpadovan@cs.unibo.it

#ifndef __GdomeSmartDOMXSLTStylesheet_hh__
#define __GdomeSmartDOMXSLTStylesheet_hh__

#include <vector>
#include <string>
#include <stdio.h>

#include "gdome_xslt.h"
#include <GdomeSmartDOM.hh>

namespace GdomeSmartDOMExt {

  using namespace GdomeSmartDOM;

  class XSLTStylesheet
  {
  public:
    explicit XSLTStylesheet(const Document& doc);
    ~XSLTStylesheet();

    Document apply(const Document& source) const;
    Document apply(const Document& source, const std::vector< std::pair<GdomeString, GdomeString> >& params) const;
    void     save(const Document& result, const std::string& filename) const;
    void     save(const Document& result, FILE* f) const;
    void     save(const Document& result, int fd) const;

    class SaveException { };

  private:
    XSLTStylesheet(const XSLTStylesheet&);

    xsltStylesheet* stylesheet;
  };

}

#endif // __GdomeSmartDOMXSLTStylesheet_hh__
