/* sqlwiddbrel.h
 *
 * Copyright (C) 1999,2000 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __SQL_WID_DB_REL__
#define __SQL_WID_DB_REL__

#include <gnome.h>
#include "sqldb.h"
#include "gasql_conf.h"

#ifdef __cplusplus
extern "C"
{
#endif				/* __cplusplus */


/**************************************************************************/
/*                                                                        */
/* SqlWidDbRel                                                            */
/*                                                                        */
/**************************************************************************/

#define SQL_WID_DB_REL(obj)          GTK_CHECK_CAST (obj, sql_wid_db_rel_get_type(), SqlWidDbRel)
#define SQL_WID_DB_REL_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, sql_wid_db_rel_get_type (), SqlWidDbRelClass)
#define IS_SQL_WID_DB_REL(obj)       GTK_CHECK_TYPE (obj, sql_wid_db_rel_get_type ())


	/* one of these corresponds to one SqlWidDbRel */
	typedef struct _WidRelData
	{
		gchar*         name;

		/* private data below this point */

		GSList*        nodes; /* pointers to WidRelNode */
		GtkRequisition size;  /* to store the size of the canvas */
		/* storage of the adjustments for the widget */
		gfloat         h_adj_val;
		gfloat         h_adj_upper;
		gfloat         h_adj_lower;
		gfloat         v_adj_val;
		gfloat         v_adj_upper;
		gfloat         v_adj_lower;
		/* tells if an adjustment change implies a canvas_set_scroll
		   or not (see h_adj_changed_cb and v_adj_changed_cb) */
		gfloat         set_canvas_scroll; 
	}
	WidRelData;

	/* each of these is for one table or sequence */
	typedef struct _WidRelNode
	{
		double x;
		double y;
		gboolean shown;
		gpointer object;	/* points to a table (SqlMemTable) 
					   or a sequence (SqlMemSeq) */
	}
	WidRelNode;


	typedef struct _SqlWidDbRel SqlWidDbRel;
	typedef struct _SqlWidDbRelClass SqlWidDbRelClass;

	/* struct for the object's data */
	struct _SqlWidDbRel
	{
		GtkVBox object;

		GnomeCanvas *canvas;
		gASQL_Main_Config *conf;
		GSList *dis_tables;	/* pointers to SqlTableItem */
		GSList *dis_seqs;	/* pointers to SqlSeqItem   */
		GSList *dis_links;	/* pointers to SqlLinkItem  */
		GSList *tmp_links;	/* temporary parents links */
		WidRelData *mem_link;
	};

	/* struct for the object's class */
	struct _SqlWidDbRelClass
	{
		GtkVBoxClass parent_class;

		void (*table_shown) (SqlDb * db, SqlMemTable * table);
		void (*table_hidden) (SqlDb * db, SqlMemTable * table);
		void (*seq_shown) (SqlDb * db, SqlMemSeq * seq);
		void (*seq_hidden) (SqlDb * db, SqlMemSeq * seq);
	};

	/* generic widget's functions */
	guint sql_wid_db_rel_get_type (void);
	GtkWidget *sql_wid_db_rel_new (gASQL_Main_Config * conf,
				       gchar * name);

	/* Adding and deleting objects */
	void sql_wid_db_rel_show_table (SqlWidDbRel * rel,
					SqlMemTable * table);
	void sql_wid_db_rel_hide_table (SqlWidDbRel * rel,
					SqlMemTable * table);
	void sql_wid_db_rel_toggle_table (SqlWidDbRel * rel,
					  SqlMemTable * table);
	void sql_wid_db_rel_show_seq (SqlWidDbRel * rel, SqlMemSeq * seq);
	void sql_wid_db_rel_hide_seq (SqlWidDbRel * rel, SqlMemSeq * seq);
	void sql_wid_db_rel_toggle_seq (SqlWidDbRel * rel, SqlMemSeq * seq);

	/* same functions to be called under CB (ATTN: order reversed with above) */
	void sql_wid_db_rel_show_table_cb (GtkObject * obj,
					   SqlMemTable * table,
					   SqlWidDbRel * rel);
	void sql_wid_db_rel_hide_table_cb (GtkObject * obj,
					   SqlMemTable * table,
					   SqlWidDbRel * rel);
	void sql_wid_db_rel_toggle_table_cb (GtkObject * obj,
					     SqlMemTable * table,
					     SqlWidDbRel * rel);
	void sql_wid_db_rel_show_seq_cb (GtkObject * obj, SqlMemSeq * seq,
					 SqlWidDbRel * rel);
	void sql_wid_db_rel_hide_seq_cb (GtkObject * obj, SqlMemSeq * seq,
					 SqlWidDbRel * rel);
	void sql_wid_db_rel_toggle_seq_cb (GtkObject * obj, SqlMemSeq * seq,
					   SqlWidDbRel * rel);

	/* function to store the state of the displayed tables */
	void sql_wid_db_rel_build_xml_tree (WidRelData * data, xmlNodePtr doc,
					    gASQL_Main_Config * conf);
	gboolean sql_wid_db_rels_build_from_xml_tree (gASQL_Main_Config *
						      conf, xmlNodePtr node);

/**************************************************************************/
/*                                                                        */
/* SqlTableItem                                                           */
/*                                                                        */
/**************************************************************************/

#define SQL_TABLE_ITEM(obj)          GTK_CHECK_CAST (obj, sql_table_item_get_type(), SqlTableItem)
#define SQL_TABLE_ITEM_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, sql_table_item_get_type (), SqlTableItemClass)
#define IS_SQL_TABLE_ITEM(obj)       GTK_CHECK_TYPE (obj, sql_table_item_get_type ())


	typedef struct _SqlTableItem SqlTableItem;
	typedef struct _SqlTableItemClass SqlTableItemClass;

	/* struct for the object's data */
	struct _SqlTableItem
	{
		GtkObject object;

		/* main objects */
		SqlWidDbRel *rel;
		SqlMemTable *table;
		GnomeCanvasItem *canvas_group;	/* a GnomeCanvasGroup* */

		/* some GnomeCanvasItems */
		GnomeCanvasItem *frame;
		GnomeCanvasItem *bg_frame;
		GSList *field_items;	/* list of GnomeCanvasItems for the text fields */
		WidRelNode *node;

		/* user interface parameters */
		guint x_text_space;
		guint y_text_space;
		guint title_text_height;
		guint fields_text_height;
		guint max_text_width;
	};

	/* struct for the object's class */
	struct _SqlTableItemClass
	{
		GtkObjectClass parent_class;

		void (*moved) (SqlTableItem * item, gfloat x, gfloat y);
		void (*entered) (SqlTableItem * item);	/* mouse entered table */
		void (*left) (SqlTableItem * item);	/* mouse left table */
	};

	/* generic widget's functions */
	guint sql_table_item_get_type (void);
	GtkObject *sql_table_item_new (SqlWidDbRel * rel, WidRelNode * node);
	/* topleft position of the SqlTableItem */
	gfloat sql_table_item_get_xpos (SqlTableItem * titem);
	gfloat sql_table_item_get_ypos (SqlTableItem * titem);
	/* anchor points on the left and the right */
	void sql_table_item_get_left_anchor_point (SqlTableItem * ti,
						   SqlMemField * field,
						   double *x, double *y);
	void sql_table_item_get_right_anchor_point (SqlTableItem * ti,
						    SqlMemField * field,
						    double *x, double *y);


/**************************************************************************/
/*                                                                        */
/* SqlSeqItem                                                             */
/*                                                                        */
/**************************************************************************/

#define SQL_SEQ_ITEM(obj)          GTK_CHECK_CAST (obj, sql_seq_item_get_type(), SqlSeqItem)
#define SQL_SEQ_ITEM_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, sql_seq_item_get_type (), SqlSeqItemClass)
#define IS_SQL_SEQ_ITEM(obj)       GTK_CHECK_TYPE (obj, sql_seq_item_get_type ())


	typedef struct _SqlSeqItem SqlSeqItem;
	typedef struct _SqlSeqItemClass SqlSeqItemClass;

	/* struct for the object's data */
	struct _SqlSeqItem
	{
		GtkObject object;

		/* main objects */
		SqlWidDbRel *rel;
		SqlMemSeq *seq;
		GnomeCanvasItem *canvas_group;	/* a GnomeCanvasGroup* */

		/* some GnomeCanvasItems */
		GnomeCanvasItem *text;
		GnomeCanvasItem *bg_frame;
		WidRelNode *node;

		guint x_text_space;
		guint y_text_space;
	};

	/* struct for the object's class */
	struct _SqlSeqItemClass
	{
		GtkObjectClass parent_class;

		void (*moved) (SqlSeqItem * item, gfloat x, gfloat y);
		void (*entered) (SqlSeqItem * item);	/* mouse entered seq */
		void (*left) (SqlSeqItem * item);	/* mouse left seq */
	};

	/* generic widget's functions */
	guint sql_seq_item_get_type (void);
	GtkObject *sql_seq_item_new (SqlWidDbRel * rel, WidRelNode * node);
	/* topleft position of the SqlSeqItem */
	gfloat sql_seq_item_get_center_xpos (SqlSeqItem * sitem);
	gfloat sql_seq_item_get_center_ypos (SqlSeqItem * sitem);


/**************************************************************************/
/*                                                                        */
/* SqlLinkItem                                                            */
/*                                                                        */
/**************************************************************************/

#define SQL_LINK_ITEM(obj)          GTK_CHECK_CAST (obj, sql_link_item_get_type(), SqlLinkItem)
#define SQL_LINK_ITEM_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, sql_link_item_get_type (), SqlLinkItemClass)
#define IS_SQL_LINK_ITEM(obj)       GTK_CHECK_TYPE (obj, sql_link_item_get_type ())


	typedef struct _SqlLinkItem SqlLinkItem;
	typedef struct _SqlLinkItemClass SqlLinkItemClass;

	typedef enum
	{
		SQL_LINK_SEQUENCE,
		SQL_LINK_FIELD
	}
	SqlWidDbRelLinkType;

	/* struct for the object's data */
	struct _SqlLinkItem
	{
		GtkObject object;

		SqlWidDbRelLinkType link_type;
		gpointer *from;	/* cast function of link_type */
		SqlTableItem *to;
		gpointer *link_mem;	/* ptr to SqlMemFlink or SqlMemField if Seq. link */
		GnomeCanvasItem *line;
	};

	/* struct for the object's class */
	struct _SqlLinkItemClass
	{
		GtkObjectClass parent_class;
	};

	/* generic widget's functions */
	guint sql_link_item_get_type (void);
	GtkObject *sql_link_item_new_field_field (GnomeCanvas * canvas,
						  SqlTableItem * from,
						  SqlTableItem * to,
						  SqlMemFlink * in_mem);
	GtkObject *sql_link_item_new_seq_field (GnomeCanvas * canvas,
						SqlSeqItem * from,
						SqlTableItem * to,
						SqlMemField * in_mem);

#ifdef __cplusplus
}
#endif				/* __cplusplus */

#endif
