/*
 * print_system.c
 * Thomas Nemeth, le 26.02.2000
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <gtk/gtk.h>
#include "structs.h"
#include "usefull.h"
#include "print_system.h"
#include "locale_formats.h"
#include "categories.h"
#include "gAcc_msg.h"

char *right_text (const char *text, int len) {
    char *rt = NULL;
    int   i;

    MY_ALLOC (rt, len + 1, char);
    if (text != NULL) {
        if (strlen (text) >= len ) {
            #ifdef DEBUG_GACC
                printf ("On va couper %s (trop long : %d / %d)\n",
                        text, strlen (text), len);
            #endif
            strncpy (rt, text, len - 2);
            rt[len - 2] = 0;
            strcat  (rt, ". ");
            #ifdef DEBUG_GACC
                printf ("a donne : %s\n", rt);
            #endif
        } else {
            #ifdef DEBUG_GACC
                printf ("Le texte est  la bonne longueur...\n");
            #endif
            strcpy (rt, text);
            for (i = strlen (text) ; i < len ; i++) strcat (rt, " ");
        }
    } else {
        #ifdef DEBUG_GACC
            printf ("Il n'y a pas de texte...\n");
        #endif
        strcpy (rt, " ");
        for (i = 1 ; i < len ; i++) strcat (rt, " ");
    }
    return rt;
}

char *spaces (int len) {
    char *rt;
    int   i;

    MY_ALLOC (rt, len + 1, char);
    strcpy (rt, " ");
    for (i = 1 ; i < len ; i++) strcat (rt, " ");

    return rt;
}

void print_file (const char *cmd, const char *file) {
    int nRead, i, last_slash = 0;
    FILE *pipe;
    char errorString[MAXSTRLEN];
    char command[MAXSTRLEN];
    char filename[MAXSTRLEN];

    /* get the basename of the file */
    for (i = 0 ; i < strlen (file) ; i++) if (file[i] == '/') last_slash = i;
    for (i = last_slash + 1 ; i < strlen (file) ; i++) {
        filename[i - last_slash - 1] = file[i];
        #ifdef DEBUG_GACC
            printf ("%c", file[i]);
        #endif
    }
    filename[i - last_slash - 1] = 0;

    #ifdef DEBUG_GACC
        printf ("\nLANCEMENT DE LA COMMANDE D'IMPRESSION POUR : %s\n", file);
        printf ("Longeur du nom : %d -- Position du dernier caractre : %d\n",
                 strlen (file), i);
    #endif

    /* add the file name and output redirection to the print command */
    sprintf (command, "cat %s | %s\"%s\" 2>&1", file, cmd, filename);
    #ifdef DEBUG_GACC
        printf ("COMMANDE LANCE : \"%s\"\n", command);
    #endif
    
    /* Issue the print command using a popen call and recover error messages
       from the output stream of the command. */
    pipe = (FILE *) popen (command,"r");
    if (pipe == NULL) {
        GtkWidget *msg_dialog = create_msg_dialog ( _("Unable to print...") );

        gtk_window_set_modal (GTK_WINDOW (msg_dialog), TRUE);
        gtk_widget_show (GTK_WIDGET (msg_dialog) );
	return;
    }
    errorString[0] = 0;
    nRead = fread(errorString, sizeof (char), MAXSTRLEN - 1, pipe);
    if ( ! ferror (pipe) )
	errorString[nRead] = '\0';
    if (pclose (pipe) ) {
        char message[MAXSTRLEN];
        GtkWidget *msg_dialog;

        sprintf (message, "Unable to print : %s.", errorString);
        msg_dialog = create_msg_dialog (message);
        gtk_window_set_modal (GTK_WINDOW (msg_dialog), TRUE);
        gtk_widget_show (GTK_WIDGET (msg_dialog) );
	return;
    }
}

void print_ascii_account (int type, char *method, ACCOUNT *account) {
    FILE    *file;
    float    total_ope_amount = 0.0;
    float    current_balance  = account->amount;
    float    month_amount     = 0.0;
    OPE_ELT *ope              = account->ope_list_head;
    int      date             = get_month_i (ope->operation->date);
    char    *filename         = NULL;
    char    *text             = NULL;
    char    *spc              = NULL;
    char    *tmpstr;
    int      year;

    if (type == PRINT_TO_PRINTER) {
        char    *Home;
        Home = getenv ("HOME");
        MY_ALLOC (filename, (MAXSTRLEN + 1), char);
        sprintf (filename, "%s/%s/%s", Home, CONFIGDIR, PRINTER_FILENAME);
    } else if (type == PRINT_TO_FILE) {
        filename = method;
    }
    if ( (file = fopen (filename, "w") ) == NULL) {
        printf ("Error opening file %s for printing !\n", filename);
        return;
    }

    /*
    FIELDS LENGTH :
    NUMBER S DATE S OBJECT S CATEGORY S AMOUNT S BALANCE
    7      1 5    2 26     2 15       1 10     1 10
    */

    text = _("Account operations");
    spc  = spaces ( (80 - strlen (text) ) / 2 );
    fprintf (file, "%s%s\n", spc, text);
    free (spc);
    tmpstr = format_today ();
    spc    = spaces ( ( (80 - strlen (account->name) ) / 2) - strlen (tmpstr) );
    fprintf (file, "%s%s%s\n\n\n", tmpstr, spc, account->name);
    free (tmpstr);
    free (spc);
    text = right_text (_("Number"), 8);
    fprintf (file, "%s", text);
    text = right_text (_("Date"), 7);
    fprintf (file, "%s", text);
    text = right_text (_("Object"), 28);
    fprintf (file, "%s", text);
    text = right_text (_("Category"), 16);
    fprintf (file, "%s", text);
    fprintf (file, "%11s%10s\n", _("Amount"), _("Balance") );
    fprintf (file, "________________________________________");
    fprintf (file, "________________________________________\n\n");
    text = _("Initial balance");
    spc  = spaces (80 - strlen (text) - 11);
    fprintf (file, "%s%s%11.2f\n\n",
             text,
             spc,
             account->amount);
    free (spc);
    tmpstr = get_month_n (ope->operation->date);
    year   = get_year_i (ope->operation->date);
    fprintf (file, "%s : %s %d\n", _("Month"), tmpstr, year);
    while (ope != NULL) {
        char  *ope_date = format_very_short_date (ope->operation->date);
        float  ope_amount = (ope->operation->type == CREDIT) ?
                             ope->operation->amount :
                             - ope->operation->amount;

        if ( date != get_month_i (ope->operation->date) ) {
            char *s;
            s = spaces (58);
            fprintf(file, "%s____________\n", s);
            free (s);
            MY_ALLOC (text, MAXSTRLEN, char);
            sprintf (text ,"%s %s %d :", _("Total for"), tmpstr, year);
            s = spaces (80 - strlen (text) - 21);
            fprintf (file, "%s%s%10.2f\n\n\n", text, s, month_amount);
            free (s);
            free (text);
            date = get_month_i (ope->operation->date);
            month_amount = 0.0;
            /* free (tmpstr); */
            tmpstr = get_month_n (ope->operation->date);
            year   = get_year_i (ope->operation->date);
            fprintf (file, "%s %s %d\n", _("Month"), tmpstr, year);
        }
        if (ope->operation->cancelled == FAUX) {
            month_amount     = month_amount + ope_amount;
            total_ope_amount = total_ope_amount + ope_amount;
            current_balance  = current_balance + ope_amount;
            text = right_text (ope->operation->num, 8);
            #ifdef DEBUG_GACC
                printf ("Allons ajouter le numro de l'opration : %s\n",
                        ope->operation->num);
                printf ("Soit : %s\n", text);
            #endif
            fprintf (file, "%s", text);
            free (text);
            fprintf (file, "%s  ", ope_date);
            text = right_text (ope->operation->object, 26);
            fprintf (file, "%s  ", text);
            free (text);
            text = right_text (category_name (ope->operation->category) != NULL ?
                              category_name (ope->operation->category) : "", 15);
            fprintf (file, "%s ", text);
            free (text);
            fprintf (file, "%10.2f %10.2f\n", ope_amount, current_balance);
            /*
            fprintf (file, "%s%s%s%s%11.2f%11.2f\n",
                     ope->operation->num,
                     ope_date,
                     ope->operation->object != NULL ?
                     ope->operation->object : "",
                     category_name (ope->operation->category) != NULL ?
                     category_name (ope->operation->category) : "" ,
                     ope_amount,
                     current_balance);
            */
        } else {
            text = right_text (ope->operation->num, 8);
            fprintf (file, "%s", text);
            free (text);
            fprintf (file, "%s  ", ope_date);
            text = right_text (ope->operation->object, 26);
            fprintf (file, "%s  ", text);
            free (text);
            text = right_text (category_name (ope->operation->category) != NULL ?
                              category_name (ope->operation->category) : "", 15);
            fprintf (file, "%s ", text);
            free (text);
            fprintf (file, "%10.2f %10s\n", ope_amount, _("CANCELLED") );
            /*
            fprintf (file, "%s\t%s\t%s\t%s\t%11.2f\t%11.2f\n",
                     _("CANCELLED"),
                     ope_date,
                     ope->operation->object != NULL ?
                     ope->operation->object : "",
                     category_name (ope->operation->category) != NULL ?
                     category_name (ope->operation->category) : "" ,
                     ope_amount,
                     current_balance);
            */
        }
        free (ope_date);
        ope = ope->next;
    }
    spc = spaces (58);
    fprintf(file, "%s____________\n", spc);
    free (spc);
    MY_ALLOC (text, MAXSTRLEN, char);
    sprintf (text ,"%s %s %d :", _("Total for"), tmpstr, year);
    spc = spaces (80 - strlen (text) - 21);
    fprintf (file, "%s%s%10.2f\n\n\n", text, spc, month_amount);
    free (spc);
    free (text);
    
    fprintf (file, "________________________________________");
    fprintf (file, "________________________________________\n");
    text = _("GENERAL TOTAL :");
    spc  = spaces (80 - strlen (text) - 21);
    fprintf (file, "\n%s%s%10.2f %10.2f\n",
                     text,
                     spc,
                     total_ope_amount,
                     current_balance);
    fprintf (file, "________________________________________");
    fprintf (file, "________________________________________\n");
    fclose (file);

    free (tmpstr);
    if (type == PRINT_TO_PRINTER) {
        print_file (method, filename);
        my_system ("rm ", filename);
        free (filename);
    }
}

void print_ascii_ope_list (int type, char *method, OPE_ELT *ope_list) {
    FILE    *file;
    OPE_ELT *ope              = ope_list;
    float    total            = 0.0;
    char    *filename         = NULL;
    char    *text             = NULL;
    char    *spc              = NULL;
    char    *tmpstr;

    if (type == PRINT_TO_PRINTER) {
        char    *Home;
		Home = getenv ("HOME");
        MY_ALLOC (filename, (MAXSTRLEN + 1), char);
		sprintf (filename, "%s/%s/%s",Home, CONFIGDIR, PRINTER_FILENAME);
    } else if (type == PRINT_TO_FILE) {
        filename = method;
    }
    if ( (file = fopen (filename, "w") ) == NULL) {
        printf ("Error opening file %s for printing !\n", filename);
        return;
    }

    /*
    FIELDS LENGTH :
    NUMBER S DATE S OBJECT S CATEGORY S AMOUNT
    10     1 8    2 29     2 17       1 10    
    */

    text = _("Operations list");
    tmpstr = format_today ();
    spc    = spaces ( ( (80 - strlen (text) ) / 2) - strlen (tmpstr) );
    fprintf (file, "%s%s%s\n\n\n", tmpstr, spc, text);
    free (tmpstr);
    free (spc);
    text = right_text (_("Number"), 11);
    fprintf (file, "%s", text);
    text = right_text (_("Date"), 10);
    fprintf (file, "%s", text);
    text = right_text (_("Object"), 31);
    fprintf (file, "%s", text);
    text = right_text (_("Category"), 19);
    fprintf (file, "%s", text);
    fprintf (file, "%10s\n", _("Amount") );
    fprintf (file, "________________________________________");
    fprintf (file, "________________________________________\n\n");
    while (ope != NULL) {
        char  *ope_date = format_short_date (ope->operation->date);
        float  ope_amount = (ope->operation->type == CREDIT) ?
                             ope->operation->amount :
                             - ope->operation->amount;

        if (ope->operation->cancelled == FAUX) {
            total = total + ope_amount;
            text = right_text (ope->operation->num, 10);
            #ifdef DEBUG_GACC
                printf ("Allons ajouter le numro de l'opration : %s\n",
                        ope->operation->num);
                printf ("Soit : %s\n", text);
            #endif
            fprintf (file, "%s", text);
            free (text);
            fprintf (file, "%s  ", ope_date);
            text = right_text (ope->operation->object, 29);
            fprintf (file, "%s  ", text);
            free (text);
            text = right_text (category_name (ope->operation->category) != NULL ?
                              category_name (ope->operation->category) : "", 17);
            fprintf (file, "%s ", text);
            free (text);
            fprintf (file, "%10.2f\n", ope_amount);
        } else {
            text = right_text (_("CANCELLED"), 10);
            fprintf (file, "%s", text);
            free (text);
            fprintf (file, "%s  ", ope_date);
            text = right_text (ope->operation->object, 29);
            fprintf (file, "%s  ", text);
            free (text);
            text = right_text (category_name (ope->operation->category) != NULL ?
                              category_name (ope->operation->category) : "", 17);
            fprintf (file, "%s ", text);
            free (text);
            fprintf (file, "%10.2f\n", ope_amount);
        }
        free (ope_date);
        ope = ope->next;
    }
    fprintf (file, "________________________________________");
    fprintf (file, "________________________________________\n");
    text = _("GENERAL TOTAL :");
    spc  = spaces (80 - strlen (text) - 11);
    fprintf (file, "\n%s%s%10.2f\n",
                     text,
                     spc,
                     total);
    fprintf (file, "________________________________________");
    fprintf (file, "________________________________________\n");
    fclose (file);

    if (type == PRINT_TO_PRINTER) {
        print_file (method, filename);
        my_system ("rm ", filename);
        free (filename);
    }
}
