/*
 * gAcc_confirm.c
 * Thomas Nemeth, le 10.12.1999
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "gAcc_confirm.h"
#include "usefull.h"
#include "accounts.h"
#include "cfgmgt.h"
#include "gAcc.h"
#include "gAcc_menuscb.h"
#include "gAcc_editacc.h"
#include "gAcc_file.h"


/*** Create the "Confirm" dialog box ****************************/

/* OK NEW */
void confirm_ok_new_cb (GtkWidget *widget, GtkWidget *data) {
    int type = GACC_NEW;

    save_wallet_cb (NULL, &type);
    gtk_widget_destroy (data);
}

/* OK OPENING */
void confirm_ok_opening_cb (GtkWidget *widget, GtkWidget *data) {
    int type = GACC_OPENING;

    save_wallet_cb (NULL, &type);
    gtk_widget_destroy (data);
}

/* OK CLOSE */
void confirm_ok_close_cb (GtkWidget *widget, GtkWidget *data) {
    int type = GACC_CLOSE;

    save_wallet_cb (NULL, &type);
    gtk_widget_destroy (data);
}

/* OK QUIT */
void confirm_ok_quit_cb (GtkWidget *widget, GtkWidget *data) {
    int type = GACC_QUIT;

    save_wallet_cb (NULL, &type);
    gtk_widget_destroy (data);
}

/* CANCEL NEW */
void confirm_cancel_new_cb (GtkWidget *widget, GtkWidget *data) {
    GtkWidget *editacc_dialog;

    editacc_dialog = create_editacc_dialog (NULL);
    gtk_clist_clear ( GTK_CLIST (acc_clist) );
    new_wallet ();
    gtk_window_set_title (GTK_WINDOW (application), "gAcc");
    gtk_window_set_title (GTK_WINDOW (editacc_dialog), _("New Account") );
    gtk_window_set_modal (GTK_WINDOW (editacc_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (editacc_dialog) );
    gtk_widget_destroy (data);
}

/* CANCEL OPENING */
void confirm_cancel_opening_cb (GtkWidget *widget, GtkWidget *data) {
    GtkWidget *file_dialog;
    char      *filename;

    file_dialog = create_file_dialog (GACC_OPEN);
    filename = default_filename (FAUX);
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (file_dialog),
                                     filename);
    gtk_window_set_modal (GTK_WINDOW (file_dialog), TRUE);
    gtk_widget_show (file_dialog);
    free (filename);
    gtk_widget_destroy (data);
}

/* CANCEL CLOSE */
void confirm_cancel_close_cb (GtkWidget *widget, GtkWidget *data) {
    free_accounts ();
    gtk_clist_clear (GTK_CLIST (acc_clist) );
    gtk_widget_destroy (data);
}

/* CANCEL QUIT */
void confirm_cancel_quit_cb (GtkWidget *widget, GtkWidget *data) {
    gtk_main_quit ();
    gtk_widget_destroy (data);
}

/* DEFAULT */
void confirm_default_cb (GtkWidget *widget, GtkWidget *data) {
    fatal_error ( _("Not supported option to confirm !") );
}


GtkWidget *create_confirm_dialog (int type) {
    GtkWidget *Confirm_Dialog;
    GtkWidget *bouton;
    GtkWidget *label;

    Confirm_Dialog = gtk_dialog_new ();
    gtk_window_set_title (GTK_WINDOW (Confirm_Dialog), _("Confirm") );
    /* A VOIR !? */
    gtk_signal_connect (GTK_OBJECT (Confirm_Dialog), "delete_event",
                        GTK_SIGNAL_FUNC (gtk_widget_destroy),
                        NULL);
    gtk_signal_connect (GTK_OBJECT (Confirm_Dialog), "destroy", 
		                GTK_SIGNAL_FUNC (gtk_widget_destroy), 
		                NULL);

    bouton = gtk_button_new_with_label ( _("Yes") );
    switch (type) {
        case GACC_NEW : {
            gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (confirm_ok_new_cb),
                        Confirm_Dialog);
        } break;
        case GACC_OPENING : {
            gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (confirm_ok_opening_cb),
                        Confirm_Dialog);
        } break;
        case GACC_CLOSE : {
            gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (confirm_ok_close_cb),
                        Confirm_Dialog);
        } break;
        case GACC_QUIT : {
            gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (confirm_ok_quit_cb),
                        Confirm_Dialog);
        } break;
        default : {
            gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (confirm_default_cb),
                        Confirm_Dialog);
        } break;
    }
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Confirm_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (bouton), GTK_CAN_DEFAULT);
    gtk_widget_grab_default (GTK_WIDGET (bouton) );
    gtk_widget_draw_default (GTK_WIDGET (bouton) );
    gtk_widget_show (bouton);

    bouton = gtk_button_new_with_label ( _("No") );
    switch (type) {
        case GACC_NEW : {
            gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (confirm_cancel_new_cb),
                        Confirm_Dialog);
        } break;
        case GACC_OPENING : {
            gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (confirm_cancel_opening_cb),
                        Confirm_Dialog);
        } break;
        case GACC_CLOSE : {
            gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (confirm_cancel_close_cb),
                        Confirm_Dialog);
        } break;
        case GACC_QUIT : {
            gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (confirm_cancel_quit_cb),
                        Confirm_Dialog);
        } break;
        default : {
            gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (confirm_default_cb),
                        Confirm_Dialog);
        } break;
    }
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Confirm_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    gtk_widget_show (bouton);

    label = gtk_label_new (_("\n   The file has been changed.   \n"));
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Confirm_Dialog)->vbox), label, TRUE,
                        TRUE, 6);
    gtk_widget_show (label);
    label = gtk_label_new (_("\n   Do you want to save the changes ?   \n"));
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Confirm_Dialog)->vbox), label, TRUE,
                        TRUE, 6);
    gtk_widget_show (label);

    return Confirm_Dialog;
}
