# First draft 06/27/96    Jianjun

# constrct a FitsImage object
# FitsImage FitsImageObjName FitsFileObjName chdu 

class CubeImage {
    inherit FitsImage
    constructor {args} {
	eval FitsImage::constructor [lrange $args 0 1]
    } {
	set istart [lindex $args 2]
	set iend [lindex $args 3]
    }

    private variable istart
    private variable iend
    private method readInTable {} 
    private method saveTableToAscii  {win asciiFileName} 

    protected method readTabData {fCol fRow nCols nRows} 
    protected method putRawData {col row val}
    protected method getRawDataBlock { fCol fRow lCol lRow }
    protected method putRawDataBlock { fCol fRow data }

    private method powMakeImage {} 
    private method saoMakeImage {}
    private method ds9MakeImage {}
    
    public method setFileName { fName }
}

body CubeImage::setFileName { fName } {
   set fileName $fName
   set rName [urlTail $fName]
   set dName [getFullDirPath $fName]
   wm title $droot "fv: $tabType\[$istart\] of $rName\[[expr $chdu-1]\] in $dName"
   .fvwinkeeper signoff  $droot
   .fvwinkeeper register $droot "Image Table" [urlTail $fName] $chdu \
         $this
}


body CubeImage::readInTable { } {
    global charPix
    
    set DC(height)   20
    set DC(width)     [expr (int(log10($numRows))+6)*$charPix]
    set DC(headroom) 20
    set DC(footroom) 40
    set DC(vscrollsize) 15
    set DC(hscrollsize) 15
    set DC(rightspace) 6
    set DC(interline)    0
    set DC(tmar)         6
    set DC(lmar)         8
    set DC(tabspace)     0

# flag that the imageTable is being displayed
    set isImageTable 1

    if { $imgType == 0 } {
	set cellSize 8
    } elseif {$imgType == 1} {
	set cellSize 8
    } elseif {$imgType == 2} {
	set cellSize 16
    } elseif {$imgType == 3} {
	set cellSize 16
    } elseif {$imgType == 4} {
	set cellSize 20
    } else {
	set cellSize 8
    }

    set colSelList {}
    set dispCols $numCols
    set tabType Image

# use fits command setrowstate to initialize the rowState
# usage   setrowstate totalNumOfRos startRow endRow status 
# (0:normal, 1:selected, 2: deleted)
    setarray rowState 0 [expr $numRows-1] 0
    setarray colState 0 [expr $dispCols-1] 0

    set absXPos(0) [expr $DC(lmar) + $DC(width)/2]
    for {set i 0} {$i < $dispCols} {incr i} {
	set columnName($i) [expr $i+1]
	set columnType($i) " "
	set columnUnit($i) " "
	lappend colSelList [expr $i+1]
	set cellWidth($i) $cellSize 
	set cellPixWidth($i) [expr $charPix*(1+$cellWidth($i))]
	set absXPos([expr $i+1]) [expr $absXPos($i) + $cellPixWidth($i) \
				      +$DC(rightspace)] 
    }

}


body CubeImage::saoMakeImage {} {
   puts "SAOtng can only load the first slice of a 3D image at this point"
   FitsImage::saoMakeImage
}
    

body CubeImage::ds9MakeImage {} {
   puts "DS9 can only load the first slice of a 3D image at this point"
   FitsImage::ds9MakeImage
}
    

body CubeImage::powMakeImage {} {
    global powWCS
    global movieParam

    # get the pow widget 
    if { [winfo exist .pow.pow]!=1 } { 
	powInit .dummy
    }

    set cleanFileName [urlTail $fileName]
    set imgIndex  ${cleanFileName}_[expr $chdu-1]
    set imgHandle ${cleanFileName}_[expr $chdu-1]

    set imgType $imgType
    set numCols $numCols
    set numRows $numRows


    for {set i $istart} {$i <=$iend} {incr i} {
	set ii $i
# load slice of image without rotating
	set dataAddress [$fFObj loadImageSlice $i 0] 
# the last param is for copying  data
	eval powCreateData ${imgHandle}_$ii $dataAddress $imgType \
		       [expr $numCols*$numRows] 1
	# free the data array
	$fFObj freeImage $dataAddress
    }

    set x_0 1
    set y_0 1
    set incrx 1
    set incry 1
    set x_label ""
    set y_label ""
    set x_unit "pixels"
    set y_unit "pixels"
    if { ![catch {set tmp [$fFObj getKeyword CTYPE1]}] } {
       set v [lindex [lindex $tmp 0] 1]
       set x_label [string trim $v {' }]
    }
    if { ![catch {set tmp [$fFObj getKeyword CTYPE2]}] } {
       set v [lindex [lindex $tmp 0] 1]
       set y_label [string trim $v {' }]
    }
    if { ![catch {set tmp [$fFObj getKeyword CUNIT1]}] } {
       set v [lindex [lindex $tmp 0] 1]
       set x_unit [string trim $v {' }]
    }
    if { ![catch {set tmp [$fFObj getKeyword CUNIT2]}] } {
       set v [lindex [lindex $tmp 0] 1]
       set y_unit [string trim $v {' }]
    }


    # Get the WCS info (if needed) and pass them to pow

    if { $fvPref::ifWCSInfo } {

       set wcsinfo [$fFObj getWcs]
       set powWCS($imgIndex) $wcsinfo
       set x_label [lindex [lindex $wcsinfo 3] 0]
       set y_label [lindex [lindex $wcsinfo 3] 1]
       if { $x_unit=="pixels" } {set x_unit NULL}
       if { $y_unit=="pixels" } {set y_unit NULL}

    } else {
       set powWCS($imgIndex) ""
    }


    set imgList {}
    for {set i $istart} {$i <= $iend} {incr i} {
	set ii $i
	powCreateImage ${imgHandle}_$ii ${imgHandle}_$ii 0 0\
		       $numCols $numRows $x_0 \
		       $incrx $y_0 $incry $x_label $y_label counts
	lappend imgList ${imgHandle}_$ii
	set powWCS(${imgHandle}_$ii) $powWCS($imgIndex)
    }

    powCreateGraph $imgHandle NULL $imgList \
		   $x_unit $y_unit \
		   $x_label $y_label \
		   [lindex $fvPref::graphDispSize 0] \
                   [lindex $fvPref::graphDispSize 1]

# play the movie
    if { $istart!= $iend} {
	powMovie 
	set movieParam(loop) 1
        after 1 powPlayMovie     
    }
}

##############################################
#
# Handle Reading/Writing/Formatting of Data
#

body CubeImage::readTabData {fCol fRow nCols nRows} {
    if { $istart != $iend } {
	error "Can only load one slice a time"
    }

    set slice $istart
    set fRow [expr $numRows - $fRow - $nRows + 1]
    incr fCol
    $fitsfileCmd load iblock "tabData" $fRow $nRows $fCol $nCols $istart
}

body CubeImage::putRawData { col row val } {
# Overrides IMAGE method so that the image $slice is taken into account

   set realRow [expr $numRows-$row-1]

   set origin    [expr $numRows*$numCols*($slice-1)]
   set firstElem [expr $realRow*$numCols+$col+1+$origin]

   $fFObj putImage $firstElem 1 [list $val]
   readTabData $col $row 1 1
}

body CubeImage::getRawDataBlock { fCol fRow lCol lRow } {
   # col/row zero-indexed

   set origin [expr $numRows*$numCols*($slice-1)]

   set nElem [expr $lCol - $fCol + 1]
   for { set col 0 } { $col<$nElem } { incr col } {
      set colData($col) {}
   }

   set row $fRow
   for { set row $fRow } { $row <= $lRow } { incr row } {
      set realRow   [expr $numRows-$row-1]
      set firstElem [expr $realRow*$numCols+$fCol+1+$origin]
      set col 0
      foreach datum [$fitsfileCmd get image $firstElem $nElem] {
         lappend colData($col) $datum
         incr col
      }
   }

   set data {}
   for { set col 0 } { $col<$nElem } { incr col } {
      lappend data $colData($col)
   }

   return $data
}

body CubeImage::putRawDataBlock { fCol fRow data } {
   # col/row zero-indexed

   set origin [expr $numRows*$numCols*($slice-1)]

   set nCols [llength $data]
   set nRows [llength [lindex $data 0]]

   for { set i 0 } { $i<$nRows } { incr i } {
      set rowData {}
      foreach cData $data {
         lappend rowData [lindex $cData $i]
      }
      set realRow   [expr $numRows-$fRow-1]
      set firstElem [expr $realRow*$numCols+$fCol+1+$origin]
      $fitsfileCmd put image $firstElem $nCols $rowData
      incr fRow
   }
}

#
#  End Data handlers
#
##############################################


body CubeImage::saveTableToAscii  {win asciiFileName} {

# setup the grouping 
  set tmpWidth  $cellSize
  set tmpFirstCol(0) 1
  set groupCount  0  

  for {set  n 0} {$n < $numCols-1} {incr n} {
      set tmpWidth [expr  $tmpWidth + $cellSize]
      if { $tmpWidth > $asciiColWidth} {
      incr groupCount 
      set tmpWidth  $cellSize;
	  set tmpFirstCol($groupCount) [expr  $n+2]
    }
  }
  incr groupCount
  set tmpFirstCol($groupCount) [expr 1+$numCols]

  $win.f.fb configure -steps $groupCount
  for {set k 0} {$k< $groupCount} {incr k} {
      set nCols  [expr $tmpFirstCol([expr $k+1])-$tmpFirstCol($k)]
      $fFObj saveImgToASCII $asciiFileName $k \
	  1 $numRows $tmpFirstCol($k) $nCols $cellSize $istart
      if {[catch {$win.f.fb step}] == 1} {
	  file delete $asciiFileName
	  return
      }
  }
  destroy $win

}
