#! /bin/sh 
#
# 
# $Id: uml-functions.sh,v 1.28 2003/09/02 19:45:48 mcr Exp $
#

setup_make() {
    TAB="	@"
    depends=""

    echo "# RULES for making module"

    # figure out our base architecture, as we'll need in the Makefiles.
    SUBARCH=${ARCH-`uname -m`}
    case $SUBARCH in
	i?86) SUBARCH=i386;;
    esac

    echo "IPSECDIR=${FREESWANSRCDIR}/linux/net/ipsec"
    echo "module/ipsec.o: ${FREESWANSRCDIR}/packaging/makefiles/module.make \${IPSECDIR}/*.c"
    echo "$TAB mkdir -p module"
    echo "$TAB make -C ${FREESWANSRCDIR} FREESWANSRCDIR=${FREESWANSRCDIR} MODBUILDDIR=$POOLSPACE/module KERNELSRC=$POOLSPACE/plain ARCH=um SUBARCH=${SUBARCH} module "
    echo
}

# output should directed to a Makefile
setup_host_make() {
    host=$1
    KERNEL=$2
    HOSTTYPE=$3
    KERNDIR=`dirname $KERNEL`
    TAB="	@"
    hostroot=$host/root
    depends=""

    echo "# RULES for host $host"
    echo 

    echo "$hostroot:"
    echo "$TAB mkdir -p $host $hostroot"
    echo
    depends="$depends $host/root"

    echo $host/linux : $KERNEL 
    echo "$TAB cp $KERNEL $host/linux"          
    echo
    depends="$depends $host/linux"

    echo "# make a hard link copy of the ROOT, but"
    echo "# make private copy of /var."
    echo "$hostroot/sbin/init : ${BASICROOT}/sbin/init"
    echo "$TAB -(cd ${BASICROOT} && find . -print | cpio -pld $POOLSPACE/$hostroot 2>/dev/null )"
    echo "$TAB rm -rf $hostroot/var"

    echo "$TAB (cd ${BASICROOT} && find var -print | cpio -pd $POOLSPACE/$hostroot 2>/dev/null )"

    # make sure that we have /dev, /tmp and /var/run
    echo "$TAB mkdir -p $hostroot/dev $hostroot/tmp $hostroot/var/run $hostroot/usr/share $hostroot/proc $hostroot/var/log/pluto/peer"

    # root image may be debian, but we expect rh-style /etc/rc.d
    echo "$TAB mkdir -p $hostroot/etc/rc.d"
    echo "$TAB mkdir -p $hostroot/testing $hostroot/usr/src"
    echo "$TAB if [ ! -d $hostroot/etc/rc.d/init.d ]; then (cd $hostroot/etc/rc.d && ln -fs ../init.d ../rc?.d . ); fi"

    # nuke certain other files that get in the way of booting
    echo "$TAB rm -f $hostroot/etc/mtab $hostroot/sbin/hwclock"

    # set up the timezone
    echo "$TAB rm -f $hostroot/etc/localtime "

    # dummy out fsck.
    echo "$TAB ln -f $hostroot/bin/true $hostroot/sbin/fsck.hostfs"

    # force it to GMT, otherwise (RH7.1) use host's zoneinfo.
    if [ -f /usr/share/zoneinfo/GMT ] 
    then
      echo "$TAB cp /usr/share/zoneinfo/GMT $hostroot/etc/localtime"
    else
      echo "$TAB cp /etc/localtime $hostroot/etc/localtime"
    fi

    # now remove any files that we shouldn't have copied.
    echo "$TAB (cd ${TESTINGROOT}/baseconfigs/all && find . -type f -print) | (cd $hostroot && xargs rm -f)"
    echo "$TAB (cd ${TESTINGROOT}/baseconfigs/$host && find . -type f -print) | (cd $hostroot && xargs rm -f)"
    # okay, that's all the stock stuff
    echo 
    depends="$depends $hostroot/sbin/init"

    # copy global configuration files, and make sure that they are up-to-date.
    (cd ${TESTINGROOT}/baseconfigs/all && find . -type f -print) | sed -e 's,^\./,,' >makeuml.$$
    echo -n >makeuml2.$$
    cat makeuml.$$ | while read file
    do
        case $file in
	    *~) ;;
	    *CVS/*);;
	    */.\#*);;
	    etc/fstab);;
	    *) echo "$hostroot/$file : ${TESTINGROOT}/baseconfigs/all/$file $hostroot"
	       echo "$TAB rm -f $hostroot/$file && mkdir -p `dirname $hostroot/$file` && cp ${TESTINGROOT}/baseconfigs/all/$file $hostroot/$file"
	       echo
	       echo -n $hostroot/$file ' ' >>makeuml2.$$
	esac
    done	 
    nicelists=`cat makeuml2.$$`
    depends="$depends $nicelists"
    rm -f makeuml.$$ makeuml2.$$

    # copy configuration files, but make sure that they are up-to-date.
    (cd ${TESTINGROOT}/baseconfigs/$host && find . -type f -print) | sed -e 's,^\./,,'  >makeuml.$$
    echo -n >makeuml2.$$
    cat makeuml.$$ | while read file
    do
        case $file in
	    *~) ;;
	    *CVS/*);;
	    etc/fstab);;
	    */.\#*);;
	    *) echo "$hostroot/$file : ${TESTINGROOT}/baseconfigs/$host/$file $hostroot"
	       echo "$TAB rm -f $hostroot/$file && mkdir -p `dirname $hostroot/$file` && cp ${TESTINGROOT}/baseconfigs/$host/$file $hostroot/$file"
	       echo
	       echo -n $hostroot/$file ' ' >>makeuml2.$$
	esac
    done	 
 
    nicelists=`cat makeuml2.$$`
    depends="$depends $nicelists"
    rm -f makeuml.$$ makeuml2.$$

    # setup the mount of /usr/share
    echo "$hostroot/etc/fstab : ${TESTINGROOT}/baseconfigs/$host/etc/fstab"
    echo "$TAB cp ${TESTINGROOT}/baseconfigs/$host/etc/fstab $hostroot/etc/fstab"
    echo "$TAB echo none	   /usr/share		     hostfs   defaults,ro,$SHAREROOT 0 0 >>$hostroot/etc/fstab"
    echo "$TAB echo none	   /testing		     hostfs   defaults,ro,${TESTINGROOT} 0 0 >>$hostroot/etc/fstab"
    echo "$TAB echo none	   /usr/src		     hostfs   defaults,ro,${FREESWANSRCDIR} 0 0 >>$hostroot/etc/fstab"
    depends="$depends $hostroot/etc/fstab"

    # split Debian "interfaces" file into RH ifcfg-* file
    echo "$hostroot/etc/sysconfig/network-scripts/ifcfg-eth0: $hostroot/etc/network/interfaces"
    echo "$TAB mkdir -p $hostroot/etc/sysconfig/network-scripts"
    echo "$TAB ${TESTINGROOT}/utils/interfaces2ifcfg.pl $hostroot/etc/network/interfaces $hostroot/etc/sysconfig/network-scripts"
    echo
    depends="$depends $hostroot/etc/sysconfig/network-scripts/ifcfg-eth0"

    if [ "X$HOSTTYPE" == "Xfreeswan" ]
    then
	# install FreeSWAN if appropriate.
        
	echo "$hostroot/usr/local/sbin/ipsec : ${FREESWANSRCDIR}/Makefile.inc ${FREESWANSRCDIR}/Makefile.ver"
	echo "$TAB cd ${FREESWANSRCDIR} && make DESTDIR=$POOLSPACE/$hostroot install"
	echo
	depends="$depends $hostroot/usr/local/sbin/ipsec"

	# update the module, if any.
	echo "$hostroot/ipsec.o : module/ipsec.o $hostroot"
	echo "$TAB -cp module/ipsec.o $hostroot/ipsec.o"
	echo
	depends="$depends $hostroot/ipsec.o"

	# make module startup script
	startscript=$POOLSPACE/$host/startmodule.sh
	echo "$startscript : $FREESWANSRCDIR/umlsetup.sh $hostroot/ipsec.o"
	echo "$TAB echo '#!/bin/sh' >$startscript"
	echo "$TAB echo ''          >>$startscript"
	echo "$TAB echo '# get $net value from baseconfig'          >>$startscript"
	echo "$TAB echo . ${TESTINGROOT}/baseconfigs/net.$host.sh   >>$startscript"
	echo "$TAB echo ''          >>$startscript"
	echo "$TAB echo '$POOLSPACE/plain/linux root=/dev/root rootfstype=hostfs rootflags=$POOLSPACE/$hostroot rw umid=$host \$\$net \$\$UML_DEBUG_OPT \$\$UML_"${host}"_OPT \$\$*' >>$startscript"
	echo "$TAB chmod +x $startscript"
	echo
	depends="$depends $startscript"
    fi

    # make startup script
    startscript=$POOLSPACE/$host/start.sh
    echo "$startscript : $FREESWANSRCDIR/umlsetup.sh"
    echo "$TAB echo '#!/bin/sh' >$startscript"
    echo "$TAB echo ''          >>$startscript"
    echo "$TAB echo '# get $net value from baseconfig'          >>$startscript"
    echo "$TAB echo . ${TESTINGROOT}/baseconfigs/net.$host.sh   >>$startscript"
    echo "$TAB echo ''          >>$startscript"
    echo "$TAB echo '$POOLSPACE/$host/linux root=/dev/root rootfstype=hostfs rootflags=$POOLSPACE/$hostroot rw umid=$host \$\$net \$\$UML_DEBUG_OPT \$\$UML_"${host}"_OPT \$\$*' >>$startscript"
    echo "$TAB chmod +x $startscript"
    echo
    depends="$depends $startscript"

    echo "$host : $depends"
    echo
    echo
}

setup_host() {
    host=$1
    KERNEL=$2
    KERNDIR=`dirname $KERNEL`

    hostroot=$POOLSPACE/$host/root
    mkdir -p $hostroot
    # copy (with hard links) 
    (cd ${BASICROOT} && find . -print | cpio -pld $hostroot 2>/dev/null )

    # make private copy of /var.
    rm -rf $hostroot/var
    (cd ${BASICROOT} && find var -print | cpio -pd $hostroot 2>/dev/null )

    # make sure that we have /dev, /tmp and /var/run
    mkdir -p $hostroot/dev $hostroot/tmp $hostroot/var/run $hostroot/usr/share $hostroot/proc

    # root image is debian, but FreeSWAN expects redhat
    mkdir -p $hostroot/etc/rc.d
    if [ ! -d $hostroot/etc/rc.d/init.d ]
    then
      (cd $hostroot/etc/rc.d && ln -fs ../init.d ../rc?.d . )
    fi
    
    # nuke certain other files that get in the way of booting
    rm -f $hostroot/etc/mtab
    rm -f $hostroot/sbin/hwclock

    # set up the timezone
    rm -f $hostroot/etc/localtime 

    # dummy out fsck.
    ln -f $hostroot/bin/true $hostroot/sbin/fsck.hostfs

    # force it to GMT, otherwise (RH7.1) use host's zoneinfo.
    if [ -f /usr/share/zoneinfo/GMT ] 
    then
      cp /usr/share/zoneinfo/GMT $hostroot/etc/localtime
    else
      cp /etc/localtime $hostroot/etc/localtime
    fi

    # or, you might want to force it to local
    # cp /etc/localtime $hostroot/etc/localtime

    # copy configuration files
    ### XXX this should be done with a generated Makefile.
    (cd ${TESTINGROOT}/baseconfigs/$host && tar cf - .) | (cd $hostroot && tar -x -f - --unlink-first)

    # setup the mount of /usr/share
    echo "none	   /usr/share		     hostfs   defaults,ro,$SHAREROOT 0 0" >>$hostroot/etc/fstab

    # split Debian "interfaces" file into RH ifcfg-* file
    mkdir -p $hostroot/etc/sysconfig/network-scripts
    ${TESTINGROOT}/utils/interfaces2ifcfg.pl $hostroot/etc/network/interfaces $hostroot/etc/sysconfig/network-scripts

    # copy kernel.
    if [ ! -f $POOLSPACE/$host/linux ]
    then
	rm -f $POOLSPACE/$host/linux
	cp $KERNEL $POOLSPACE/$host/linux
    fi

    # update the module, if any.
    if [ -f $KERNDIR/net/ipsec/ipsec.o ]
    then
	cp $KERNDIR/net/ipsec/ipsec.o $POOLSPACE/$host/root/ipsec.o
    fi

    # make startup script
    startscript=$POOLSPACE/$host/start.sh
    if [ ! -f $startscript ]
    then
	echo '#!/bin/sh' >$startscript
	echo ''          >>$startscript
	echo '# get $net value from baseconfig'          >>$startscript
	echo ". ${TESTINGROOT}/baseconfigs/net.$host.sh" >>$startscript
	echo ''          >>$startscript
	echo "$POOLSPACE/$host/linux ubd0=$hostroot umid=$host \$net \$UML_DEBUG_OPT \$UML_$host_OPT \$*" >>$startscript
	chmod +x $startscript
    fi
}

#
# $Log: uml-functions.sh,v $
# Revision 1.28  2003/09/02 19:45:48  mcr
# 	use rootfs= directive instead of ubd0= directive for
# 	setting hostfs root file system.
#
# Revision 1.27  2003/07/30 16:46:57  mcr
# 	created /var/log/pluto/peer directory in UMLs.
#
# Revision 1.26  2003/06/22 21:53:53  mcr
# 	generated makefile list had $hostroot missing, put it in with
# 	a more obvious way.
#
# Revision 1.25  2003/06/22 21:41:05  mcr
# 	while the file targets themselves were sanitized, the list of
# 	targets was not sanitized by the same process, and so got out
# 	of sync - it left in CVS backups. Now use the same process.
# 	Problem discovered by DHR in week of 2003/06/17.
#
# Revision 1.24  2002/11/11 17:07:18  mcr
# 	ignore CVS backup files.
#
# Revision 1.23  2002/10/30 05:00:35  rgb
# Added missing escape to catch litteral "." followed by "/" rather than
# "any char" followed by "/".
#
# Revision 1.22  2002/10/26 15:10:39  mcr
# 	make sure that all files are in the dependancy list.
#
# Revision 1.21  2002/10/22 01:13:49  mcr
# 	UML root file system will copy files from "all" config
# 	and then files from specific hosts.
#
# Revision 1.20  2002/10/17 02:39:53  mcr
# 	make sure to set SUBARCH for module builds.
#
# Revision 1.19  2002/10/02 02:18:29  mcr
# 	con=pts was not a good idea - it isn't harmless for 2.4.18.
#
# Revision 1.18  2002/09/30 16:04:29  mcr
# 	include "con=pts" for 2.4.19 UMLs.
#
# Revision 1.17  2002/09/16 18:23:58  mcr
# 	make the installed UML copy of FreeSWAN depend upon
# 	Makefile.ver as well.
#
# Revision 1.16  2002/08/29 23:47:09  mcr
# 	when generating UMLPOOL/Makefile, make sure that the generated
# 	ipsec.o depends upon the KLIPS source code
#
# Revision 1.15  2002/08/08 01:53:36  mcr
# 	when building the UML environment, make the $FREESWANSRCDIR
# 	available as /usr/src, and the $FREESWANSRCDIR/testing as /testing.
#
# Revision 1.14  2002/08/05 00:17:45  mcr
# 	do not install FreeSWAN for "regular hosts"
#
# Revision 1.13  2002/08/02 22:33:06  mcr
# 	create startmodule.sh that uses UMLPOOL/plain.
# 	copy ipsec.o module from UMLPOOL/module.
# 	build UMLPOOL/module/ipsec.o in common section.
#
# Revision 1.12  2002/07/29 15:47:21  mcr
# 	copying of BASICROOT often results in an error, which can be
# 	ignored.
# 	ignore CVS directories more carefully.
#
# Revision 1.11  2002/07/29 05:58:58  mcr
# 	generated UMLPOOL/Makefile now installs FreeSWAN as well.
#
# Revision 1.10  2002/07/29 05:52:31  mcr
# 	more adjusting of quoting - lost $* on end of command line.
# 	this is needed so that klipstest can invoke "east single"
#
# Revision 1.9  2002/07/29 05:46:42  mcr
# 	quiet the make output with @ on every line.
# 	the depends list does not get updated in a subshell, so
# 	reprocess it again.
# 	adjust quoting for start.sh script...
#
# Revision 1.8  2002/07/29 02:46:58  mcr
# 	make sure that the directories are made before they are used.
# 	remove ./ from file names so that dependancies find the right file.
#
# Revision 1.7  2002/07/29 01:02:20  mcr
# 	instead of actually doing all the operations, build
# 	a makefile in $POOLSPACE that will do it whenever necessary.
#
# Revision 1.6  2002/07/15 09:58:14  mcr
# 	removed ubd1 from /etc/fstab, and command line.
# 	add /usr/share mount to /etc/fstab post-copy.
#
# Revision 1.5  2002/04/04 00:19:02  mcr
# 	when setting up root file systems, see if we built an ipsec.o
# 	as part of the kernel build, and if so, copy it to /ipsec.o for
# 	later use.
#
# Revision 1.4  2002/01/12 02:50:29  mcr
# 	when removing /var to make private copy, make sure that
# 	-f(orce) is set.
#
# Revision 1.3  2001/11/23 00:38:41  mcr
# 	make /var private
# 	make fake fsck.hostfs
# 	split Debian interfaces file into RH file using script.
#
# Revision 1.2  2001/11/07 20:10:20  mcr
# 	revised setup comments after RGB consultation.
# 	removed all non-variables from umlsetup-sample.sh.
#
# Revision 1.1  2001/11/07 19:25:17  mcr
# 	split out some functions from make-uml.
#
#


