//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: DegreeOfFreedomSet.hpp,v 1.2 2003/11/03 18:56:05 delpinux Exp $

#ifndef DEGREE_OF_FREEDOM_SET_HPP
#define DEGREE_OF_FREEDOM_SET_HPP

#include <system.h>
/*!
  \class DegreeOfFreedomSet

  This class defines degrees of freedom sets in the case where all the
  unknown share the same sets of vertices.

  \author Stphane Del Pino
*/

class DegreeOfFreedomSet
{
protected:
  const size_t __numberOfVariables;

  const size_t __numberOfVertices;

public:
  const size_t& numberOfVariables() const
  {
    return __numberOfVariables;
  }

  const size_t& numberOfVertices() const
  {
    return __numberOfVertices;
  }

  size_t size() const
  {
    return __numberOfVertices * __numberOfVariables;
  }

  virtual size_t operator()(const size_t& variableNumber,
			    const size_t& vertexNumber) const
  {
    return (vertexNumber*__numberOfVariables+variableNumber);
  }

  DegreeOfFreedomSet(const size_t& numberOfVariables,
		     const size_t& numberOfVertices)
    : __numberOfVariables(numberOfVariables),
      __numberOfVertices(numberOfVertices)
  {
    ;
  }

  DegreeOfFreedomSet(const DegreeOfFreedomSet& dofSet)
    : __numberOfVariables(dofSet.__numberOfVariables),
      __numberOfVertices(dofSet.__numberOfVertices)
  {
    ;
  }

  virtual ~DegreeOfFreedomSet()
  {
    ;
  }
};

#endif // DEGREE_OF_FREEDOM_SET_HPP

