//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: FileDescriptor.hpp,v 1.2 2004/01/15 20:30:25 delpinux Exp $

#ifndef FILE_DESCRIPTOR_HPP
#define FILE_DESCRIPTOR_HPP

class FileDescriptor
{
public:
  enum FormatType {
    medit,
    dataExplorer
  };

  enum FileType {
    Unix,
    Dos,
    Mac,
    Binary
  };

  static FileDescriptor::FormatType formatType(const char* c)
  {
    if (std::strcmp(c,"medit") == 0) {
      return FileDescriptor::medit;
    }
    if (std::strcmp(c,"opendx") == 0) {
      return FileDescriptor::dataExplorer;
    }

    fferr(2) << c << ": Unknown File Type\n";
    std::exit(1);
    return FileDescriptor::dataExplorer;
  }

  static FileDescriptor::FileType fileType(const char* c)
  {
    if (std::strcmp(c,"unix") == 0) {
      return FileDescriptor::Unix;
    }
    if (std::strcmp(c,"dos") == 0) {
      return FileDescriptor::Dos;
    }
    if (std::strcmp(c,"mac") == 0) {
      return FileDescriptor::Mac;
    }
    if (std::strcmp(c,"binary") == 0) {
      return FileDescriptor::Binary;
    }

    fferr(2) << c << ": Unknown File Type\n";
    std::exit(1);
    return FileDescriptor::Unix;
  }

private:
  const FileDescriptor::FormatType __formatType;
  const FileDescriptor::FileType __fileType;

public:
  const FileDescriptor::FormatType& format() const
  {
    return __formatType;
  }

  const FileDescriptor::FileType& type() const
  {
    return __fileType;
  }

  const std::string cr() const
  {
    std::string CR;

    switch (__fileType) {
    case (FileDescriptor::Unix): {
      CR = '\n';
      break;
    }
    case (FileDescriptor::Dos): {
#ifndef __MINGW32__
      CR = "\r\n";
#else // __MINGW32__
      CR = "\n";
#endif // __MINGW32__
      break;
    }
    case (FileDescriptor::Mac): {
      CR = '\r';
      break;
    }
    case (FileDescriptor::Binary): {
      CR = '\r';
      break;
    }
    default: {
      fferr(2) << __FILE__ << ':' << __LINE__ << ": unknown file type\n";
      std::exit(1);
    }
    }
    return CR;
  }

  FileDescriptor(const FileDescriptor::FormatType& format,
		 const FileDescriptor::FileType& type)
    : __formatType(format),
      __fileType(type)
  {
    ;
  }

  FileDescriptor(const FileDescriptor& f)
    : __formatType(f.__formatType),
      __fileType(f.__fileType)
  {
    ;
  }

  ~FileDescriptor()
  {
    ;
  }
};

#endif // FILE_DESCRIPTOR_HPP
