/* -*- C -*-

  Copyright (c) 1994-2001 by the Massachusetts Institute of Technology.
  Copyright (c) 2001-2002 by beingmeta, inc. (A Delaware Corporation)
  All rights reserved.

  $Id: fdscript.h,v 1.5 2002/04/02 21:41:08 haase Exp $

  This file is part of FramerD, a representation language and semantic
  database developed by Kenneth B. Haase and his students at the Media
  Laboratory at the Massachusetts Institute of Technology in Cambridge,
  Massachusetts.  Research at the Media Lab is supported by funds and
  equipment from a variety of corporations and government sponsors whose
  contributions are gratefully acknowledged.

    Use, modification, and redistribution of this program is permitted
    under the terms of either (at the developer's discretion) the GNU
    General Public License (GPL) Version 2, the GNU Lesser General Public
    License.

    This program is based on the FramerD library released in Fall 2001 by
    MIT under both the GPL and the LGPL licenses, both of which accompany
    this distribution.  Subsequent modifications by beingmeta, inc. are
    also released under both the GPL and LGPL licenses (at the developer's
    discretion).

*************************************************************************/

#ifndef FRAMERD_FDSCRIPT_H /* If defined, skip the file */
#define FRAMERD_FDSCRIPT_H

#include "framerd/common.h"
#include "framerd/cons.h"
#include "framerd/os.h"

#include "framerd/index.h"
#include "framerd/odb.h"
#include "framerd/search.h"

#include "framerd/eval.h"

/* A few external procedures */

FDSCRIPT_EXPORT fd_lispenv fd_osprims_env;
FDSCRIPT_EXPORT fd_lispenv fd_fdinternals_env;
FDSCRIPT_EXPORT fd_exception fd_Cant_Write_File, fd_Cant_Read_File;
FDSCRIPT_EXPORT fd_exception fd_DefframeExpectationFailure;

FDSCRIPT_EXPORT
fd_lisp fd_interaction_loop
  (void *data,fd_lispenv env,
   fd_lisp (*get_expr)(void *,fd_lispenv),
   void (*display_result)(void *,fd_lispenv,fd_lisp),
   void (*show_status)(void *,fd_lispenv,char *),
   void (*report_error)(void *,fd_lispenv,fd_exception,char *,fd_lisp,
			struct FD_EXCEPTION_CONTEXT *));

FDSCRIPT_EXPORT fd_lisp fd_console_loop(fd_lispenv env);
FDSCRIPT_EXPORT fd_lisp fd_busy_console_loop(fd_lispenv env);
FDSCRIPT_EXPORT fd_lisp fd_promptless_loop(fd_lispenv env);

FDSCRIPT_EXPORT double fd_to_float(fd_lisp x);
FDSCRIPT_EXPORT fd_lisp fd_default_input_port();
FDSCRIPT_EXPORT fd_lisp fd_default_output_port();

FDSCRIPT_EXPORT void fd_display_string(char *string,fd_lisp ports);
FDSCRIPT_EXPORT void fd_display(fd_lisp x,fd_lisp ports);
FDSCRIPT_EXPORT void fd_display_strings(fd_lisp ports,...);
FDSCRIPT_EXPORT void fd_printout(fd_lisp port,fd_lisp body,fd_lispenv env);
FDSCRIPT_EXPORT fd_lisp fd_stringout(fd_lisp body,fd_lispenv env);

FDSCRIPT_EXPORT void fd_initialize_fdscript(void);

/* Math functions */

FDSCRIPT_EXPORT fd_lisp fd_plus(fd_lisp x,fd_lisp y);
FDSCRIPT_EXPORT fd_lisp fd_minus(fd_lisp x,fd_lisp y);
FDSCRIPT_EXPORT fd_lisp fd_times(fd_lisp x,fd_lisp y);
FDSCRIPT_EXPORT fd_lisp fd_div(fd_lisp x,fd_lisp y);
FDSCRIPT_EXPORT int fd_compare(fd_lisp x,fd_lisp y);


/* URL access functions */

FDSCRIPT_EXPORT void fd_register_url_protocol(char *,fd_lisp (*getter)(char *));
FDSCRIPT_EXPORT fd_lisp fd_urlget(char *);

#endif /* FRAMERD_H */



/* File specific stuff */

/* The CVS log for this file
   $Log: fdscript.h,v $
   Revision 1.5  2002/04/02 21:41:08  haase
   Added log and emacs init entries to C source files

*/

/* Emacs local variables
;;;  Local variables: ***
;;;  compile-command: "cd ../..; make" ***
;;;  End: ***
*/
