#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /cvsroot/fnorb/fnorb/orb/Protocol.py,v $
# Version:      @(#)$RCSfile: Protocol.py,v $ $Revision: 1.7 $
#
#############################################################################
""" Protocol module. """


class Protocol:
    """ Abstract class for GIOP transport protocols. """

    def enable(self, host, port):
	""" Create an endpoint on which to listen for connection requests. """

	pass

    def disable(self):
	""" Destory the endpoint that is listening for connection requests. """

	pass

    def start(self, timeout=0):
	""" Start the protocol event loop. """

	pass

    def stop(self):
	""" Stop the protocol event loop. """

	pass

# fixme: Do we need these too?

##     def create_reactor(self):
## 	""" Factory method to create a reactor for this protocol. """
## 	pass

##     def create_acceptor(self):
## 	""" Factory method to create an acceptor for this protocol. """
## 	pass

    def create_connection(self):
	""" Factory method to create a connection for this protocol. """
	pass

    def create_profile(self, id, components):
	""" Create an IOR profile for the protocol. """

	pass

    def get_object_key(self, ior):
	""" Extract the object key from an IOR. """

	pass

    def get_address(self, ior):
	""" Extract the address from an IOR. """

	pass

    def is_local(self, ior):
	""" Does the IOR reference an object in *this* ORB? """

	pass

#############################################################################
