/***************************************************************************
                          FLParameterQuery.h  -  description
                             -------------------
    begin                : dom jun 23 2002
    copyright            : (C) 2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLPARAMETERQUERY_H
#define FLPARAMETERQUERY_H

#include <qstring.h>
#include <qvariant.h>

/** Representa objetos que encapsulan parmetros de una consulta  o un filtro

    @author Federico Albujer Zornoza
    @version 0.4 */
class FLParameterQuery
{
    public:
	
    /** constructor.

        @param  n   Nombre del parmetro
        @param  a   Alias del parmetro
        @param  t   Tipo del parmetro */
    FLParameterQuery( const QString & n, const QString & a, const int t );
	
    /** destructor */
    ~FLParameterQuery();

    /** Obtiene el nombre del parmetro.

        @return Nombre del parmetro */
    const QString & name () const
    {
        return name_;
    }

    /** Obtiene el alias del parmetro.

        @return Alias del parmetro */
    const QString & alias () const
    {
        return alias_;
    }

    /** Obtiene el tipo del parmetro.

        @return El tipo del parmetro*/
    const int type () const
    {
        return type_;
    }

    /** Obtiene el valor del parmetro.

        @return El valor del parmetro*/
    const QVariant & value () const
    {
        return value_;
    }

    /** Establece el valor del parmetro.

        @param v    Valor del parmetro */
    void setValue( const QVariant & v )
    {
        value_=v;
    }

    private:

    /** Nombre del parmetro */
    QString name_;

    /** Alias del parmetro */
    QString alias_;

    /** Tipo de datos del parmetros */
    int type_;

    /** Valor del parmetro */
    QVariant value_;
};

#endif
