/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan.c,v 1.14 2005/02/06 23:49:12 hoa Exp $
 */

#include <signal.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "etpan-errors.h"
#include "etpan-tools.h"
#include "etpan-app.h"
#include "etpan-app-subapp.h"
#include "etpan-folder-list-app.h"
#include "etpan-msg-list-app.h"
#include "etpan-msg-viewer-app.h"
#include "etpan-console-app.h"
#include "etpan-config.h"


struct mailfolder *
find_shortname_folder(struct mailfolder * folder, char * name)
{
  unsigned int i;

  if (folder->fld_virtual_name != NULL) {
    if (strcmp(folder->fld_virtual_name, name) == 0)
      return folder;
  }

  for(i = 0 ; i < carray_count(folder->fld_children) ; i ++) {
    struct mailfolder *  child;
    struct mailfolder *  found;

    child = carray_get(folder->fld_children, i);

    found = find_shortname_folder(child, name);
    if (found != NULL)
      return found;
  }

  return NULL;
}

#if OLD_VERSION
static int view_folder(struct etpan_app * app, struct mailfolder * folder)
{
  struct etpan_msg_list_view * msg_list_view;
  
  msg_list_view = etpan_msg_list_new(app->folder_view,
      app, folder);
  if (msg_list_view == NULL) {
    printf("memory unavailable");
    return ERROR_MEMORY;
  }
  
  etpan_msg_list_run(msg_list_view);
  
  etpan_msg_list_free(msg_list_view);

  return NO_ERROR;
}
#endif

int main(int argc, char ** argv)
{
  int r;
  struct etpan_app * app;
  struct sigaction act;
  struct mailfolder * folder;
  struct etpan_subapp * folderlist_app;
  struct etpan_subapp * msglist_app;
  struct etpan_subapp * msgviewer_app;
  struct etpan_subapp * console;
  char config_path[PATH_MAX];
  char * folder_name;
  int i;
  
  /* stream debug */
#if 0
  mailstream_debug = 1;
#endif
  
  /* remove SIGPIPE signal */
  act.sa_handler = SIG_IGN;
  sigemptyset(&act.sa_mask);
  act.sa_flags = 0;
  
  sigaction(SIGPIPE, &act, NULL);
  
  /* randomize initialization for Message-ID generation */
  srandom(getpid());
  
  /* process argument */
  folder_name = NULL;
  config_path[0] = '\0';
  
  folder = NULL;
  i = 1;
  while (i < argc) {
    if (strcmp(argv[i], "-c") == 0) {
      i ++;
      if (i < argc) {
        strncpy(config_path, argv[i], sizeof(config_path));
        config_path[sizeof(config_path) - 1] = '\0';
        i ++;
      }
    }
    else {
      folder_name = argv[i];
      i ++;
    }
  }
  
  if (config_path[0] == '\0')
    snprintf(config_path, sizeof(config_path),
        "%s/%s", etpan_get_home_dir(), ETPAN_DEFAULT_CONFIG_PATH);
  
  /* init app */
  app = etpan_app_new(config_path);
  if (app == NULL) {
    fprintf(stderr, "could not initialize application\n");
    goto err;
  }
  
#if 0
  /* process argument */
  if (folder_name != NULL) {
    folder = etpan_get_folder(app, folder_name);
    if (folder == NULL)
      folder =
        find_shortname_folder(app->config.vfolder_config->root, folder_name);
  }
  
  if (folder == NULL)
    folder = app->config.vfolder_config->default_folder;
  
  /* initialize */
  console = etpan_console_app_new(app);
  etpan_app_set_console(app, console);
  etpan_app_switch_subapp(console, 0);
  
  folderlist_app = etpan_folder_list_app_new(app);
  r = etpan_folder_list_set_root_folder(folderlist_app,
      app->config.vfolder_config->root);
  etpan_app_switch_subapp(folderlist_app, 0);
  
  if (etpan_3paned(app)) {
    /* 3-paned view */
    msglist_app = etpan_msg_list_app_new(app);
    if (app->config.vfolder_config->default_folder != NULL) {
      etpan_msg_list_app_set_folder(msglist_app,
          app->config.vfolder_config->default_folder);
    }
    etpan_app_switch_subapp(msglist_app, 0);
    
    msgviewer_app = etpan_msg_viewer_app_new(app);
    etpan_app_switch_subapp(msgviewer_app, 0);
    
    if (app->config.vfolder_config->default_folder != NULL)
      etpan_app_switch_subapp(msglist_app, 0);
    else
      etpan_app_switch_subapp(folderlist_app, 0);
  }
  else {
    if (app->config.vfolder_config->default_folder != NULL) {
      
      msglist_app = etpan_msg_list_app_new(app);
      etpan_subapp_set_parent(msglist_app, folderlist_app);
      etpan_msg_list_app_set_folder(msglist_app,
          app->config.vfolder_config->default_folder);
      etpan_app_switch_subapp(msglist_app, 0);
    }
  }
#endif
  
  etpan_app_run(app, NULL);
  
  etpan_app_set_console(app, NULL);
  
  etpan_app_free(app);
  
  return 0;

 err:
  return 1;
}

