------------------------------------------------------------------------
-- Copyright (C) 2002,2003 Daniel Heck
--
-- This program is free software; you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along
-- with this program; if not, write to the Free Software Foundation, Inc.,
-- 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
--
-- $Id: models-2d.lua,v 1.109.2.8 2003/10/11 13:45:26 dheck Exp $
------------------------------------------------------------------------

-- This file defines the models used in Enigma.

dofile(FindDataFile("models.lua"))

def_image("invisible")
def_image("dummy")

TRUE, FALSE = 1, 0

--------------------------------------------------------------------
--                           ACTOR MODELS                         --
--------------------------------------------------------------------
Progress(0)

------------------
-- Spinning top --
------------------
do
    local img=def_subimages("ac-top",
                            {h=9, imgw=32, imgh=32, xoff=-16, yoff=-16})
    def_image("sh-top", {xoff=-10,yoff=-10})

    frames={}
    for i=1,9 do
        def_shmodel("actop"..i, img[i], "sh-top")
        tinsert(frames, "actop"..i)
    end
    def_anim("ac-top", buildframes(frames, 25), TRUE)
end

-----------
-- Rotor --
-----------
do
    local fg=def_subimages("ac-rotor",
                            {h=9, imgw=32, imgh=32, xoff=-16, yoff=-16})
    local bg=def_subimages("sh-rotor",
                            {h=9, imgw=32, imgh=32, xoff=-10, yoff=-10})

    frames={}
    for i=1,9 do
        def_shmodel("ac-rotor"..i, fg[i], bg[i])
        tinsert(frames, "ac-rotor"..i)
    end
    def_anim("ac-rotor", buildframes(frames, 30), TRUE)
end

-----------
-- Horse --
-----------
do
    def_image("ac-horse#", {filename="ac-horse", xoff=-15, yoff=-15})
    def_image("sh-horse", {xoff=-10, yoff=-10})
    def_shmodel("ac-horse", "ac-horse#", "sh-horse")
end

----------------------
-- Small white ball --
----------------------
do
    local fg,img

    -- Normal
    def_image("sh-whiteball-small", {xoff=-4, yoff=-4})
    fg=def_image(nil, {filename="ac-whiteball-small", xoff=-6, yoff=-6})
    def_shmodel("ac-whiteball-small", fg, "sh-whiteball-small")
    def_alias ("ac-whiteball-small-shine", "ac-whiteball-small")

    -- Falling
    img=def_subimages("ac-whiteball-small-fall",
                      {modelname="ac-wbs-f",h=5,imgw=12,imgh=12,
                          xoff=-6,yoff=-6})
    tinsert(img, "invisible")
    def_anim("ac-whiteball-small-fall", composeframes(img,{70,65,60,55,50,30}))
    def_alias("ac-whiteball-small-fallen", "invisible")

    -- Appearing / disappearing
    def_anim("ac-whiteball-small-appear", reverseframes(buildframes(img, 25)))
    def_anim("ac-whiteball-small-disappear", buildframes(img, 25))

    -- Shattering
    img=def_subimages("ac-whiteball-small-shatter",
                      {h=5, imgw=20, imgh=20, xoff=-10, yoff=-10})
    def_anim("ac-whiteball-small-shatter", buildframes(img, 60))
    def_image("ac-whiteball-small-shattered", {xoff=-8, yoff=-9})
end

def_alias("ac-killerball", "ac-whiteball-small")

----------------
-- Black ball --
----------------
do
    local img,f,sh

    -- Normal
    def_image("sh-blackball", {xoff=-6, yoff=-6})
    def_subimages("ac-blackball", {h=2, xoff=-9, yoff=-9, imgw=19, imgh=19})
--    def_image("fg-bb", {filename="ac-blackball", xoff=-9, yoff=-9})
    def_shmodel("ac-blackball", "ac-blackball1", "sh-blackball")
    def_shmodel("ac-blackball-shine", "ac-blackball2", "sh-blackball")

    -- Falling
    img=def_subimages("ac-blackball-fall",{h=10, imgw=24, imgh=24, xoff=-12, yoff=-12})
    tinsert(img, "invisible")
    f=composeframes(img,{70,65,60,55,50,50,50,50,50,50,50})
    def_anim("ac-blackball-fall", f)
    def_alias("ac-blackball-fallen", "invisible")

    -- Appearing / disappearing
    def_anim("ac-blackball-appear", reverseframes(buildframes(img, 25)))
    def_anim("ac-blackball-disappear", buildframes(img, 25))

    -- Sinking
    img=def_subimages("ac-blackball-sinkdown",{h=7,imgw=19,imgh=19,xoff=-9,yoff=-9})
    sh =def_subimages("sh-blackball-sinkdown",{h=7,imgw=19,imgh=19,xoff=-6,yoff=-6})
    for i=1,getn(img) do
        def_shmodel("ac-blackball-sink"..(i-1), img[i], sh[i])
    end
    def_alias("ac-blackball-sunk", "invisible")

    img=def_subimages("ac-drowned",{h=5,imgw=19,imgh=19,xoff=-9,yoff=-9});
    def_anim("ac-drowned",buildframes(img,80))

    -- Shattering
    img=def_subimages("ac-blackball-shatter",
                      {h=5, imgw=40, imgh=40, xoff=-20, yoff=-20})
    def_anim("ac-blackball-shatter", buildframes(img, 60))

    def_image("ac-blackball-shattered", {xoff=-20, yoff=-20})
end

----------------
-- White ball --
----------------
do
    local img,f

    -- Normal
    def_image("sh-whiteball", {xoff=-6, yoff=-6})
    def_image("fg-wb", {filename="ac-whiteball", xoff=-9, yoff=-9})
    def_shmodel("ac-whiteball", "fg-wb", "sh-whiteball")
    def_alias("ac-whiteball-shine", "ac-whiteball")

    -- Falling
    img=def_subimages("ac-whiteball-fall",{h=10, imgw=24, imgh=24, xoff=-12, yoff=-12})
    tinsert(img, "invisible")
    f=composeframes(img,{70,65,60,55,50,50,50,50,50,50,50})
    def_anim("ac-whiteball-fall", f)
    def_alias("ac-whiteball-fallen", "invisible")

    -- Appearing / disappearing
    def_anim("ac-whiteball-appear", reverseframes(buildframes(img, 25)))
    def_anim("ac-whiteball-disappear", buildframes(img, 25))

    -- Sinking
    img=def_subimages("ac-whiteball-sinkdown",{h=7,imgw=19,imgh=19,xoff=-9,yoff=-9})
    sh =def_subimages("sh-blackball-sinkdown",{h=7,imgw=19,imgh=19,xoff=-6,yoff=-6})
    for i=1,getn(img) do
        def_shmodel("ac-whiteball-sink"..(i-1), img[i], sh[i])
    end
    def_alias("ac-whiteball-sunk", "invisible")

--    img=def_subimages("ac-drowned",{h=5,imgw=19,imgh=19,xoff=-9,yoff=-9});
--    def_anim("ac-drowned",buildframes(img,80))

    -- Shattering
    img=def_subimages("ac-whiteball-shatter",
                      {h=5, imgw=40, imgh=40, xoff=-20, yoff=-20})
    def_anim("ac-whiteball-shatter", buildframes(img, 60))

    def_alias("ac-whiteball-shattered", img[5])
end

-- Jumping normal balls --
do
    namelist=def_subimages("ac-blackball-jump", {h=4, imgw=32, imgh=32, xoff=-16, yoff=-16})
    shadows=def_subimages("sh-blackball-jump", {h=4, imgw=32, imgh=32, xoff=-10, yoff=-10})
    frames={}
    for i=1,4 do
        def_shmodel("bb-jump"..i, namelist[i], shadows[i])
        tinsert(frames, "bb-jump"..i)
    end
    def_anim("ac-blackball-jump", pingpong(buildframes(frames, 70)))

    namelist=def_subimages("ac-whiteball-jump", {h=4, imgw=32, imgh=32, xoff=-16, yoff=-16})
    frames={}
    for i=1,4 do
        def_shmodel("wb-jump"..i, namelist[i], shadows[i])
        tinsert(frames, "wb-jump"..i)
    end
    def_anim("ac-whiteball-jump", pingpong(buildframes(frames, 70)))
end

---------
-- Bug --
---------
do
    def_image("ac-bug#", {filename="ac-bug", xoff=-6, yoff=-6})
    def_shmodel("ac-bug", "ac-bug#", "sh-whiteball-small")
end

-- Marbles in inventory  --
def_image("inv-blackball")
def_image("inv-whiteball")


------------------
-- Floor models --
------------------
Progress(10)

function def_floors(floorlist)
    for i,name in floorlist do
	def_image(name)
    end
end

function def_randfloor(name, imagelist)
    def_floors(imagelist)
    display.DefineRandModel(name, getn(imagelist), imagelist)
end

-- _si for _subimage
function def_randfloor_si(name, height, width)
    imagelist=def_subimages(name, {h=height, w=width})
    display.DefineRandModel(name, getn(imagelist), imagelist)
end

--if options.WizardMode > 0 then
--    def_subimages("fl-gradient-wiz", {modelname="fl-gradient",w=6, h=4})
--else
def_subimages("fl-gradient2", {w=6, h=4, modelname="fl-gradient"})
--end

def_randfloor("fl-rock", {"fl-rock1", "fl-rock2"})
def_floors{"fl-abyss"}
def_alias("fl-abyss_fake", "fl-abyss")
def_floors{"fl-dunes", "fl-sand", "fl-bluegreen", "fl-bluegreenx"}
def_floors{"fl-inverse", "fl-inverse2", "fl-white", "fl-black", "fl-acwhite", "fl-acblack"}
def_floors{"fl-springboard"}
def_image("fl-normal")
def_randfloor_si("fl-hay", 4)
def_floors{"fl-floor_001"}
def_floors{"fl-ice_001"}
def_floors{"fl-stone"}
def_alias("fl-normal_x", "fl-normal")
def_floors{"fl-dummy"}
def_floors{"fl-light"}
def_floors{"fl-trigger"}
def_randfloor_si("fl-concrete", 4)
def_randfloor_si("fl-gravel", 4)
def_randfloor_si("fl-bumps", 2,2)
def_randfloor_si("fl-mortar", 2, 2)

def_randfloor_si("fl-brick", 3)
def_randfloor_si("fl-space", 3,2)
def_randfloor_si("fl-rough", 5)
def_randfloor("fl-rough_medium", {"fl-rough5", "fl-rough1", "fl-rough2", "fl-rough3", "fl-rough4"})
def_randfloor("fl-rough_slow", {"fl-rough5", "fl-rough1", "fl-rough2", "fl-rough3", "fl-rough4"})
def_randfloor_si("fl-gray", 5)
def_randfloor_si("fl-leaves", 3)
def_randfloor_si("fl-metal", 6)
def_randfloor_si("fl-plank", 4)
def_randfloor_si("fl-water", 4)
def_randfloor_si("fl-swamp", 4)
def_randfloor_si("fl-woven", 5)
def_randfloor_si("fl-marble", 4)
def_randfloor_si("fl-wood", 4)
def_subimages("fl-stwood", {h=2})
def_randfloor_si("fl-stwood", 2)
def_randfloor_si("fl-bluegray", 4)
def_randfloor_si("fl-red", 4)
def_randfloor_si("fl-rough-blue", 4)
def_randfloor_si("fl-rough-red", 4)
def_randfloor_si("fl-sahara", 4)
def_randfloor_si("fl-tigris", 4)
def_randfloor_si("fl-samba", 2)
def_randfloor_si("fl-himalaya", 4)

--
-- Bridges
--
def_image("fl-bridgea-open")
def_image("fl-bridgea-closed")
namelist=def_subimages("fl-bridgea", {h=10})
frames = buildframes(namelist,70)
def_anim("fl-bridgea-opening", reverseframes(frames))
def_anim("fl-bridgea-closing", frames)


def_image("fl-bridgex-open")
def_image("fl-bridgex-closed")
namelist=def_subimages("fl-bridgex", {h=9})
frames = buildframes(namelist,70)
def_anim("fl-bridgex-opening", frames)
def_anim("fl-bridgex-closing", reverseframes(frames))


def_image("fl-bridgey-open")
def_image("fl-bridgey-closed")
namelist=def_subimages("fl-bridgey", {h=9})
frames = buildframes(namelist,70)
def_anim("fl-bridgey-opening", frames)
def_anim("fl-bridgey-closing", reverseframes(frames))

--------------------------------------------------------------------------
--                           ITEM MODELS                                --
--------------------------------------------------------------------------
Progress(20)

do
    def_image("items")
    local itemtiles={
        "it-brush", "it-floppy",
        "it-document", "it-hammer",
        "it-key", "it-spade",
        "it-umbrella", "it-extralife",
        "it-hill", "it-hollow", "it-tinyhill", "it-tinyhollow",
        "it-laserh", "it-laserv", "it-laserhv",
        "it-magicwand",
        "it-spring1", "it-spring2",
        "it-sword",
        "it-surprise",
        "it-trigger", "it-trigger1",
        "it-yinyang", "it-yanying",
        "it-puller-n", "it-puller-e", "it-puller-s", "it-puller-w",
        "it-odometer",
        "it-flagblack", "it-flagwhite",
        "it-soother", "it-pin",
    }
    def_tiles("items", itemtiles)
end

-- Puller animation
do
    local models={"it-puller-n", "it-puller-e", "it-puller-s", "it-puller-w"}
    local frames=buildframes(models, 100)
    def_anim("it-puller-active", repeatanim(frames, 4), FALSE)
end

def_images{
    "it-blackbomb",
    "it-whitebomb",
    "it-dynamite",
    "it-dummy",
    "it-blocker",
    "it-coffee",
    "it-wrench",
    "it-cherry",
    "it-glasses",
    "it-glasses-broken",
    "it-weight",
    "it-landmine",
    "it-hstrip",
    "it-vstrip"
}

def_alias("it-key_a", "it-key")
def_alias("it-key_b", "it-key")
def_alias("it-key_c", "it-key")

-- Seed --
do
    local n = def_subimages("it-seed", {h=5})
    def_alias("it-seed", "it-seed1")
    local f={
        "it-seed1", "it-seed2", "it-seed1", "it-seed3", "it-seed1", "it-seed2",
        "it-seed1", "it-seed4", "it-seed5", "it-seed4", "it-seed1",
        "it-seed4", "it-seed5",
    }
    def_anim("it-seed-growing", buildframes(f, 120))
end

-- Cracks --
namelist=def_subimages("it-crack", {h=8})
--frames=buildframes({"it-crack4", "it-crack6", "it-crack7", "it-crack8"},90)
frames=buildframes(namelist,50)
def_anim("it-debris", frames)

frames=buildframes({"it-crack4", "it-crack5"},120)
def_anim("it-crack_anim1", frames)

frames=buildframes({"it-crack6", "it-crack7", "it-crack8"},120)
def_anim("it-crack_anim2", frames)

-- Burning Floor --
frames=buildframes(def_subimages("it-burnable_ignite", {h=8}), 100)
def_anim("it-burnable_ignite", frames)

frames=buildframes(def_subimages("it-burnable_burning", {h=8}), 100)
def_anim("it-burnable_burning", frames)

def_images{ "it-burnable_ash", "it-burnable_fireproof"}

do
   local img = def_subimages("it-extinguisher", {h=3})
   def_alias("it-extinguisher_full", img[1])
   def_alias("it-extinguisher_medium", img[2])
   def_alias("it-extinguisher_empty", img[3])
end


-- Magnet --
def_image("it-magnet-off")
frames=buildframes(def_subimages("it-magnet-on", {h=5}), 100)
def_anim("it-magnet-on", frames, 1)

-- Wormhole --
do
    local f = buildframes(def_subimages("it-wormhole", {h=2}), 100)
    def_anim("it-wormhole", f, TRUE)
end

-- Vortex --
do
   local img = def_subimages("it-vortex", {h=4})
   def_alias("it-vortex-open", img[1])
   def_alias("it-vortex-closed", img[4])

   def_anim("it-vortex-opening", reverseframes(buildframes(img, 100)))
   def_anim("it-vortex-closing", buildframes(img, 100))
end

-- Coins --
def_images{"it-coin1", "it-coin2", "it-coin4"}

-- Burning dynamite --
dyn_frames=buildframes(def_subimages("it-dynamite-burning", {h=15}), 100)
def_anim("it-dynamite-burning", dyn_frames) --repeat_frames(dyn_frames,3,2))

-- Burning bomb --
frames=buildframes(def_subimages("it-blackbomb-burning", {h=9}), 100)
def_anim("it-blackbomb-burning", frames) --repeat_frames(frames,3,2))

frames=buildframes(def_subimages("it-whitebomb-burning", {h=9}), 100)
def_anim("it-whitebomb-burning", frames) --repeat_frames(frames,3,2))

-- Explosion --
def_anim_images("expl", {{"expl", 50}})

-- Pipes --
def_tiles("it-pipe", {
              "it-pipe-e", "it-pipe-s", "it-pipe-es", "it-pipe-sw",
              "it-pipe-h", "it-pipe-w", "it-pipe-n", "it-pipe-ne",
              "it-pipe-wn", "it-pipe-v"})

-----------------
-- Shogun dots --
-----------------

NewAnim("it-shogun1", {img="it-shogun-small", h=3, speed=160, pingpong=1, loop=1})
NewAnim("it-shogun2", {img="it-shogun-med",   h=3, speed=160, pingpong=1, loop=1})
NewAnim("it-shogun3", {img="it-shogun-big",   h=3, speed=160, pingpong=1, loop=1})

-- Springboard --
do
    local r = Rect:new(0,0,32,32);
    display.DefineSubImage("it-springboard", "it-springboard", 0, 0, r)
    frames=buildframes(reverseframes(def_subimages("it-springboard", {h=2})),120)
    def_anim("it-springboard_anim", frames)
    r:delete();
end

def_alias("it-bridge-oxyd", "invisible")
def_alias("it-sensor", "invisible")
def_alias("it-inversesensor", "invisible")

------------------
-- STONE MODELS --
------------------
Progress(30)

-------------------
-- Stone shadows --
-------------------
def_image("sh-solid")
def_image("sh-round")
def_image("sh-round2")
def_image("sh-grate1")
def_image("sh-grate2")
def_image("sh-grate3")
def_image("sh-glass")
def_image("sh-white4")
def_image("sh-puzzle1")
def_image("sh-brake")

-- stone models
def_stone("st-glass", "sh-glass");

-- Scissors
do
    def_stone("st-scissors")
    local n=def_subimages("st-scissors-snip", {h=1})
    def_anim("st-scissors-snip-anim", buildframes(n, 130))
    def_solidstone("st-scissors-snip", "st-scissors-snip-anim")
end

def_stone("st-rubberband")


do
    local tiles = {
        "st-disco-light",
        "st-disco-medium",
        "st-disco-dark"
    }
    map_tiles({h=3},
              function (i, rect)
                  local model = %tiles[i]
                  display.DefineSubImage(model, "st-disco", 0,0, rect)
              end)
end

-- other

do
    def_image("stones")
    local stonetiles={
        "st-black1#",
        "st-black2#",
        "st-black3#",
        "st-black4#",
        "st-block#",
        "st-idontknowwhattonameit2",
        "st-beads#"
    }
    def_tiles("stones", stonetiles)
end

def_alias("st-explosion", "expl")

def_stone2("st-black1")
def_stone2("st-black2")
def_stone2("st-black3")
def_stone2("st-black4", "sh-white4")
def_stone2("st-block")
def_stone2("st-beads", "sh-glass")


def_stone("st-glass1", "sh-glass")
def_stone("st-glass2", "sh-glass")
def_stone("st-glass3", "sh-glass")
def_stone("st-rock1", "sh-round")
def_stone("st-rock2")
def_stone("st-rock3")
def_stone("st-rock4")
def_stone("st-rock5")
def_stone("st-rock6")
def_stone("st-rock7")
def_stone("st-rock8", "sh-round")
def_stone("st-brownie", "sh-round")
def_stone("st-stone1")
def_stone("st-stone2")

def_alias("st-rock1_hole", "st-rock1")
def_alias("st-rock1_move", "st-rock1")

def_alias("st-rock2_hole", "st-rock2")

def_alias("st-rock3_hole", "st-rock3")
def_alias("st-rock3_move", "st-rock3")
def_alias("st-rock3_break", "st-rock3")

def_stone("st-marble", "sh-round")
def_alias("st-marble_hole", "st-marble")
def_alias("st-marble_move", "st-marble")

def_alias("st-glass_move", "st-glass");

def_alias("st-glass1_hole", "st-glass1")
def_alias("st-glass2_hole", "st-glass2")

def_stone("st-metal")
def_stone("st-blue-sand")

do
   local sh=def_subimages("sh-round2-growing", {h=3,imgw=41,imgh=41})

   -- Wooden stone --
   do
      def_subimages("st-wood", {modelname="st-wood-fg",h=2})
      def_shmodel("st-wood1", "st-wood-fg1", "sh-round")
      def_shmodel("st-wood2", "st-wood-fg2", "sh-round")

      local n=def_subimages("st-wood-growing", {h=3})
      def_anim("wood-growing-fg", buildframes(n, 130))
      def_anim("wood-growing-bg", buildframes(sh, 130))
      def_shmodel("st-wood-growing", "wood-growing-fg", "wood-growing-bg")
      def_shmodel("st-greenbrown-growing", "wood-growing-fg", "wood-growing-bg")
   end

   -- Blocker stone
   do
      local n=def_subimages("st-blocker", {h=4})
      def_roundstone("st-blocker", n[1])
      frames={}
      for i=4,2,-1 do
         tinsert(frames, "st-blocker"..i)
      end
      def_anim("blocker-growing-fg", buildframes(frames, 60))
      def_anim("blocker-growing-bg", buildframes(sh, 60))
      def_anim("blocker-shrinking-fg", reverseframes(buildframes(frames, 60)))
      def_anim("blocker-shrinking-bg", reverseframes(buildframes(sh, 60)))
      def_shmodel("st-blocker-shrinking", "blocker-shrinking-fg", "blocker-shrinking-bg");
      def_shmodel("st-blocker-growing", "blocker-growing-fg", "blocker-growing-bg");
   end
end

def_alias("st-volcano-growing", "st-blocker-growing")

-- Rotator stones
do
    local n=def_subimages("st-rotator-left", {h=8})
    def_anim("st-rotator-left-anim", buildframes(n, 70), FALSE)
    def_roundstone("st-rotator-left", "st-rotator-left-anim")
    n=def_subimages("st-rotator-right", {h=8})
    def_anim("st-rotator-right-anim", buildframes(n, 70), FALSE)
    def_roundstone("st-rotator-right", "st-rotator-right-anim")
end

def_stone("st-grate1", "sh-grate1")
def_stone("st-grate2", "sh-grate2")
def_stone("st-grate3", "sh-grate3")

def_stone("st-brake", "sh-brake")
def_image("it-brake", {filename="st-brake"})

def_stone("st-greenbrown", "sh-round")
def_alias("st-greenbrown_hole", "st-greenbrown")
def_alias("st-greenbrown_move", "st-greenbrown")

Progress(40)


--def_stone("st-block")
def_stone("st-brick")
def_stone("st-woven")
def_stone("st-brick_magic", nil, {filename="st-brick"})
def_subimages("st-switch", {h=2, modelname="st-switchfg"})
def_roundstone("st-switch1", "st-switchfg1")
def_roundstone("st-switch2", "st-switchfg2")
def_stone("st-switch_black2", nil, {filename="st-switch_black2"})
def_stone("st-switch_black1", nil, {filename="st-switch_black1"})
def_stone("st-switch_white2", nil, {filename="st-switch_white2"})
def_stone("st-switch_white1", nil, {filename="st-switch_white1"})
def_stone("st-fourswitch", nil, {filename="st-fourswitch_n"})
def_stone("st-fourswitch_e")
def_stone("st-fourswitch_s")
def_stone("st-fourswitch_w")
def_stone("st-floppy0", "sh-round", {filename="st-floppy1"})
def_stone("st-floppy1", "sh-round", {filename="st-floppy2"})

def_image("st-easymode")


def_stone("st-laserswitch0", nil, {filename="st-oxydb"})
def_anim_images("laserswitch-blink",
                repeatanim(pingpong
                           (buildframes(framenames("st-fakeoxyd-blink", 1,4),
                            50))), {loop=1})
def_solidstone("st-laserswitch1", "laserswitch-blink")

def_stone("st-wood_001")
def_stone("st-key0", "sh-round", {filename="st-key1"})
def_stone("st-key1", "sh-round", {filename="st-key2"})
def_stone("st-white1")
def_stone("st-white2")
def_stone("st-white3")
def_stone("st-white4", "sh-white4")
def_stone("st-yinyang1")
def_stone("st-yinyang2")
def_stone("st-bluegray", "sh-round")
def_stone("st-bluegray_hole", "sh-round", {filename="st-bluegray"})
def_stone("st-plain")
def_stone("st-yellow")
def_stone("st-dummy")

--------------------------
-- pull and swap stones --
--------------------------

--def_stone("st-swap", "sh-round")

do
   def_subimages("st-pull",{modelname="st-pull-fg",h=5})
   def_subimages("st-swap",{modelname="st-swap-fg",h=5})
   def_subimages("sh-pull",{h=4,imgw=41,imgh=41})

   def_shmodel("st-pull",   "st-pull-fg1", "sh-glass")
   def_shmodel("st-pull-n", "st-pull-fg2", "sh-pull1")
   def_shmodel("st-pull-s", "st-pull-fg3", "sh-pull2")
   def_shmodel("st-pull-e", "st-pull-fg4", "sh-pull3")
   def_shmodel("st-pull-w", "st-pull-fg5", "sh-pull4")

   def_shmodel("st-swap",   "st-swap-fg1", "sh-round")
   def_shmodel("st-swap-n", "st-swap-fg2", "sh-pull1")
   def_shmodel("st-swap-s", "st-swap-fg3", "sh-pull2")
   def_shmodel("st-swap-e", "st-swap-fg4", "sh-pull3")
   def_shmodel("st-swap-w", "st-swap-fg5", "sh-pull4")
end

-----------------
-- Oxyd Stones --
-----------------

-- Oxyd stones occur in different colors and different flavors and
-- for each combination of these two attributes we need animations
-- for the following internal states or state transitions:
--
--   (a) opening and closing
--   (b) blinking
--   (c) opened
--
-- Creating the required image files by hand would be tedious, so
-- we use a couple of specialized functions and overlays to create
-- them automatically.

do


    local colorspots = framenames("st-oxydbtempl", 2,9)
    local openovls = framenames("st-oxydbtempl", 10,14)

-- Define "fading in" and "fading out" animations for oxyd stones.
-- These two animations are combined with the stone images to
-- produce the opening and closing animations for oxyd stones.

    local baseimg = {
        a="st-oxyda-open",
        b="st-oxydb-open",
        c="st-oxydc-open",
        d="st-oxydd-open"
    }
    local shadow = {
       a="sh-round",
       b="sh-round",
       c="sh-solid",
       d="sh-solid",
    }
    local fopening = {
        a = buildframes(def_subimages("st-oxyda-opening", {h=9}), 60),
        b = buildframes(def_subimages("st-oxydb-opening", {h=14}), 40),
        c = buildframes(def_subimages("st-oxydc-opening", {h=5}), 70),
        d = buildframes(def_subimages("st-oxydd-opening", {h=5}), 70),
    }
    local fclosing = {
        a = reverseframes(fopening["a"]),
        b = reverseframes(fopening["b"]),
        c = reverseframes(fopening["c"]),
        d = reverseframes(fopening["d"]),
    }

    function mkopenclose(flavor, color)
        local n = "st-oxyd" .. flavor .. color
        local fadein = "oxyd"..flavor.."-fadein"
        local fadeout= "oxyd"..flavor.."-fadeout"

        def_overlay(n.."-base", {%baseimg[flavor], %colorspots[color+1]})
        display.DefineComposite(n.."-opening-fg", n.."-base", fadein)
        display.DefineComposite(n.."-closing-fg", n.."-base", fadeout)
        def_shmodel (n.."-opening", n.."-opening-fg", %shadow[flavor])
        def_shmodel (n.."-closing", n.."-closing-fg", %shadow[flavor])
    end

    function mkblink(flavor, color)
        local n = "st-oxyd"..flavor..color.."-blink"
        local img={%baseimg[flavor],%colorspots[color+1], "st-oxyd-questmark"}
        def_overlay(n..1, img)
        def_overlay(n..2, {%baseimg[flavor], %colorspots[color+1]})
        def_anim(n.."-anim", buildframes({n..1,n..2}, 500), 1)
        def_shmodel(n, n.."-anim", %shadow[flavor])
    end

    function mkopened(flavor, color)
        local n = "st-oxyd" .. flavor .. color .. "-open"
        local names = {}

        for i=1,getn(%openovls) do
            local images={%baseimg[flavor],%colorspots[color+1],%openovls[i]}
            names[i] = n .. format("_%04d", i)
            def_overlay(names[i], images)
        end

        -- compose these images into an animation
        frames = pingpong(buildframes(names, 100))
        def_anim(n.."-anim", frames, 1)

        -- and finally add a shadow to make the model complete
        def_shmodel(n, n.."-anim", %shadow[flavor])
    end

    function mkoxyd(flavor)
        def_stone("st-oxyd"..flavor, %shadow[flavor])
        def_shmodel("st-likeoxyd"..flavor, "st-oxyd"..flavor, %shadow[flavor])
--        def_solidstone("st-likeoxyd"..flavor, "st-oxyd"..flavor)
        img=def_image("st-oxyd"..flavor.."-open")
        def_shmodel("st-likeoxyd"..flavor.."-open", img, %shadow[flavor])

        local fadein = "oxyd"..flavor.."-fadein"
        local fadeout= "oxyd"..flavor.."-fadeout"
        def_anim(fadein, %fopening[flavor])
        def_anim(fadeout, %fclosing[flavor])

        for color=0,7 do
            mkopenclose(flavor, color)
            mkblink(flavor, color)
            mkopened(flavor, color)
        end
    end
    mkoxyd("a")
    mkoxyd("b")
    Progress(50)
    mkoxyd("d")
    mkoxyd("c")
end

Progress(60)

-----------------
-- Laser stone --
-----------------
function make_laser(dir)
    laseron=framenames("st-laser"..dir, 1, 9)

    -- deactivated laser
    def_overlay("laser"..dir, {"st-laser-base", laseron[1]})
    def_roundstone("st-laser"..dir, "laser"..dir)

    -- activated laser
    names = {}
    for i=1,getn(laseron) do
	names[i] = "st-laseron"..dir .. format("_%04d", i)
	def_overlay (names[i], {"st-laser-base", laseron[i]})
    end
    frames = buildframes(names, 100)
    def_anim("st-laseron-anim"..dir, frames, 1)
    def_roundstone("st-laseron"..dir, "st-laseron-anim"..dir)
end

make_laser("-e")
make_laser("-s")
make_laser("-w")
make_laser("-n")

---------------------
-- Fake oxyd stone --
---------------------
def_stone("st-fakeoxyd", "sh-round", {filename="st-oxydb"})
def_anim_images("fakeoxyd-blink",
                repeatanim(pingpong
                           (buildframes(framenames("st-fakeoxyd-blink", 1,4),
                                        50))))
def_roundstone("st-fakeoxyd-blink", "fakeoxyd-blink")

-- Fart stone
def_stone("st-fart", "sh-round", {filename="st-oxydb"})
def_anim_images("farting",
                repeatanim(pingpong
                           (buildframes(framenames("st-fakeoxyd-blink", 1,4),
                                        50))))
def_roundstone("st-farting", "farting")

namelist = def_subimages("st-fart-break",{h=6})
def_anim("fartbreak-anim", buildframes(namelist,50))
def_roundstone("st-fartbreak-anim", "fartbreak-anim")

-- st-rock3_movebreak

namelist = def_subimages("st-rock3-break", {h=6})
def_anim("rock3_break-anim",buildframes(namelist,50))
def_solidstone("st-rock3_break-anim", "rock3_break-anim")
def_alias("st-rock3_movebreak", "st-rock3")

-- Actor impulse stone
do
   namelist = def_subimages("st-actorimpulse", {h=3})
   shnamelist = def_subimages("sh-actorimpulse", {h=3,imgw=41,imgh=41})

   def_anim("st-ai-fg", pingpong(buildframes(namelist, 30)))
   def_anim("st-ai-sh", pingpong(buildframes(shnamelist, 30)))
   def_shmodel("st-actorimpulse-anim", "st-ai-fg", "st-ai-sh")

   def_shmodel("st-actorimpulse", namelist[1], shnamelist[1])
end

-- Stone impulse stone
--
-- Note: It's important that the duration of the closing animation
-- (anim2) is longer than the opening animation (anim1). Otherwise
-- impulse stones do not work properly!

do
   namelist = def_subimages("st-stoneimpulse", {h=4})
   def_roundstone("st-stoneimpulse", namelist[1])
   frames={}
   for i=1,4 do tinsert(frames, namelist[i]) end
   def_anim("stoneimpulse-anim1", buildframes(frames, 55))
   def_roundstone("st-stoneimpulse-anim1", "stoneimpulse-anim1")
   tinsert(frames, namelist[4]) -- add 1 frame to make closing anim longer!
   def_anim("stoneimpulse-anim2", reverseframes(buildframes(frames, 55)))
   def_roundstone("st-stoneimpulse-anim2", "stoneimpulse-anim2")
end

do
   namelist = def_subimages("st-stoneimpulse-hollow", {h=4})
   def_shmodel("st-stoneimpulse-hollow", namelist[1], "sh-glass")
   frames={}
   for i=1,4 do tinsert(frames, namelist[i]) end
   def_anim("stoneimpulse-hollow-anim1", buildframes(frames, 55))
   def_shmodel("st-stoneimpulse-hollow-anim1", "stoneimpulse-hollow-anim1", "sh-glass")
   tinsert(frames, namelist[4]) -- add 1 frame to make closing anim longer!
   def_anim("stoneimpulse-hollow-anim2", reverseframes(buildframes(frames, 55)))
   def_shmodel("st-stoneimpulse-hollow-anim2", "stoneimpulse-hollow-anim2", "sh-glass")
end

-----------------
-- Thief stone --
-----------------
do
    local img = def_subimages("st-thief", {h=7})
    local f = buildframes(img, 80)
    def_anim("thief-emerge", f)
    def_anim("thief-retreat", reverseframes(f))
    def_roundstone("st-thief", img[1])
    def_roundstone("st-thief-emerge", "thief-emerge")
    def_roundstone("st-thief-retreat", "thief-retreat")
end

-----------------
-- Timer stone --
-----------------
do
    local img = def_subimages("st-timer", {h=4})
    def_anim("timer-anim", buildframes(img, 120), 1)
    def_roundstone("st-timer", "timer-anim")
    def_roundstone("st-timeroff", "st-timer1")
end

-----------
-- Bombs --
-----------

do
    local n=def_subimages("st-bombs", {h=7})
    def_roundstone("st-bombs", "st-bombs1")
    def_anim("st-bombs-anim", buildframes(n,50))
end

----------------
-- Mail stone --
----------------
do
    local n=def_subimages("st-mail", {h=4})
    def_solidstone("st-mail-n", "st-mail1")
    def_solidstone("st-mail-e", "st-mail2")
    def_solidstone("st-mail-s", "st-mail4")
    def_solidstone("st-mail-w", "st-mail3")
end

function def_solidstone_with_anim(name, npictures, frametime)
    local n=def_subimages(name, {h=npictures})
    def_anim(name.."-animfg", buildframes(n,frametime))
    def_solidstone(name.."-anim", name.."-animfg")
    def_solidstone(name, n[1])
end
function def_roundstone_with_anim(name, npictures, frametime)
    local n=def_subimages(name, {h=npictures})
    def_anim(name.."-animfg", buildframes(n,frametime))
    def_roundstone(name.."-anim", name.."-animfg")
    def_roundstone(name, n[1])
 end

def_solidstone_with_anim ("st-window", 4, 80)
def_solidstone_with_anim ("st-stone_break", 10, 50)
def_solidstone_with_anim ("st-break_bolder", 10, 50)
def_roundstone_with_anim ("st-break_acwhite", 10, 50)
def_roundstone_with_anim ("st-break_acblack", 10, 50)
def_roundstone_with_anim ("st-death", 3, 140)

do
    function def_chargestone(basename)
        local n=def_subimages(basename, {h=2})
        def_solidstone(basename, n[1])
        def_anim(basename.."-animfg", {{n[2], 140}})
        def_solidstone(basename.."-anim", basename.."-animfg")
    end
    def_chargestone("st-chargeplus")
    def_chargestone("st-chargeminus")
    def_chargestone("st-chargezero")
end

---------------
-- Turnstile --
---------------
do
   local img = def_subimages("st-turnstile", {h=2})
   def_anim("turnstile-anim", reverseframes(buildframes(img, 30)))
   def_solidstone("st-turnstile", img[1])
   def_solidstone("st-turnstile-anim", "turnstile-anim")
end

do
   local img = def_subimages("st-turnstile-green", {h=2})
   def_anim("turnstile-green-anim", reverseframes(buildframes(img, 30)))
   def_solidstone("st-turnstile-green", img[1])
   def_solidstone("st-turnstile-green-anim", "turnstile-green-anim")
end

----------------
-- Timeswitch --
----------------
do
    def_stone("st-timeswitch")
    local img = def_subimages("st-time1switch", {h=10})
    def_anim("st-time1switch-anim", buildframes (img, 180))
    def_solidstone("st-time1switch", "st-time1switch-anim")
end

Progress(70)

-------------
-- Mirrors --
-------------

-- naming scheme for mirror models:
--
--	st-{3mirror,pmirror}-{m,s}{o,t}[1234]
--
-- {m,s} -> movable or static
-- {o,t} -> opaque or transparent
--
-- The numbers map to actual orientations as follows:
--
--   NUMBER    TRIANG.M.   PLANE M.
--	1	south	  "v"        "-"
--	2	west	  "<"        "\"
--	3	north	  "^"        "|"
--	4	east	  ">"        "/"

function make_mirror(basename, baseimg, overlays)
    for i=1,4 do
	mname = basename .. i
	def_overlay (mname .. "-ovl", {baseimg, overlays[i]})
	def_shmodel(mname, mname .. "-ovl", "sh-round2")
    end
end

mirror3_opaque = framenames("st-mirrortempl", 1, 4)
mirror3_transp = framenames("st-mirrortempl", 5, 8)
mirrorp_opaque = framenames("st-mirrortempl", 9, 12)
mirrorp_transp = framenames("st-mirrortempl", 13, 16)

make_mirror("st-3mirror-mo", "st-mirror-movable", mirror3_opaque)
make_mirror("st-3mirror-so", "st-mirror-static",  mirror3_opaque)
make_mirror("st-3mirror-mt", "st-mirror-movable", mirror3_transp)
make_mirror("st-3mirror-st", "st-mirror-static",  mirror3_transp)

make_mirror("st-pmirror-mo", "st-mirror-movable", mirrorp_opaque)
make_mirror("st-pmirror-so", "st-mirror-static",  mirrorp_opaque)
make_mirror("st-pmirror-mt", "st-mirror-movable", mirrorp_transp)
make_mirror("st-pmirror-st", "st-mirror-static",  mirrorp_transp)

-- OneWay --
do
   local model_names = {  "st-oneway-e", "st-oneway-n", "st-oneway-s", "st-oneway-w",
                      "st-oneway_black-e", "st-oneway_black-n", "st-oneway_black-s", "st-oneway_black-w",
                      "st-oneway_white-e", "st-oneway_white-n", "st-oneway_white-s", "st-oneway_white-w"
                      }
   def_subimages("st-oneway", {modelname="st-onewayx",w=3,h=4})
   for i=1,12 do def_roundstone(model_names[i], "st-onewayx"..i) end
end

---------------
-- Coin slot --
---------------
do
    def_stone("st-coinslot")
    local img=def_subimages("st-coin2slot", {h=18})
    def_anim("st-coin2slot-anim", buildframes(img, 20))
    def_solidstone("st-coin2slot", "st-coin2slot-anim")
    def_solidstone("st-coinslot-active", "st-coin2slot18")
end


Progress(80)

-------------------
-- Puzzle stones --
-------------------
do
    def_subimages("st-puzzle", {modelname="st-puzzlex",w=8,h=4})
    for i=2,16  do def_solidstone("st-puzzle"..i, "st-puzzlex"..i) end
    for i=18,32 do def_solidstone("st-puzzle"..i, "st-puzzlex"..i) end
    def_shmodel("st-puzzle1", "st-puzzlex1", "sh-puzzle1")
    def_shmodel("st-puzzle17", "st-puzzlex17", "sh-puzzle1")
end

def_alias("st-turnstile-e", "st-puzzle2")
def_alias("st-turnstile-w", "st-puzzle5")
def_alias("st-turnstile-s", "st-puzzle9")
def_alias("st-turnstile-n", "st-puzzle3")
--def_stone("st-turnstile")

---------------
-- Big brick --
---------------

do
   def_subimages("st-bigbrick", {modelname="st-bigbrickx",w=4,h=4})
   for i=1,16 do def_solidstone("st-bigbrick"..i, "st-bigbrickx"..i) end
end

--def_alias("st-bigbrick", "st-bigbrick1");
--def_alias("st-bigbrick-n", "st-bigbrick9");
--def_alias("st-bigbrick-e", "st-bigbrick5");
--def_alias("st-bigbrick-s", "st-bigbrick3");
--def_alias("st-bigbrick-w", "st-bigbrick2");
--def_alias("st-bigbrick-ne", "st-bigbrick13");
--def_alias("st-bigbrick-nw", "st-bigbrick10");
--def_alias("st-bigbrick-es", "st-bigbrick7");
--def_alias("st-bigbrick-sw", "st-bigbrick4");
--def_alias("st-bigbrick-ns", "st-bigbrick11");
--def_alias("st-bigbrick-ew", "st-bigbrick6");
--def_alias("st-bigbrick-nes", "st-bigbrick15");
--def_alias("st-bigbrick-new", "st-bigbrick14");
--def_alias("st-bigbrick-nsw", "st-bigbrick12");
--def_alias("st-bigbrick-esw", "st-bigbrick8");
--def_alias("st-bigbrick-nesw", "st-bigbrick16");

----------
-- Door --
----------
do
    local f,img,sh

    img=def_subimages("st-doorh", {h=7})
    sh=def_subimages("sh-doorh", {h=7,imgw=41,imgh=41})
    def_shmodel("st-doorh-open", img[1], sh[1])
    def_shmodel("st-doorh-closed", img[7], sh[7])
    def_anim("doorh-opening-fg", reverseframes(buildframes(img, 60)))
    def_anim("doorh-opening-bg", reverseframes(buildframes(sh, 60)))
    def_shmodel("st-doorh-opening", "doorh-opening-fg", "doorh-opening-bg")
    def_anim("doorh-closing-fg", buildframes(img, 60))
    def_anim("doorh-closing-bg", buildframes(sh, 60))
    def_shmodel("st-doorh-closing", "doorh-closing-fg", "doorh-closing-bg")


    img=def_subimages("st-doorv", {w=7})
    sh=def_subimages("sh-doorv", {w=7,imgw=41,imgh=41})
    def_shmodel("st-doorv-open", img[1], sh[1])
    def_shmodel("st-doorv-closed", img[7], sh[7])
    def_anim("doorv-opening-fg", reverseframes(buildframes(img, 60)))
    def_anim("doorv-opening-bg", reverseframes(buildframes(sh, 60)))
    def_shmodel("st-doorv-opening", "doorv-opening-fg", "doorv-opening-bg")
    def_anim("doorv-closing-fg", buildframes(img, 60))
    def_anim("doorv-closing-bg", buildframes(sh, 60))
    def_shmodel("st-doorv-closing", "doorv-closing-fg", "doorv-closing-bg")
end

-- Door_a --
do
    def_alias("st-door_a-open", "st-grate1")
    def_alias("st-door_a-closed", "st-oxyda")
    local f = buildframes({"st-door_a-closed", "st-door_a-open"},60)
    def_anim("st-door_a-opening", f)
    def_anim("st-door_a-closing", reverseframes(f))
end

-- Door_b --
do
    def_alias("st-door_b-open", "invisible")
    def_alias("st-door_b-closed", "st-plain")
    local img=def_subimages("st-doorb", {modelname="doorb", h=8})
    local f = buildframes(img,60)
    def_anim("st-door_b-opening", f)
    def_anim("st-door_b-closing", reverseframes(f))
end

-- Door_c --
do
    def_alias("st-door_c-open", "st-grate2")
    def_alias("st-door_c-closed", "st-plain")
    frames=buildframes({"st-door_c-closed","st-door_c-open"},60)
    def_anim("st-door_c-opening", frames)
    def_anim("st-door_c-closing", reverseframes(frames))
end

------------------
-- Knight stone --
------------------
do
    local n = def_subimages("st-knight", {modelname="knight", h=5})
    for i=1,getn(n) do
        def_solidstone("st-knight"..i, n[i])
    end
end



-------------------
-- Shogun stones --
-------------------
do
    def_images{"sh-shogun1","sh-shogun2", "sh-shogun4"}
    def_subimages("st-shogun", {modelname="st-shogun-fg",h=7})

    def_shmodel("st-shogun1", "st-shogun-fg1", "sh-shogun1")
    def_shmodel("st-shogun2", "st-shogun-fg2", "sh-shogun2")
    def_shmodel("st-shogun3", "st-shogun-fg3", "sh-shogun1")
    def_shmodel("st-shogun4", "st-shogun-fg4", "sh-shogun4")
    def_shmodel("st-shogun5", "st-shogun-fg5", "sh-shogun1")
    def_shmodel("st-shogun6", "st-shogun-fg6", "sh-shogun2")
    def_shmodel("st-shogun7", "st-shogun-fg7", "sh-shogun1")
end

Progress(90)

-------------------
-- Bolder stones --
-------------------

do
    local img=def_subimages("st-bolder", {w=4,h=3})
    local imgfall=def_subimages("st-bolder-fall", {w=4,h=3})

    function def_bolder(orient, start)
       local animname="st-bolder"..orient.."a"
       local frames={%img[start], %img[start+1], %img[start+2]}
       def_anim(animname, buildframes(frames, 120),1)
       def_shmodel("st-bolder-"..orient, animname, "sh-round")

       animname="st-bolder-"..orient.."-fall-anim"
       frames={%imgfall[start],%imgfall[start+1],%imgfall[start+2]}
       def_anim(animname, buildframes(frames, 120), 0)
    end

    def_bolder("n",1)
    def_bolder("e",4)
    def_bolder("s",7)
    def_bolder("w",10)
end

-- Invisible stone --
def_alias("st-invisible", "invisible")
def_alias("st-invisible_magic", "invisible")
def_alias("st-stonebrush", "invisible")
def_alias("st-break_invisible", "invisible")
def_alias("st-actorimpulse_invisible", "invisible")
def_alias("st-death_invisible", "invisible")

----------------------
-- Magic stones :-) --
----------------------
do
    local img = def_subimages("st-magic", {h=4, modelname="st-magic-fg"})
    local nlist = {}
    for i=1,getn(img) do
        nlist[i] = "st-magic"..i
        def_roundstone(nlist[i], img[i])
    end
    display.DefineRandModel("st-magic", getn(nlist), nlist)
end


-------------
-- Effects --
-------------
Progress(100)

do
    local img=def_subimages("ring-anim", {h=8,xoff=-8,yoff=-8, imgw=16, imgh=16})
    def_anim("ring-anim", buildframes(img, 50))
end

-- Halo --
do
    local n=def_subimages("halo", {h=2, xoff=-11, yoff=-11, imgw=23, imgh=23})
    def_anim("halo", buildframes(n, 30), TRUE)

    n=def_subimages("halo-blink", {h=2, xoff=-11, yoff=-11, imgw=23, imgh=23})
    def_anim("halo-blink", buildframes(n, 30), TRUE)
end
