// menu.c

// Egoboo, Copyright (C) 2000 Aaron Bishop

#include "egoboo.h"

//--------------------------------------------------------------------------------------------
void menu_service_select()
{
    // ZZ> This function lets the user choose a network service to use
    char text[256];
    int x, y;
    float open;
    int cnt;
    int stillchoosing;


    networkservice = NONETWORK;
    if(numservice > 0)
    {
        // Open a big window
        open = 0;
        while(open < 1.0)
        {
            //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
            draw_trim_box_opening(0, 0, scrx, scry, open);
            draw_trim_box_opening(0, 0, 320, fontyspacing*(numservice+4), open);
            flip_pages();
            open += .030;
        }
        // Tell the user which ones we found ( in setup_network )
        stillchoosing = TRUE;
        while(stillchoosing)
        {
            //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
            draw_trim_box(0, 0, scrx, scry);
            draw_trim_box(0, 0, 320, fontyspacing*(numservice+4));
            y = 8;
            sprintf(text, "Network options...");
            draw_string(text, 14, y);
            y += fontyspacing;
            cnt = 0;
            while(cnt < numservice)
            {
                sprintf(text, "%s", netservicename[cnt]);
                draw_string(text, 50, y);
                y += fontyspacing;
                cnt++;
            }
            sprintf(text, "No Network");
            draw_string(text, 50, y);
            do_cursor();
            x = cursorx - 50;
            y = (cursory - 8 - fontyspacing);
            if(x > 0 && x < 300 && y >= 0)
            {
                y = y/fontyspacing;
                if(y <= numservice)
                {
                    if(mousebutton[0] || mousebutton[1])
                    {
                        stillchoosing = FALSE;
                        networkservice = y;
                    }
                }
            }
            flip_pages();
        }
    }
    turn_on_service(networkservice);
}

//--------------------------------------------------------------------------------------------
void menu_start_or_join()
{
    // ZZ> This function lets the user start or join a game for a network game
    char text[256];
    int x, y;
    float open;
    int stillchoosing;


    // Open another window
    if(networkon)
    {
        open = 0;
        while(open < 1.0)
        {
            //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
            draw_trim_box_opening(0, 0, scrx, scry, open);
            draw_trim_box_opening(0, 0, 280, 102, open);
            flip_pages();
            open += .030;
        }
        // Give the user some options
        stillchoosing = TRUE;
        while(stillchoosing)
        {
            //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
            draw_trim_box(0, 0, scrx, scry);
            draw_trim_box(0, 0, 280, 102);
            y = 8;
            sprintf(text, "Game options...");
            draw_string(text, 14, y);
            y += fontyspacing;
            sprintf(text, "New Game");
            draw_string(text, 50, y);
            y += fontyspacing;
            sprintf(text, "Join Game");
            draw_string(text, 50, y);
            y += fontyspacing;
            sprintf(text, "Quit Game");
            draw_string(text, 50, y);
            do_cursor();
            x = cursorx - 50;
            y = (cursory - 8 - fontyspacing);
            if(x > 0 && x < 280 && y >= 0)
            {
                y = y/fontyspacing;
                if(y < 3)
                {
                    if(mousebutton[0] || mousebutton[1])
                    {
                        if(y == 0)
                        {
                            if(host_session())
                            {
                                hostactive = TRUE;
                                nextmenu = MENUD;
                                stillchoosing = FALSE;
                            }
                        }
                        if(y == 1 && networkservice != NONETWORK)
                        {
                            nextmenu = MENUC;
                            stillchoosing = FALSE;
                        }
                        if(y == 2)
                        {
                            nextmenu = MENUB;
                            menuactive = FALSE;
                            stillchoosing = FALSE;
                            gameactive = FALSE;
                        }
                    }
                }
            }
            flip_pages();
        }
    }
    else
    {
        hostactive = TRUE;
        nextmenu = MENUD;
    }
}

//--------------------------------------------------------------------------------------------
void draw_module_tag(int module, int y)
{
    // ZZ> This function draws a module tag
    char text[256];
    draw_trim_box(0, y, 136, y+136);
    draw_trim_box(132, y, scrx, y+136);
    if(module < globalnummodule)
    {
        draw_titleimage(module, 4, y+4);
        y+=6;
        sprintf(text, "%s", modlongname[module]);  draw_string(text, 150, y);  y+=fontyspacing;
        sprintf(text, "%s", modrank[module]);  draw_string(text, 150, y);  y+=fontyspacing;
        if(modmaxplayers[module] > 1)
        {
            if(modminplayers[module]==modmaxplayers[module])
            {
                sprintf(text, "%d players", modminplayers[module]);
            }
            else
            {
                sprintf(text, "%d-%d players", modminplayers[module], modmaxplayers[module]);
            }
        }
        else
        {
            sprintf(text, "1 player");
        }
        draw_string(text, 150, y);  y+=fontyspacing;
        if(modimportamount[module] == 0 && modallowexport[module]==FALSE)
        {
            sprintf(text, "No Import/Export");  draw_string(text, 150, y);  y+=fontyspacing;
        }
        else
        {
            if(modimportamount[module] == 0)
            {
                sprintf(text, "No Import");  draw_string(text, 150, y);  y+=fontyspacing;
            }
            if(modallowexport[module]==FALSE)
            {
                sprintf(text, "No Export");  draw_string(text, 150, y);  y+=fontyspacing;
            }
        }
        if(modrespawnvalid[module] == FALSE)
        {
            sprintf(text, "No Respawn");  draw_string(text, 150, y);  y+=fontyspacing;
        }
        if(modrtscontrol[module] == TRUE)
        {
            sprintf(text, "RTS");  draw_string(text, 150, y);  y+=fontyspacing;
        }
        if(modrtscontrol[module] == ALLSELECT)
        {
            sprintf(text, "Diaboo RTS");  draw_string(text, 150, y);  y+=fontyspacing;
        }
    }
}

//--------------------------------------------------------------------------------------------
void menu_pick_player(int module)
{
    // ZZ> This function handles the display for picking players to import
    int x, y;
    float open;
    int cnt, tnc, start, numshow;
    int stillchoosing;
    int import;
    unsigned char control, sparkle;
    char fromdir[128];
    char todir[128];

    // Set the important flags
    respawnvalid = FALSE;
    respawnanytime = FALSE;
    if(modrespawnvalid[module])  respawnvalid = TRUE;
    if(modrespawnvalid[module]==ANYTIME)  respawnanytime = TRUE;
    rtscontrol = FALSE;
    if(modrtscontrol[module] != FALSE)
    {
        rtscontrol = TRUE;
        allselect = FALSE;
        if(modrtscontrol[module] == ALLSELECT)
            allselect = TRUE;
    }
    exportvalid = modallowexport[module];
    importvalid = (modimportamount[module] > 0);
    importamount = modimportamount[module];
    playeramount = modmaxplayers[module];
    make_directory("import");  // Just in case...


    start = 0;
    if(importvalid)
    {
        // Figure out which characters are available
        check_player_import("players");
        numshow = (scry-80-fontyspacing-fontyspacing)>>5;


        // Open some windows
        y = fontyspacing + 8;
        open = 0;
        while(open < 1.0)
        {
            //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
            draw_trim_box_opening(0, 0, scrx, scry, open);
            draw_trim_box_opening(0, 0, scrx, 40, open);
            draw_trim_box_opening(0, scry-40, scrx, scry, open);
            flip_pages();
            open += .030;
        }


        wldframe = 0;  // For sparkle
        stillchoosing = TRUE;
        while(stillchoosing)
        {
            // Draw the windows
            //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
            draw_trim_box(0, 0, scrx, scry);
            draw_trim_box(0, 40, scrx, scry-40);

            // Draw the Up/Down buttons
            if(start == 0)
            {
                // Show the instructions
                x = (scrx-270)>>1;
                draw_string("Setup controls", x, 10);
            }
            else
            {
                x = (scrx-40)>>1;
                draw_string("Up", x, 10);
            }
            x = (scrx-80)>>1;
            draw_string("Down", x, scry-fontyspacing-20);


            // Draw each import character
            y = 40+fontyspacing;
            cnt = 0;
            while(cnt < numshow && cnt + start < numloadplayer)
            {
                sparkle = NOSPARKLE;
                if(keybplayer == (cnt+start))
                {
                    draw_one_icon(keybicon, 32, y, NOSPARKLE);
                    sparkle = 0;  // White
                }
                else
                    draw_one_icon(nullicon, 32, y, NOSPARKLE);
                if(mousplayer == (cnt+start))
                {
                    draw_one_icon(mousicon, 64, y, NOSPARKLE);
                    sparkle = 0;  // White
                }
                else
                    draw_one_icon(nullicon, 64, y, NOSPARKLE);
                if(joyaplayer == (cnt+start) && joyaon)
                {
                    draw_one_icon(joyaicon, 128, y, NOSPARKLE);
                    sparkle = 0;  // White
                }
                else
                    draw_one_icon(nullicon, 128, y, NOSPARKLE);
                if(joybplayer == (cnt+start) && joybon)
                {
                    draw_one_icon(joybicon, 160, y, NOSPARKLE);
                    sparkle = 0;  // White
                }
                else
                    draw_one_icon(nullicon, 160, y, NOSPARKLE);
                draw_one_icon((cnt+start), 96, y, sparkle);
                draw_string(loadplayername[cnt+start], 200, y+6);
                y+=32;
                cnt++;
            }
            wldframe++;  // For sparkle


            // Handle other stuff...
            do_cursor();
            if(pending_click)
            {
	        pending_click=FALSE;
                if(cursory < 40 && start > 0)
                {
                    // Up button
                    start--;
                }
                if(cursory >= (scry-40) && (start + numshow) < numloadplayer)
                {
                    // Down button
                    start++;
                }
            }
            if(mousebutton[0])
            {
                x = (cursorx - 32) >> 5;
                y = (cursory - 44) >> 5;
                if(y >= 0 && y < numshow)
                {
                    y += start;
                    // Assign the controls
                    if(y < numloadplayer)  // !!!BAD!!! do scroll
                    {
                        if(x == 0)  keybplayer = y;
                        if(x == 1)  mousplayer = y;
                        if(x == 3)  joyaplayer = y;
                        if(x == 4)  joybplayer = y;
                    }
                }
            }
            if(mousebutton[1])
            {
                // Done picking
                stillchoosing = FALSE;
            }
            flip_pages();
        }
        wldframe = 0;  // For sparkle


        // Tell the user we're loading
        y = fontyspacing + 8;
        open = 0;
        while(open < 1.0)
        {
            //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
            draw_trim_box_opening(0, 0, scrx, scry, open);
            flip_pages();
            open += .030;
        }
        //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
        draw_trim_box(0, 0, scrx, scry);
        draw_string("Copying the imports...", y, y);
        flip_pages();


        // Now build the import directory...
        empty_import_directory();
        cnt = 0;
        numimport = 0;
        while(cnt < numloadplayer)
        {
            if((cnt == keybplayer && keyon)   ||
               (cnt == mousplayer && mouseon) ||
               (cnt == joyaplayer && joyaon)  ||
               (cnt == joybplayer && joybon))
            {
                // This character has been selected
                control = INPUTNONE;
                if(cnt == keybplayer)  control = control | INPUTKEY;
                if(cnt == mousplayer)  control = control | INPUTMOUSE;
                if(cnt == joyaplayer)  control = control | INPUTJOYA;
                if(cnt == joybplayer)  control = control | INPUTJOYB;
                localcontrol[numimport] = control;
                localslot[numimport] = (numimport+(localmachine*4))*9;


                // Copy the character to the import directory
                sprintf(fromdir, FILENAME("players/%s"), loadplayerdir[cnt]);
                sprintf(todir, FILENAME("import/temp%04d.obj"), localslot[numimport]);

		// change back to copy_directory_to_host once networking is
		// working!
                copy_directory(fromdir, todir);
//                copy_directory_to_host(fromdir, todir);


                // Copy all of the character's items to the import directory
                tnc = 0;
                while(tnc < 8)
                {
                    sprintf(fromdir, FILENAME("players/%s/%d.obj"), loadplayerdir[cnt], tnc);
                    sprintf(todir, FILENAME("import/temp%04d.obj"), localslot[numimport]+tnc+1);

		    // change back to copy_directory_to_host once networking is
		    // working!
                    copy_directory(fromdir, todir);
//                    copy_directory_to_host(fromdir, todir);
                    tnc++;
                }


                numimport++;
            }
            cnt++;
        }


        if(networkon)
        {
            if(hostactive)
            {
                // Host waits for all files from all remotes
                numfile = 0;
                numfileexpected = 0;
                numplayerrespond = 1;
                while(numfile < numfileexpected || numplayerrespond < numplayer)
                {
                    //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
                    draw_trim_box(0, 0, scrx, scry);
                    y = fontyspacing + 8;
                    draw_string("Incoming files...", fontyspacing+8, y);  y+=fontyspacing;
                    sprintf(todir, "File %d/%d", numfile, numfileexpected);
                    draw_string(todir, fontyspacing+20, y); y+=fontyspacing;
                    sprintf(todir, "Play %d/%d", numplayerrespond, numplayer);
                    draw_string(todir, fontyspacing+20, y);
                    flip_pages();
                    listen_for_packets();
do_cursor();  if(SDLKEYDOWN(SDLK_ESCAPE)) { numfile = 100000;  gameactive = FALSE;  menuactive = FALSE; }
                }


                // Say you're done
                //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
                draw_trim_box(0, 0, scrx, scry);
                y = fontyspacing + 8;
                draw_string("Sending files to remotes...", fontyspacing+8, y);  y+=fontyspacing;
                flip_pages();


                // Host sends import directory to all remotes, deletes extras
                numfilesent = 0;
                import = 0;
                cnt = 0;
                while(cnt < MAXIMPORT)
                {
                    sprintf(todir, "import\\temp%04d.obj", cnt);
                    sprintf(fromdir, "import\\temp%04d.obj", cnt);
                    if(DirGetAttrib(fromdir) != 0xFFFFFFFF)
                    {
                        // Only do directories that actually exist
                        if((cnt % 9)==0) import++;
                        if(import > importamount)
                        {
                            // Too many directories
                            delete_directory(fromdir);
                        }
                        else
                        {
                            // Ship it out
                            copy_directory_to_all_players(fromdir, todir);
                        }
                    }
                    cnt++;
                }


                // Host yells out numfilesent
                start_building_packet();
                add_packet_us(TO_REMOTE_FILESENT);
                add_packet_ui(numfilesent);
                send_packet_to_all_players();
            }
            else
            {
                // Remotes tell the host numfilesent
                start_building_packet();
                add_packet_us(TO_HOST_FILESENT);
                add_packet_ui(numfilesent);
                send_packet_to_host_guaranteed();


                // Remotes wait for all files in import directory
                numfile = 0;
                numfileexpected = 0;
                numplayerrespond = 0;
                while(numfile < numfileexpected || numplayerrespond < 1)
                {
                    //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
                    draw_trim_box(0, 0, scrx, scry);
                    y = fontyspacing + 8;
                    draw_string("Incoming files from host...", fontyspacing+8, y);  y+=fontyspacing;
                    sprintf(todir, "File %d", numfile);
                    draw_string(todir, fontyspacing+20, y);
                    flip_pages();
                    listen_for_packets();
do_cursor();  if(SDLKEYDOWN(SDLK_ESCAPE)) { numfile = 100000;  gameactive = FALSE;  menuactive = FALSE; }
                }
            }
        }
    }
    nextmenu = MENUG;
}

//--------------------------------------------------------------------------------------------
void menu_module_loading(int module)
{
    // ZZ> This function handles the display for when a module is loading
    char text[256];
    int y;
    float open;
    int cnt;


    // Open some windows
    y = fontyspacing + 8;
    open = 0;
    while(open < 1.0)
    {
        //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
        draw_trim_box_opening(0, y, 136, y+136, open);
        draw_trim_box_opening(132, y, scrx, y+136, open);
        draw_trim_box_opening(0, y+132, scrx, scry, open);
        flip_pages();
        open += .030;
    }


    // Put the stuff in the windows
    //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
    y = 0;
    sprintf(text, "Loading...  Wait!!!");  draw_string(text, 0, y);  y+=fontyspacing;
    y+=8;
    draw_module_tag(module, y);
    draw_trim_box(0, y+132, scrx, scry);


    // Show the summary
    sprintf(text, FILENAME("modules/%s/gamedat/menu.txt"), modloadname[module]);
    get_module_summary(text);
    y = fontyspacing+152;
    cnt = 0;
    while(cnt < SUMMARYLINES)
    {
        sprintf(text, "%s", modsummary[cnt]);  draw_string(text, 14, y);  y+=fontyspacing;
        cnt++;
    }
    flip_pages();
    nextmenu = MENUB;
    menuactive = FALSE;
}

//--------------------------------------------------------------------------------------------
void menu_choose_host()
{
    // ZZ> This function lets the player choose a host
    char text[256];
    int x, y;
    float open;
    int cnt;
    int stillchoosing;


    if(networkon)
    {
        // Bring up a helper window
        open = 0;
        while(open < 1.0)
        {
            //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
            draw_trim_box_opening(0, 0, scrx, scry, open);
            flip_pages();
            open += .030;
        }
        //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
        draw_trim_box(0, 0, scrx, scry);
        sprintf(text, "Press Enter if");
        draw_string(text, (scrx>>1)-120, (scry>>1)-fontyspacing);
        sprintf(text, "nothing happens");
        draw_string(text, (scrx>>1)-120, (scry>>1));
        flip_pages();



        // Find available games
        find_open_sessions();       // !!!BAD!!!  Do this every now and then

        // Open a big window
        open = 0;
        while(open < 1.0)
        {
            //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
            draw_trim_box_opening(0, 0, scrx, scry, open);
            draw_trim_box_opening(0, 0, 320, fontyspacing*(numsession+4), open);
            flip_pages();
            open += .030;
        }

        // Tell the user which ones we found
        stillchoosing = TRUE;
        while(stillchoosing)
        {
            //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
            draw_trim_box(0, 0, scrx, scry);
            draw_trim_box(0, 0, 320, fontyspacing*(numsession+4));
            y = 8;
            sprintf(text, "Open hosts...");
            draw_string(text, 14, y);
            y += fontyspacing;
            cnt = 0;
            while(cnt < numsession)
            {
                sprintf(text, "%s", netsessionname[cnt]);
                draw_string(text, 50, y);
                y += fontyspacing;
                cnt++;
            }
            sprintf(text, "Go Back...");
            draw_string(text, 50, y);
            do_cursor();
            x = cursorx - 50;
            y = (cursory - 8 - fontyspacing);
            if(x > 0 && x < 300 && y >= 0)
            {
                y = y/fontyspacing;
                if(y <= numsession)
                {
                    if(mousebutton[0] || mousebutton[1])
                    {
                        if(y == numsession)
                        {
                            nextmenu = MENUB;
                            stillchoosing = FALSE;
                        }
                        else
                        {
                            if(join_session(y))
                            {
                                nextmenu = MENUE;
                                stillchoosing = FALSE;
                            }
                        }
                    }
                }
            }
            flip_pages();
        }
    }
    else
    {
        // This should never happen
        nextmenu = MENUB;
    }
}

//--------------------------------------------------------------------------------------------
void menu_choose_module()
{
    // ZZ> This function lets the host choose a module
    int numtag;
    char text[256];
    int x, y, ystt;
    float open;
    int cnt;
    int module;
    int stillchoosing;
    if(hostactive)
    {
        // Figure out how many tags to display
        numtag = (scry-4-40)/132;
        ystt = (scry-(numtag*132)-4)>>1;


        // Open the tag windows
        open = 0;
        while(open < 1.0)
        {
            //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
            draw_trim_box_opening(0, 0, scrx, scry, open);
            y = ystt;
            cnt = 0;
            while(cnt < numtag)
            {
                draw_trim_box_opening(0, y, 136, y+136, open);
                draw_trim_box_opening(132, y, scrx, y+136, open);
                y+=132;
                cnt++;
            }
            flip_pages();
            open += .030;
        }




        // Let the user pick a module
        module = 0;
        stillchoosing = TRUE;
        while(stillchoosing)
        {
            // Draw the tags
            //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		    	glLoadIdentity();
            draw_trim_box(0, 0, scrx, scry);
            y = ystt;
            cnt = 0;
            while(cnt < numtag)
            {
                draw_module_tag(module+cnt, y);
                y+=132;
                cnt++;
            }

            // Draw the Up/Down buttons
            sprintf(text, "Up");
            x = (scrx-40)>>1;
            draw_string(text, x, 10);
            sprintf(text, "Down");
            x = (scrx-80)>>1;
            draw_string(text, x, scry-fontyspacing-20);


            // Handle the mouse
            do_cursor();
            y = (cursory - ystt)/132;
            if(pending_click)
	      {
	        pending_click=FALSE;
                if(cursory < ystt && module > 0)
		  {
                    // Up button
                    module--;
		  }
                if(y >= numtag && module + numtag < globalnummodule)
		  {
                    // Down button
                    module++;
		  }
		if(cursory > ystt && y > -1 && y < numtag)
		  {
		    y = module + y;
		    if((mousebutton[0] || mousebutton[1]) && y < globalnummodule)
		      {
			// Set start info
			playersready = 1;
			seed = time(0);
			pickedindex = y;
			sprintf(pickedmodule, "%s", modloadname[y]);
			readytostart = TRUE;
			stillchoosing = FALSE;
		      }
		  }
	      }
            // Check for quitters
            if(SDLKEYDOWN(SDLK_ESCAPE) && networkservice == NONETWORK)
            {
                nextmenu = MENUB;
                menuactive = FALSE;
                stillchoosing = FALSE;
                gameactive = FALSE;
            }
            flip_pages();
        }
    }
    nextmenu = MENUE;
}

//--------------------------------------------------------------------------------------------
void menu_boot_players()
{
    // ZZ> This function shows all the active players and lets the host kick 'em out
    //     !!!BAD!!!  Let the host boot players
    char text[256];
    int x, y, starttime, time;
    float open;
    int cnt, player;
    int stillchoosing;


    numplayer = 1;
    if(networkon)
    {
        // Find players
        find_all_players();

        // Open a big window
        open = 0;
        while(open < 1.0)
        {
            //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
            draw_trim_box_opening(0, 0, scrx, scry, open);
            draw_trim_box_opening(0, 0, 320, fontyspacing*(numplayer+4), open);
            flip_pages();
            open += .030;
        }

        // Tell the user which ones we found
        starttime = ClockGetTick(); //GetTickCount(); PUSHED INTO win/lin-file
        stillchoosing = TRUE;
        while(stillchoosing)
        {
            time = ClockGetTick(); //GetTickCount();
            if((time-starttime) > NETREFRESH)
            {
                find_all_players();
                starttime = time;
            }
            //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
            draw_trim_box(0, 0, scrx, scry);
            draw_trim_box(0, 0, 320, fontyspacing*(numplayer+4));
            y = 8;
            sprintf(text, "Active machines...");
            draw_string(text, 14, y);
            y += fontyspacing;
            cnt = 0;
            while(cnt < numplayer)
            {
                sprintf(text, "%s", netplayername[cnt]);
                draw_string(text, 50, y);
                y += fontyspacing;
                cnt++;
            }
            if(hostactive)
            {
                sprintf(text, "Start Game");
                draw_string(text, 50, y);
            }
            else
            {
                listen_for_packets();
            }
            do_cursor();
            x = cursorx - 50;
            y = (cursory - 8 - fontyspacing);
            if(SDLKEYDOWN(SDLK_ESCAPE)) // !!!BAD!!!
            {
                nextmenu = MENUB;
                menuactive = FALSE;
                stillchoosing = FALSE;
                gameactive = FALSE;
            }
            if(x > 0 && x < 300 && y >= 0 && (mousebutton[0] || mousebutton[1]) && hostactive)
            {
                // Let the host do things
                y = y/fontyspacing;
                if(y < numplayer && hostactive)
                {
                    // Boot players
                }
                if(y == numplayer && readytostart)
                {
                    // Start the modules
                    stillchoosing = FALSE;
                }
            }
            if(readytostart && hostactive == FALSE)
            {
                // Remotes automatically start
                stillchoosing = FALSE;
            }
            flip_pages();
        }
    }
    if(networkon && hostactive)
    {
        // Let the host coordinate start
        stop_players_from_joining();
        find_all_players();
        cnt = 0;
        readytostart = FALSE;
        if(numplayer == 1)
        {
            // Don't need to bother, since the host is alone
            readytostart = TRUE;
        }
        while(readytostart==FALSE)
        {
            //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
            draw_trim_box(0, 0, scrx, scry);
            y = 8;
            sprintf(text, "Waiting for replies...");
            draw_string(text, 14, y);
            y += fontyspacing;
            do_cursor();
            if(SDLKEYDOWN(SDLK_ESCAPE)) // !!!BAD!!!
            {
                nextmenu = MENUB;
                menuactive = FALSE;
                stillchoosing = FALSE;
                gameactive = FALSE;
                readytostart = TRUE;
            }
            if((cnt&63)==0)
            {
                sprintf(text, "  Lell...");
                draw_string(text, 14, y);
                player = 0;
                while(player < numplayer-1)
                {
                    start_building_packet();
                    add_packet_us(TO_REMOTE_MODULE);
                    add_packet_ui(seed);
                    add_packet_uc(player+1);
                    add_packet_sz(pickedmodule);
//                    send_packet_to_all_players();
                    send_packet_to_one_player_guaranteed(player);
                    player++;
                }
            }
            listen_for_packets();
            cnt++;
            flip_pages();
        }
    }


    nextmenu=MENUF;
}

//--------------------------------------------------------------------------------------------
void menu_end_text()
{
    // ZZ> This function gives the player the ending text
    float open;
    int stillchoosing;
    SDL_Event ev;


    // Open the text window
    open = 0;
    while(open < 1.0)
    {
        //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
        draw_trim_box_opening(0, 0, scrx, scry, open);
        flip_pages();
        open += .030;
    }



    // Wait for input
    stillchoosing = TRUE;
    while(stillchoosing)
    {
        // Show the text
        //clear_surface(lpDDSBack);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    			glLoadIdentity();
        draw_trim_box(0, 0, scrx, scry);
        draw_wrap_string(endtext, 14, 8, scrx-40);



        // Handle the mouse
        do_cursor();
        if(pending_click || SDLKEYDOWN(SDLK_ESCAPE))
        {
	    pending_click = FALSE;
            stillchoosing = FALSE;
        }
        flip_pages();
    }
    nextmenu = MENUB;
}

//--------------------------------------------------------------------------------------------
void menu_initial_text()
{
    // ZZ> This function gives the player the initial title screen
    float open;
    char text[1024];
    int stillchoosing;


    //fprintf(stderr,"DIAG: In menu_initial_text()\n");
    //draw_trim_box(0, 0, scrx, scry);//draw_trim_box(60, 60, 320, 200); // JUST TEST BOX
    
    // Open the text window
    open = 0;
    while(open < 1.0)
    {
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    	glLoadIdentity();
        
        // clear_surface(lpDDSBack); PORT!
        draw_trim_box_opening(0, 0, scrx, scry, open);
        flip_pages();
        open += .030;
    }

	/*fprintf(stderr,"waiting to read a scanf\n");
    scanf("%s",text);
    exit(0);*/

    // Wait for input
    stillchoosing = TRUE;
    while(stillchoosing)
    {
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    	glLoadIdentity();
        
        // Show the text
        // clear_surface(lpDDSBack); PORT!
        draw_trim_box(0, 0, scrx, scry);
        sprintf(text, "Egoboo v2.22");
        draw_string(text, (scrx>>1)-200, ((scry>>1)-30));
        sprintf(text, "http://egoboo.sourceforge.net");
        draw_string(text, (scrx>>1)-200, ((scry>>1)));
        sprintf(text, "See controls.txt to configure input");
        draw_string(text, (scrx>>1)-200, ((scry>>1)+30));
		
		// get input
		read_input();
		
        // Handle the mouse
        do_cursor();
		if ( pending_click || SDLKEYDOWN(SDLK_ESCAPE) )
		{
		        pending_click = FALSE;
			stillchoosing = FALSE;
		}
        flip_pages();
    }
    nextmenu = MENUA;
}

//--------------------------------------------------------------------------------------------
void fiddle_with_menu()
{
    // ZZ> This function gives a nice little menu to play around in.

    menuactive = TRUE;
    readytostart = FALSE;
    playersready = 0;
    localmachine = 0;
    rtslocalteam = 0;
    numfile = 0;
    numfilesent = 0;
    numfileexpected = 0;
    while(menuactive)
    {
        switch(nextmenu)
        {
            case MENUA:
                // MENUA...  Let the user choose a network service
                //printf("MENUA\n");
                if(menuaneeded)
                {
                    menu_service_select();
                    menuaneeded = FALSE;
                }
                nextmenu = MENUB;
                break;
            case MENUB:
                // MENUB...  Let the user start or join
                //printf("MENUB\n");
                menu_start_or_join();
                break;
            case MENUC:
                // MENUC...  Choose an open game to join
                //printf("MENUC\n");
                menu_choose_host();
                break;
            case MENUD:
                // MENUD...  Choose a module to run
                //printf("MENUD\n");
                menu_choose_module();
                break;
            case MENUE:
                // MENUE...  Wait for all the players
                //printf("MENUE\n");
                menu_boot_players();
                break;
            case MENUF:
                // MENUF...  Let the players choose characters
                //printf("MENUF\n");
                menu_pick_player(pickedindex);
                break;
            case MENUG:
                // MENUG...  Let the user read while it loads
                //printf("MENUG\n");
                menu_module_loading(pickedindex);
                break;
            case MENUH:
                // MENUH...  Show the end text
                //printf("MENUH\n");
                menu_end_text();
                break;
            case MENUI:
                // MENUI...  Show the initial text
                //printf("MENUI\n");
                menu_initial_text();
                break;
        }
    }
    //printf("Left menu system\n");
}

//--------------------------------------------------------------------------------------------
void release_menu_trim()
{
	// ZZ> This function frees the menu trim memory
	//GLTexture_Release( &TxTrimX );		//RELEASE(lpDDSTrimX);
	//GLTexture_Release( &TxTrimY );		//RELEASE(lpDDSTrimY);
	GLTexture_Release( &TxBlip );		//RELEASE(lpDDSBlip);
	GLTexture_Release( &TxTrim );
	
}

//--------------------------------------------------------------------------------------------
void release_menu()
{
	// ZZ> This function releases all the menu images
	GLTexture_Release( &TxFont );		//RELEASE(lpDDSFont);
    release_all_titleimages();
    release_all_icons();
	
}

