/*
 *  ---------
 * |.**> <**.|  CardContact
 * |*       *|  Software & System Consulting
 * |*       *|  Minden, Germany
 * |**> <**|  Copyright (c) 1999. All rights reserved
 *  --------- 
 *
 * See file LICENSE for details on licensing
 *
 * Abstract :       Defines tools/types for 4442 memory card handling
 *
 * Author :         Frank Thater (FTH)
 *
 * Last modified:   03/23/2000
 *
 *****************************************************************************/

#ifndef _MC2WBP_H_
#define _MC2WBP_H_

#include "memorycards.h"


/***************************/
/* Init/Processing Modules */
/***************************/
int MC_2WBPInit(struct eco5000_t *ctx);

int MC_2WBPProcess(struct eco5000_t *ctx,
		   unsigned int lc,
		   unsigned char *cmd,
		   unsigned int *lr,
		   unsigned char *rsp);


/*****************/
/* Other Modules */
/*****************/
int MC2WBP_Select_File(struct eco5000_t *ctx,
		       unsigned int lc,
		       unsigned char *cmd,
		       unsigned int *lr,
		       unsigned char *rsp);

int MC2WBP_Read_Binary(struct eco5000_t *ctx,
		       unsigned int lc,
		       unsigned char *cmd,
		       unsigned int *lr,
		       unsigned char *rsp);

int MC2WBP_Update_Binary(struct eco5000_t *ctx,
			 unsigned int lc,
			 unsigned char *cmd,
			 unsigned int *lr,
			 unsigned char *rsp);

int MC2WBP_Verify(struct eco5000_t *ctx,
		  unsigned int lc,
		  unsigned char *cmd,
		  unsigned int *lr,
		  unsigned char *rsp);

int MC2WBP_Change_Verification_Data(struct eco5000_t *ctx,
				    unsigned int lc,
				    unsigned char *cmd,
				    unsigned int *lr,
				    unsigned char *rsp);

int MC2WBP_Command (struct eco5000_t *ctx,
		    unsigned char *cmd2wbp,
		    unsigned char *rsp);


#endif









