#ifndef __MESSAGE_SIZE_H
#define __MESSAGE_SIZE_H

struct message_size {
	uoff_t physical_size;
	uoff_t virtual_size;
	unsigned int lines;
};

/* Calculate size of message header. Leave the input point to first
   character in body. */
void message_get_header_size(struct istream *input, struct message_size *hdr,
			     int *has_nuls);
/* Calculate size of message body. */
void message_get_body_size(struct istream *input, struct message_size *body,
			   int *has_nuls);

/* Sum contents of src into dest. */
void message_size_add(struct message_size *dest,
		      const struct message_size *src);

#endif
