<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
                exclude-result-prefixes="doc"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: graphics.xsl,v 1.13 2004/07/16 01:59:00 stevecheng Exp $
     ********************************************************************

     &copy; 2000-2001 Steve Cheng <stevecheng@users.sourceforge.net>

     This file is part of the docbook2X XSLT stylesheets for
     converting DocBook to Texinfo.

     Originally derived from Norman Walsh's XSL DocBook Stylesheet
     Distribution.

     ******************************************************************** -->

<!-- ==================================================================== -->

<doc:reference xmlns="">
<title>Graphics and media objects</title>
<partintro>

<para>
These are templates for DocBook graphics and media objects.
</para>
</partintro>
</doc:reference>

<!-- ==================================================================== -->

<xsl:template match="screenshot">
  <xsl:call-template name="anchor" />
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="screeninfo">
</xsl:template>


<!-- ==================================================================== -->
<!-- Templates common to both *graphic and *object elements -->

<xsl:template name="imagedata">

  <xsl:variable name="filename">
    <xsl:choose>
      <xsl:when test="@entityref">
        <xsl:value-of select="unparsed-entity-uri(@entityref)" />
      </xsl:when>

      <xsl:when test="@fileref">
        <xsl:value-of select="@fileref" />
      </xsl:when>

      <xsl:otherwise>
        <xsl:call-template name="user-message">
          <xsl:with-param name="key">Image data must be specified with entityref or fileref attribute</xsl:with-param>
        </xsl:call-template>
        <xsl:text>broken-graphic</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <!-- Texinfo's image width and height are device-independent values,
       so we cannot use the width and depth values from the DocBook 
       source. -->

  <image filename="{$filename}" />
</xsl:template>


<!-- ==================================================================== -->
<!-- *graphic -->

<xsl:template match="graphic">
  <para>
    <xsl:call-template name="anchor" />
    <xsl:call-template name="imagedata" />
  </para>
</xsl:template>

<xsl:template match="inlinegraphic">
  <xsl:call-template name="imagedata" />
</xsl:template>


<!-- ==================================================================== -->
<!-- DocBook 3.1 MediaObjects -->

<xsl:template name="select-mediaobject">
  <xsl:param name="object" />

  <xsl:if test="$object">
    <xsl:choose>
      <!-- Alternative method to this: save the result tree for
           xsl:apply-templates select="$object"; if it is non-empty
           stop processing.
           -->
      <xsl:when test="$object/self::imageobject">
        <xsl:apply-templates select="$object" />
      </xsl:when>

      <xsl:when test="$object/self::textobject">
        <xsl:apply-templates select="$object" />
      </xsl:when>

      <xsl:otherwise>
        <xsl:call-template name="select-mediaobject">
          <xsl:with-param name="object" select="$object/following-sibling::*[1]" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:if>
</xsl:template>
      
<xsl:template match="mediaobject">
  <para>
    <xsl:call-template name="anchor" />
    <xsl:call-template name="select-mediaobject">
      <xsl:with-param name="object" select="child::*[1]" />
    </xsl:call-template>
    <xsl:apply-templates select="make-caption"/>
  </para>
</xsl:template>

<xsl:template match="inlinemediaobject">
  <xsl:call-template name="select-mediaobject">
    <xsl:with-param name="object" select="child::*[1]" />
  </xsl:call-template>
</xsl:template>

<xsl:template match="objectinfo">
</xsl:template>

<xsl:template match="imageobject">
  <xsl:for-each select="imagedata">
    <xsl:call-template name="imagedata" />
  </xsl:for-each>
</xsl:template>

<xsl:template match="textobject">
  <xsl:apply-templates />
</xsl:template>

<xsl:template match="caption">
  <xsl:call-template name="make-caption">
    <xsl:with-param name="content">
      <xsl:apply-templates />
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

</xsl:stylesheet>
