/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio.component;

import de.xeinfach.kafenio.component.ExtendedHTMLDocument;
import de.xeinfach.kafenio.component.RelativeImageView;
import de.xeinfach.kafenio.util.LeanLogger;
import java.net.URL;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class ExtendedHTMLEditorKit
extends HTMLEditorKit {
    private static LeanLogger log = new LeanLogger("ExtendedHTMLEditorKit.class");

    public ExtendedHTMLEditorKit() {
        log.debug("new ExtendedHTMLEditorKit created.");
    }

    public ViewFactory getViewFactory() {
        return new HTMLFactoryExtended();
    }

    public Document createDefaultDocument() {
        return this.createDefaultDocument(null);
    }

    public Document createDefaultDocument(URL uRL) {
        StyleSheet styleSheet = this.getStyleSheet();
        StyleSheet styleSheet2 = new StyleSheet();
        styleSheet2.addStyleSheet(styleSheet);
        ExtendedHTMLDocument extendedHTMLDocument = new ExtendedHTMLDocument(styleSheet2);
        if (uRL != null) {
            extendedHTMLDocument.setBase(uRL);
        }
        extendedHTMLDocument.setParser(this.getParser());
        extendedHTMLDocument.setAsynchronousLoadPriority(4);
        extendedHTMLDocument.setTokenThreshold(100);
        return extendedHTMLDocument;
    }

    public static class HTMLFactoryExtended
    extends HTMLEditorKit.HTMLFactory
    implements ViewFactory {
        public View create(Element element) {
            HTML.Tag tag;
            Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (object instanceof HTML.Tag && (tag = (HTML.Tag)object) == HTML.Tag.IMG) {
                try {
                    return new RelativeImageView(element);
                }
                catch (Exception exception) {
                    log.warn("Error while trying to create new RelativeImageView for element");
                }
            }
            return super.create(element);
        }
    }
}

