/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * misc.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: misc.h,v 1.6 2004/01/09 18:16:01 ericprev Exp $
*/

#ifndef __MISC_H__
#define __MISC_H__

/***********************************************************/
/* routine copiant par troncature une chaine de caracteres */
/***********************************************************/
void strncpy_max(char *destination, const char *source, int max_byte);

/*****************************************************************/
/* empty the given array of allocated strings and free the array */
/*****************************************************************/
void wipe_GPtrArray_of_char_string(GPtrArray **array);

/************************************************************/
/* search for a string in the array. Output: TRUE if inside */
/************************************************************/
gboolean find_a_char_string_in_GPtrArray(GPtrArray **array, const char *str);

/******************************************************/
/* create the given directory (it can start with a /) */
/******************************************************/
/* output: 0=ok else errno */
/***************************/
int recursive_mkdir(GString *directory_name);

/******************************************************************************/
/* count the number of entry inside the given gchar * array (NULL terminated) */
/******************************************************************************/
int gchar_array_len(gchar **array);

#endif

