<?php
/*
 * $Id: class.htmlWorkOrderResults.inc.php,v 1.1.2.2 2004/01/01 23:43:33 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('vw');
LoadStringResource('prj');
import('htmlView');

class htmlWorkOrderResults extends htmlView
{
	function htmlWorkOrderResults()
	{
		parent::htmlView();
		$this->sPagingMenuAction = 'htmlWorkOrderResults.Page';

		$this->sColumnTitle = STR_CMMN_OPTIONS;
	}
	
	function InitTemplate()
	{
		$this->Template = CreateTemplate(array('hForm' => 'htmlWorkOrderResults.tpl'));
		$this->_CreateBlocks();
		$this->_ResetBlocks();
	}

	function Render(&$oView)
	{
		global $dcl_info;

		if (!is_object($oView))
		{
			print('[htmlWorkOrderResults::Render] ' . STR_VW_VIEWOBJECTNOTPASSED);
			return;
		}

		$this->oView = &$oView;
		$this->oView->numrows = 0;
		$this->oView->offset = 0;
		$this->InitTemplate();
		
		$this->_SetStaticOptions();
		if (!$this->_Execute())
			return;

		$this->_SetVar('VAL_SEARCHACTION', menuLink());
		$this->_SetVar('VAL_VIEWSETTINGS', $this->oView->GetForm());

		$this->_SetActionFormOptions();
		$this->Template->pparse('out', 'header');

		if (!$this->oDB->next_record())
		{
			$this->_NoMatches();
			$this->_Finish();
			return;
		}
		
		$this->Template->pparse('out', 'matchesStart');

		$iOffset = 0;
		if (in_array('_num_accounts_', $this->oDB->Record))
			$iOffset = -1;

		do // next_record already called to check for matches
		{
			$this->_DisplayGroups();
			$this->_DisplayDetailHeader();
			$this->_DisplayDetail();
		}
		while ($this->oDB->next_record());

		$this->Template->pparse('out', 'footer');
	}
	
	function _CreateBlocks()
	{
		$this->Template->set_block('hForm', 'header', 'hHeader');
		$this->Template->set_block('hForm', 'footer', 'hFooter');
		$this->Template->set_block('hForm', 'nomatches', 'hNomatches');
		$this->Template->set_block('hForm', 'matchesStart', 'hMatchesStart');
		$this->Template->set_block('hForm', 'matchesEnd', 'hMatchesEnd');

		$this->Template->set_block('hForm', 'group', 'hGroup');
		$this->Template->set_block('hForm', 'detailHeader', 'hDetailHeader');

		$this->Template->set_block('detailHeader', 'detailHeaderCells', 'hDetailHeaderCells');

		$this->Template->set_block('detailHeaderCells', 'detailHeaderPadding', 'hDetailHeaderPadding');
		$this->Template->set_block('detailHeaderCells', 'detailHeaderColumnText', 'hDetailHeaderColumnText');
		$this->Template->set_block('detailHeaderCells', 'detailHeaderColumnLink', 'hDetailHeaderColumnLink');

		$this->Template->set_block('hForm', 'detail', 'hDetail');
		$this->Template->set_block('detail', 'detailCells', 'hDetailCells');

		$this->Template->set_block('detailCells', 'detailPadding', 'hDetailPadding');
		$this->Template->set_block('detailCells', 'detailColumnText', 'hDetailColumnText');
		$this->Template->set_block('detailCells', 'detailColumnLink', 'hDetailColumnLink');

		$this->Template->set_block('header', 'actionFormOptions', 'hActionFormOptions');
		$this->Template->set_block('detailHeaderCells', 'detailHeaderCheckbox', 'hDetailHeaderCheckbox');
		$this->Template->set_block('detailCells', 'detailCheckbox', 'hDetailCheckbox');
		$this->Template->set_block('detailCells', 'detailColumnAccount', 'hDetailColumnAccount');
	}

	function _ResetBlocks()
	{
		$this->_SetVar('hHeader', '');
		$this->_SetVar('hFooter', '');
		$this->_SetVar('hNomatches', '');
		$this->_SetVar('hMatchesStart', '');
		$this->_SetVar('hMatchesEnd', '');
		$this->_SetVar('hGroup', '');
		$this->_SetVar('hDetailHeader', '');
		$this->_SetVar('hDetailRows', '');
		$this->_SetVar('hDetailHeaderCells', '');
		$this->_SetVar('hDetailHeaderPadding', '');
		$this->_SetVar('hDetailHeaderColumnText', '');
		$this->_SetVar('hDetailHeaderColumnLink', '');
		$this->_SetVar('hDetail', '');
		$this->_SetVar('hDetailCells', '');
		$this->_SetVar('hDetailPadding', '');
		$this->_SetVar('hDetailColumnText', '');
		$this->_SetVar('hDetailColumnLink', '');
		$this->_SetVar('hActionFormOptions', '');
		$this->_SetVar('hFilterStatusOptions', '');
		$this->_SetVar('hFilterTypeOptions', '');
		$this->_SetVar('hFilterPersonnelOptions', '');
		$this->_SetVar('hFilterProductOptions', '');
		$this->_SetVar('hDetailHeaderCheckbox', '');
		$this->_SetVar('hDetailCheckbox', '');
		$this->_SetVar('hDetailColumnAccount', '');
	}

	function _SetStaticOptions()
	{
		parent::_SetStaticOptions();
		$this->_SetVar('TXT_STATUS', STR_WO_STATUS);
		$this->_SetVar('TXT_TYPE', STR_WO_TYPE);
		$this->_SetVar('TXT_GO', STR_CMMN_GO);
		$this->_SetVar('TXT_FILTER', 'Filter');
		$this->_SetVar('TXT_RESPONSIBLE', STR_WO_RESPONSIBLE);
		$this->_SetVar('TXT_PRODUCT', STR_WO_PRODUCT);
	}

	function _SetActionFormOptions()
	{
		global $g_oSec, $dcl_info;

		$aOptions = array(
			STR_VW_SAVESEARCH => array('menuAction' => 'boViews.add', 'hasPermission' => true),
			'Refine Search' => array('menuAction' => 'htmlWOSearches.ShowRequest', 'hasPermission' => true),
			STR_VW_EXPORTRESULTS => array('menuAction' => 'boViews.export', 'hasPermission' => true),
			'Batch Detail' => array('menuAction' => 'boWorkorders.batchdetail', 'hasPermission' => true),
			STR_VW_BATCHTIMECARD => array('menuAction' => 'boTimecards.batchadd', 'hasPermission' => $g_oSec->HasSecLvl($dcl_info['DCL_HAVE_WO'])),
			STR_PRJ_BATCHASSIGN => array('menuAction' => 'boWorkorders.batchassign', 'hasPermission' => $g_oSec->HasSecLvl($dcl_info['DCL_ASSIGN_WO'])),
			STR_PRJ_BATCHMOVE => array('menuAction' => 'htmlProjectmap.batchmove', 'hasPermission' => $g_oSec->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
			);

		foreach ($aOptions as $sDisplay => $aOption)
		{
			if ($aOption['hasPermission'])
			{
				$this->_AddOption('hActionFormOptions', 'actionFormOptions', array(
    				'VAL_ACTIONOPTION' => $aOption['menuAction'],
					'TXT_ACTIONOPTION' => $sDisplay
					));
			}
		}
	}

	function _DisplayGroups()
	{
		global $dcl_info, $g_oSec;
		
		if (count($this->oView->groups) < 1)
			return;
			
		// Grouping the report, so check and display headings as needed
		$iExtraCols = 2;
		if ($g_oSec->HasSecLvl($dcl_info['DCL_HAVE_WO']))
			$iExtraCols++;

		$bGroupChanged = false;
		$bSectionChanged = false;
		for ($i = 0; $i < count($this->oView->groups); $i++)
		{
			$thisGroup = $this->oDB->f($i);
			if ($thisGroup == '')
				$thisGroup = '<NULL>';

			if (!IsSet($this->aGroups[$i]) || $this->aGroups[$i] != $thisGroup)
			{
				if (!$bSectionChanged && IsSet($this->aGroups[$i]))
				{
					$this->_SetVar('hGroup', '');
					$this->_SetVar('hDetailHeader', '');
					$this->_SetVar('hDetailRows', '');
					$bSectionChanged = true;
				}
				
				$this->_SetVar('VAL_GROUPCOLSPAN', count($this->oView->columns) + $iExtraCols);
				$this->_SetVar('VAL_GROUPPADDING', $i * 20);

				if ($i == 0)
					$this->_SetVar('VAL_GROUPCLASS', 'groupLevel0');
				else
					$this->_SetVar('VAL_GROUPCLASS', 'groupLevel1');

				if ($i == 0 && $thisGroup == '<NULL>')
					$this->_SetVar('VAL_GROUP', '&nbsp;');
				else
					$this->_SetVar('VAL_GROUP', htmlentities($thisGroup));

				$this->Template->pparse('out', 'group');

				if ($i < (count($this->oView->groups) - 1))
				{
					for ($j = $i + 1; $j < count($this->oView->groups); $j++)
						unset($this->aGroups[$j]);
				}

				$this->aGroups[$i] = $thisGroup;
				$this->bNeedsHeader = true;
			}
		}
	}

	function _ResetDetailHeaderCells()
	{
		$this->_SetVar('hDetailHeaderPadding', '');
		$this->_SetVar('hDetailHeaderCheckbox', '');
		$this->_SetVar('hDetailHeaderColumnText', '');
		$this->_SetVar('hDetailHeaderColumnLink', '');
	}

	function _DisplayDetailHeader()
	{
		global $dcl_info;

		if (!$this->bNeedsHeader)
			return;

		$this->_SetVar('hDetailHeader', '');
		$this->_SetVar('hDetailHeaderCells', '');
		$this->_ResetDetailHeaderCells();

		if (count($this->oView->groups) > 0)
		{
			$this->_SetVar('VAL_DETAILHEADERPADDING', count($this->oView->groups) * 20);
			$this->Template->parse('hDetailHeaderPadding', 'detailHeaderPadding');
			$this->Template->parse('hDetailHeaderCells', 'detailHeaderCells', true);

			// this avoids repeating cells
			$this->_ResetDetailHeaderCells();
		}

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'])
		{
			$this->Template->parse('hDetailHeaderCheckbox', 'detailHeaderCheckbox');
			$this->Template->parse('hDetailHeaderCells', 'detailHeaderCells', true);

			// this avoids repeating cells
			$this->_ResetDetailHeaderCells();
		}

		$iOffset = 0;

		for ($i = count($this->oView->groups); $i < (count($this->oView->groups) + count($this->oView->columns) + $iOffset); $i++)
		{
			if (count($this->oView->columnhdrs) > 0)
				$sHdr = $this->oView->columnhdrs[$i];
			else
				$sHdr = $this->oDB->GetFieldName($i);

			$this->_SetVar('VAL_COLUMNHEADER', $sHdr);

			if ($this->bColumnSort)
			{
				$this->oView->ClearDef('order');
				$this->oView->AddDef('order', $this->oView->columns[$i - count($this->oView->groups)], '');

				$this->_SetVar('LNK_COLUMNHEADER', menuLink('', 'menuAction=' . $this->sPagingMenuAction . '&' . $this->oView->GetURL()));
				$this->Template->parse('hDetailHeaderColumnLink', 'detailHeaderColumnLink');
			}
			else
			{
				$this->Template->parse('hDetailHeaderColumnText', 'detailHeaderColumnText');
			}

			$this->Template->parse('hDetailHeaderCells', 'detailHeaderCells', true);

			// this avoids repeating cells
			$this->_ResetDetailHeaderCells();
		}

		if ($this->sColumnTitle != '')
		{
			$this->_SetVar('VAL_COLUMNHEADER', $this->sColumnTitle);
			$this->Template->parse('hDetailHeaderColumnText', 'detailHeaderColumnText');
			$this->Template->parse('hDetailHeaderCells', 'detailHeaderCells', true);
		}

		$this->bNeedsHeader = false;
		$row = 0;

		$this->Template->pparse('out', 'detailHeader');
	}

	function _ResetDetailCells()
	{
		$this->_SetVar('hDetailPadding', '');
		$this->_SetVar('hDetailCheckbox', '');
		$this->_SetVar('hDetailColumnText', '');
		$this->_SetVar('hDetailColumnLink', '');
		$this->_SetVar('hDetailColumnAccount', '');
	}

	function _DisplayDetail()
	{
		global $dcl_info;

		$this->_SetVar('hDetail', '');
		$this->_SetVar('hDetailCells', '');

		if ($this->oDB->cur % 2 == 0)
			$this->_SetVar('VAL_DETAILCLASS', 'even');
		else
			$this->_SetVar('VAL_DETAILCLASS', 'odd');

		if (count($this->oView->groups) > 0)
		{
			$this->_SetVar('VAL_DETAILPADDING', (count($this->oView->groups) + 1) * 20);
			$this->Template->parse('hDetailPadding', 'detailPadding');
			$this->Template->parse('hDetailCells', 'detailCells', true);

			// this avoids repeating cells
			$this->_ResetDetailCells();
		}

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'])
		{
			$this->_SetVar('VAL_ROWSELECT', sprintf('%d.%d', $this->oDB->f('jcn'), $this->oDB->f('seq')));
			$this->Template->parse('hDetailCheckbox', 'detailCheckbox');
			$this->Template->parse('hDetailCells', 'detailCells', true);

			// this avoids repeating cells
			$this->_ResetDetailCells();
		}

		$iAccountField = -1;
		if (in_array('accounts.name', $this->oView->columns))
		{
			foreach ($this->oView->columns as $iAccountField => $name)
			{
				if ($name == 'accounts.name')
					break;
			}
		}

		$iGroupCount = count($this->oView->groups);
		for ($i = $iGroupCount; $i < count($this->oView->columns) + count($this->oView->groups); $i++)
		{
			$sFieldName = $this->oDB->GetFieldName($i);
			$sFieldValue = $this->oDB->f($i);

			if ($sFieldName == 'jcn' || $sFieldName == 'seq')
			{
				$this->_SetVar('VAL_COLUMNVALUE', $this->oDB->f($i));
				$this->_SetVar('LNK_COLUMNVALUE', menuLink('', sprintf('menuAction=boWorkorders.viewjcn&jcn=%d&seq=%d',
							$this->oDB->f('jcn'),
							$this->oDB->f('seq'))));

				$this->Template->parse('hDetailColumnLink', 'detailColumnLink');
			}
			else if ($dcl_info['DCL_WO_SECONDARY_ACCOUNTS_ENABLED'] == 'Y' && $iAccountField == ($i - $iGroupCount))
			{
				$this->_SetVar('VAL_COLUMNVALUE', $this->oDB->f($i));
				$this->_SetVar('VAL_WOID', $this->oDB->f('jcn'));
				$this->_SetVar('VAL_SEQ', $this->oDB->f('seq'));
				if ($this->oDB->f('_num_accounts_') > 1)
				{
					$this->Template->parse('hDetailColumnAccount', 'detailColumnAccount');
				}
				else
				{
					$this->Template->parse('hDetailColumnText', 'detailColumnText');
				}
			}
			else
			{
				if ($this->oDB->IsTimestamp($i))
					$this->_SetVar('VAL_COLUMNVALUE', $this->oDB->FormatTimeStampForDisplay($this->oDB->f($i)));
				else if ($this->oDB->IsDate($i))
					$this->_SetVar('VAL_COLUMNVALUE', $this->oDB->FormatDateForDisplay($this->oDB->f($i)));
				else
					$this->_SetVar('VAL_COLUMNVALUE', $this->oDB->f($i));

				$this->Template->parse('hDetailColumnText', 'detailColumnText');
			}

			$this->Template->parse('hDetailCells', 'detailCells', true);

			// this avoids repeating cells
			$this->_ResetDetailCells();
		}

		$this->_DisplayOptions();

		$this->Template->pparse('out', 'detail');
	}

	function _DisplayOptions()
	{
		$this->_SetVar('LNK_COLUMNDISABLED', '');
		$this->_SetVar('LNK_COLUMNVALUE', menuLink('', 'menuAction=boWorkorders.viewjcn&jcn=' . $this->oDB->f('jcn') . '&seq=' . $this->oDB->f('seq')));
		$this->_SetVar('VAL_COLUMNVALUE', STR_CMMN_VIEW);
		$this->Template->parse('hDetailColumnLink', 'detailColumnLink');

		$this->Template->parse('hDetailCells', 'detailCells', true);

		// this avoids repeating cells
		$this->_ResetDetailCells();
	}
}
?>
