/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * do_connect.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: do_connect.h,v 1.3 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifndef __DO_CONNECT_H__
#define __DO_CONNECT_H__

/********************/
/* start a new DCTC */
/***********************************************************************************************/
/* if no_wait is set, the -l flag is not added and DCTC starts without waiting a UI connection */
/* if profile_to_use==NULL then the current profile is used.                                   */
/***********************************************************************************************/
void start_a_new_dctc(const char *hub_address, int no_wait, char *profile_to_use);

/**************************************/
/* connect to an already running DCTC */
/**************************************/
void connect_to_a_running_dctc(char *dctc_entry);

/*********************************************/
/* (re)connect to the master DCTC (gdl dctc) */
/*********************************************/
void connect_to_the_master_dctc(void);

/***********************************/
/* add a new var to the vars array */
/***********************************/
void add_var(char *var_name, char *var_value);

/***********************************/
/* get a value from the vars array */
/***********************************/
const char *get_var(char* var_name);

/**************************************/
/* get the size of the file dir/fname */
/**********************************************/
/* output: file size. On error, 0 is returned */
/**********************************************/
unsigned long get_file_size(const char *dir, char *fname);

/******************************************************************************************/
/* update the line i of the clist (clst) with the name 't' in the dir (cur_dir="dl_path") */
/******************************************************************************************/
void update_dl_clist_size(GtkTreeModel *gtm,GtkListStore *gls, GtkTreeIter *iter,const char *cur_dir);

#if 0
typedef struct
{
	time_t start_time;			/* start time of the download */
	unsigned long start_pos;	/* start position */
} DL_XTRA;
#endif

/*******************************************************/
/* name of the last used socket (dctc-xxxxxxxx-yyyyyy) */
/*******************************************************/
extern char last_known_running_dctc_name[512];

/*************************************************************************/
/* send the redirection message to force the client to go to another hub */
/*************************************************************************/
void go_to_another_hub(const char *hubname);

/***********************************************************/
/* convert the given tos_string into a DCTC (IP) TOS value */
/***********************************************************/
unsigned int tos_string_to_num(const char *tos_string);

#endif
