/* Distributed Checksum Clearinghouse
 *
 * unthreaded version of client locking
 *
 * Copyright (c) 2005 by Rhyolite Software
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.2.74-1.29 $Revision$
 */

#include "dcc_ck.h"


/* many POSIX thread implementations have unexpected side effects on
 * ordinary system calls, so don't use the threaded version unless
 * necessary */

u_char grey_on;
u_char grey_query_only;

DCC_WF cmn_wf;


void
dcc_ctxts_lock(void)
{
}



void
dcc_ctxts_unlock(void)
{
}



void
dcc_syslog_lock(void)
{
}



void
dcc_syslog_unlock(void)
{
}



u_char dcc_host_locked = 1;

void
dcc_host_lock(void)
{
}



void
dcc_host_unlock(void)
{
}



#ifdef DEBUG_HEAP
void
dcc_malloc_lock(void)
{
}


void
dcc_malloc_unlock(void)
{
}
#endif /* DEBUG_HEAP */



#ifndef HAVE_LOCALTIME_R
void
dcc_localtime_lock(void)
{
}



void
dcc_localtime_unlock(void)
{
}
#endif /* HAVE_LOCALTIME_R */



void
dcc_clnt_unthread_init(void)
{
#ifdef DCC_WIN32
	win32_init();
#endif
}


u_char
dcc_resolve_mutex_lock(u_char opt UATTRIB)
{
	return 1;
}



void
dcc_resolve_mutex_unlock(void)
{
}



u_char
dcc_clnt_wake_resolve(void)
{
	return 0;
}



u_char
dcc_dnsbl_lock_init(void)
{
	return 0;
}



void
dcc_dnsbl_lock(void)
{
}



void
dcc_dnsbl_signal(void)
{
}



void
dcc_dnsbl_wait(time_t stop UATTRIB)
{
}



void
dcc_dnsbl_unlock(void)
{
}



void
dcc_wf_init(DCC_WF *wf, void *mutex,
	    u_char per_user)		/* 0=global 1=per-user 2=wlist */
{
	/* the following lines must match dcc_wf_init() in clnt_threaded.c */
	wf->ht_fd = -1;
	if (per_user == 0)
		wf->flags &= ~DCC_WF_PER_USER;
	else if (per_user == 1)
		wf->flags |= DCC_WF_PER_USER;
	wf->mutex = mutex;
}



void
dcc_wf_lock(DCC_WF *wf UATTRIB)
{
}



void
dcc_wf_unlock(DCC_WF *wf UATTRIB)
{
}
