<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0"
    xmlns:lxslt="http://xml.apache.org/xslt"
    xmlns:redirect="org.apache.xalan.lib.Redirect"
    extension-element-prefixes="redirect">

  <!--
       Use DashboardStamp as a parameter, default to most recent
       The proper flags to Xalan are in the form -PARAM DashboardStamp "string('foo')"
       -->
  <xsl:param name="DashboardStamp" select="string('MostRecentResults-Nightly')"/>
  <xsl:variable name="DashboardDir" select="concat('../', $DashboardStamp)"/>
  <xsl:param name="TestDocDir">.</xsl:param>

  <xsl:include href="DashboardConfig.xsl" />
  <xsl:output method="html"/>

  <xsl:template match="/Update">
    <xsl:call-template name="Summary"/>
    <xsl:choose>
      <xsl:when test="@mode='Client'">
        <xsl:call-template name="DashboardHeader">
          <xsl:with-param name="Title">Files changed <xsl:value-of select="Site"/> -- <xsl:value-of select="BuildName"/> as of <xsl:value-of select="StartDateTime"/></xsl:with-param>
          <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
          <xsl:with-param name="DashboardDir" select="concat('../../../../Dashboard/', $DashboardStamp)"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="@mode='Server'">
        <xsl:call-template name="DashboardHeader">
          <xsl:with-param name="Title">Changes</xsl:with-param>
          <xsl:with-param name="IconDir">../../Icons</xsl:with-param>
          <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="DashboardHeader">
          <xsl:with-param name="Title">Changes</xsl:with-param>
          <xsl:with-param name="IconDir">../../Icons</xsl:with-param>
          <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
        </xsl:call-template>
      </xsl:otherwise>
   </xsl:choose>

    <xsl:choose>
        <xsl:when test="@mode='Client'">
          <h3>Files changed <xsl:value-of select="Site"/> -- <xsl:value-of select="BuildName"/> as of <xsl:value-of select="StartDateTime"/></h3>
          <xsl:call-template name="JavaScriptHeader">
            <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
          </xsl:call-template>
        </xsl:when>
        <xsl:when test="@mode='Server'">
          <h3>Changed files as of  <xsl:value-of select="StartDateTime"/></h3>
          <xsl:call-template name="JavaScriptHeader">
            <xsl:with-param name="IconDir">../../Icons</xsl:with-param>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <h3>Changed files as of <xsl:value-of select="StartDateTime"/></h3>
          <xsl:call-template name="JavaScriptHeader">
            <xsl:with-param name="IconDir">../../Icons</xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
     </xsl:choose>
    [<a href="javascript:reload()" onMouseOver="window.parent.status='Expand all';return true;" onClick="explode()">Expand all</a>
      <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;|&nbsp;]]></xsl:text><a href="javascript:reload()" onMouseOver="window.parent.status='Collapse all';return true;" onClick="contract()">Collapse all</a>]
      <p></p>
    <script LANGUAGE="JavaScript">

      dbAdd (true, "Updated files  (<xsl:value-of select="count(/Update/Directory/Updated)"/>)", "", 0, "", "1", "", "", "")
      <xsl:for-each select="Directory">
        <xsl:sort select="Name"/>
        <xsl:if test="count(Updated)">
          dbAdd (true, "<b><xsl:value-of select="Name"/> (<xsl:value-of select="count(Updated)"/>)</b>", "", 1, "", "1", "", "", "")
          <xsl:for-each select="Updated">
            <xsl:sort select="Name"/>
            <xsl:call-template name="dbAdd">
              <xsl:with-param name="Level">2</xsl:with-param>
            </xsl:call-template>
          </xsl:for-each>
        </xsl:if>
      </xsl:for-each>

      dbAdd (true, "Modified files  (<xsl:value-of select="count(/Update/Directory/Modified)"/>)", "", 0, "", "1", "", "", "")
      <xsl:for-each select="Directory">
        <xsl:sort select="Name"/>
        <xsl:if test="count(Modified)">
          dbAdd (true, "<b><xsl:value-of select="Name"/> (<xsl:value-of select="count(Modified)"/>)</b>", "", 1, "", "1", "", "", "")
          <xsl:for-each select="Modified">
            <xsl:sort select="Name"/>
            <xsl:call-template name="dbAdd">
              <xsl:with-param name="Level">2</xsl:with-param>
            </xsl:call-template>
          </xsl:for-each>
        </xsl:if>
      </xsl:for-each>

      dbAdd (true, "Conflicting files  (<xsl:value-of select="count(/Update/Directory/Conflicting)"/>)", "", 0, "", "1", "", "", "")
      <xsl:for-each select="Directory">
        <xsl:sort select="Name"/>
        <xsl:if test="count(Conflicting)">
          dbAdd (true, "<b><xsl:value-of select="Name"/> (<xsl:value-of select="count(Conflicting)"/>)</b>", "", 1, "", "1", "", "", "")
          <xsl:for-each select="Conflicting">
            <xsl:sort select="Name"/>
            <xsl:call-template name="dbAdd">
              <xsl:with-param name="Level">2</xsl:with-param>
            </xsl:call-template>
          </xsl:for-each>
        </xsl:if>
      </xsl:for-each>

      </script>
    <xsl:call-template name="JavaScriptFooter"/>
    [<a href="javascript:reload()" onMouseOver="window.parent.status='Expand all';return true;" onClick="explode()">Expand all</a>
    <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;|&nbsp;]]></xsl:text><a href="javascript:reload()" onMouseOver="window.parent.status='Collapse all';return true;" onClick="contract()">Collapse all</a>]
    <br/><br/>
    <xsl:choose>
      <xsl:when test="@mode='Client'">
        <xsl:call-template name="DashboardFooter">
          <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="@mode='Server'">
        <xsl:call-template name="DashboardFooter">
          <xsl:with-param name="IconDir">../../Icons</xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="DashboardFooter">
          <xsl:with-param name="IconDir">../../Icons</xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>

  <xsl:template name="dbAdd">
    <xsl:param name="Level">1</xsl:param>
    <xsl:variable name="Level2"><xsl:value-of select="$Level + 1"/></xsl:variable>

    <xsl:choose>
      <xsl:when test="PriorRevision = Revision">
        <xsl:choose>
        <xsl:when test="$CVSWebURL!='' and $CVSROOT!=''">
        dbAdd (false, "<xsl:value-of select="File"/> Rev: <xsl:value-of select="Revision"/> ", "<xsl:value-of select="$CVSWebURL"/><xsl:value-of select="FullName"/>?cvsroot=<xsl:value-of select="$CVSROOT"/>&amp;rev=<xsl:value-of select="Revision"/>&amp;content-type=text/x-cvsweb-markup", <xsl:value-of select="$Level"/>, "", "1", "<xsl:value-of select="Author"/>", "<xsl:value-of select="Email"/>", "<xsl:value-of select="translate ( normalize-space ( Log ), '&quot;', ' ' )"/>")
        </xsl:when>
        <xsl:when test="$CVSWebURL!=''">
        dbAdd (false, "<xsl:value-of select="File"/> Rev: <xsl:value-of select="Revision"/> ", "<xsl:value-of select="$CVSWebURL"/><xsl:value-of select="FullName"/>?rev=<xsl:value-of select="Revision"/>&amp;content-type=text/x-cvsweb-markup", <xsl:value-of select="$Level"/>, "", "1", "<xsl:value-of select="Author"/>", "<xsl:value-of select="Email"/>", "<xsl:value-of select="translate ( normalize-space ( Log ), '&quot;', ' ' )"/>")
        </xsl:when>
        <xsl:otherwise>
        dbAdd (false, "<xsl:value-of select="File"/> Rev: <xsl:value-of select="Revision"/> ", "", <xsl:value-of select="$Level"/>, "", "1", "<xsl:value-of select="Author"/>", "<xsl:value-of select="Email"/>", "<xsl:value-of select="translate ( normalize-space ( Log ), '&quot;', ' ' )"/>")
        </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
        <xsl:when test="$CVSWebURL!='' and $CVSROOT!=''">
      dbAdd (false, "<xsl:value-of select="File"/> Rev: <xsl:value-of select="Revision"/> ", "<xsl:value-of select="$CVSWebURL"/><xsl:value-of select="FullName"/>.diff?cvsroot=<xsl:value-of select="$CVSROOT"/>&amp;r1=<xsl:value-of select="PriorRevision"/>&amp;r2=<xsl:value-of select="Revision"/>", <xsl:value-of select="$Level"/>, "", "1", "<xsl:value-of select="Author"/>", "<xsl:value-of select="Email"/>", "<xsl:value-of select="translate ( normalize-space ( Log ), '&quot;', ' ' )"/>")
        </xsl:when>
        <xsl:when test="$CVSWebURL!=''">
      dbAdd (false, "<xsl:value-of select="File"/> Rev: <xsl:value-of select="Revision"/> ", "<xsl:value-of select="$CVSWebURL"/><xsl:value-of select="FullName"/>.diff?r1=<xsl:value-of select="PriorRevision"/>&amp;r2=<xsl:value-of select="Revision"/>", <xsl:value-of select="$Level"/>, "", "1", "<xsl:value-of select="Author"/>", "<xsl:value-of select="Email"/>", "<xsl:value-of select="translate ( normalize-space ( Log ), '&quot;', ' ' )"/>")
        </xsl:when>
        <xsl:otherwise>
      dbAdd (false, "<xsl:value-of select="File"/> Rev: <xsl:value-of select="Revision"/> ", "", <xsl:value-of select="$Level"/>, "", "1", "<xsl:value-of select="Author"/>", "<xsl:value-of select="Email"/>", "<xsl:value-of select="translate ( normalize-space ( Log ), '&quot;', ' ' )"/>")
        </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>


  <xsl:template name="Summary">
    <redirect:write select="concat(string('{$TestDocDir}'), '/UpdateSummary.xml' )">
      <xsl:text disable-output-escaping="yes">&lt;?xml version="1.0" encoding="ISO-8859-1"?&gt;
</xsl:text>
      <Update><xsl:attribute name="mode"><xsl:value-of select="@mode"/></xsl:attribute>
        <xsl:if test="@mode='Client'">
            <SiteName><xsl:value-of select="Site"/></SiteName>
            <xsl:copy-of select="BuildName"/>
            <xsl:copy-of select="BuildStamp"/>
        </xsl:if>
        <StartDateTime><xsl:value-of select="StartDateTime"/></StartDateTime>
        <ChangedFileCount><xsl:value-of select="count(Directory/Updated|Directory/Modified|Directory/Conflicting)"/></ChangedFileCount>
        <AuthorCount><xsl:value-of select="count(Author)"/></AuthorCount>
        <AuthorList>
          <xsl:for-each select="Author">
            <Author><xsl:value-of select="Name"/></Author>
          </xsl:for-each>
        </AuthorList>
        <DirectoryCount><xsl:value-of select="count(Directory)"/></DirectoryCount>
      </Update>
    </redirect:write>
  </xsl:template>


</xsl:stylesheet>
