/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xpath.Expression;
import org.apache.xpath.axes.AttributeIterator;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.ChildIterator;
import org.apache.xpath.axes.ChildTestIterator;
import org.apache.xpath.axes.DescendantIterator;
import org.apache.xpath.axes.FilterExprWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.MatchPatternIterator;
import org.apache.xpath.axes.OneStepIterator;
import org.apache.xpath.axes.OneStepIteratorForward;
import org.apache.xpath.axes.ReverseAxesWalker;
import org.apache.xpath.axes.SelfIteratorNoPredicate;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.axes.WalkingIteratorSorted;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.patterns.ContextMatchStepPattern;
import org.apache.xpath.patterns.FunctionPattern;
import org.apache.xpath.patterns.StepPattern;

public class WalkerFactory {
    static final boolean DEBUG_PATTERN_CREATION = false;
    static final boolean DEBUG_WALKER_CREATION = false;
    static final boolean DEBUG_ITERATOR_CREATION = false;
    public static final int BITS_COUNT = 255;
    public static final int BITS_RESERVED = 3840;
    public static final int BIT_PREDICATE = 4096;
    public static final int BIT_ANCESTOR = 8192;
    public static final int BIT_ANCESTOR_OR_SELF = 16384;
    public static final int BIT_ATTRIBUTE = 32768;
    public static final int BIT_CHILD = 65536;
    public static final int BIT_DESCENDANT = 131072;
    public static final int BIT_DESCENDANT_OR_SELF = 262144;
    public static final int BIT_FOLLOWING = 524288;
    public static final int BIT_FOLLOWING_SIBLING = 0x100000;
    public static final int BIT_NAMESPACE = 0x200000;
    public static final int BIT_PARENT = 0x400000;
    public static final int BIT_PRECEDING = 0x800000;
    public static final int BIT_PRECEDING_SIBLING = 0x1000000;
    public static final int BIT_SELF = 0x2000000;
    public static final int BIT_FILTER = 0x4000000;
    public static final int BIT_ROOT = 0x8000000;
    public static final int BITMASK_TRAVERSES_OUTSIDE_SUBTREE = 234381312;
    public static final int BIT_BACKWARDS_SELF = 0x10000000;
    public static final int BIT_ANY_DESCENDANT_FROM_ROOT = 0x20000000;
    public static final int BIT_NODETEST_ANY = 0x40000000;
    public static final int BIT_MATCH_PATTERN = Integer.MIN_VALUE;

    private static int analyze(Compiler compiler, int n, int n2) throws TransformerException {
        int n3;
        int[] nArray = compiler.getOpMap();
        int n4 = 0;
        int n5 = 0;
        while ((n3 = nArray[n]) != -1) {
            ++n4;
            boolean bl = WalkerFactory.analyzePredicate(compiler, n, n3);
            if (bl) {
                n5 |= 0x1000;
            }
            switch (n3) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    n5 |= 0x4000000;
                    break;
                }
                case 50: {
                    n5 |= 0x8000000;
                    break;
                }
                case 37: {
                    n5 |= 0x2000;
                    break;
                }
                case 38: {
                    n5 |= 0x4000;
                    break;
                }
                case 39: {
                    n5 |= 0x8000;
                    break;
                }
                case 49: {
                    n5 |= 0x200000;
                    break;
                }
                case 40: {
                    n5 |= 0x10000;
                    break;
                }
                case 41: {
                    n5 |= 0x20000;
                    break;
                }
                case 42: {
                    if (n4 == 2 && n5 == 0x8000000) {
                        n5 |= 0x20000000;
                    }
                    n5 |= 0x40000;
                    break;
                }
                case 43: {
                    n5 |= 0x80000;
                    break;
                }
                case 44: {
                    n5 |= 0x100000;
                    break;
                }
                case 46: {
                    n5 |= 0x800000;
                    break;
                }
                case 47: {
                    n5 |= 0x1000000;
                    break;
                }
                case 45: {
                    n5 |= 0x400000;
                    break;
                }
                case 48: {
                    n5 |= 0x2000000;
                    break;
                }
                case 51: {
                    n5 |= 0x80008000;
                    break;
                }
                case 52: {
                    n5 |= 0x80002000;
                    break;
                }
                case 53: {
                    n5 |= 0x80400000;
                    break;
                }
                default: {
                    throw new RuntimeException(XSLMessages.createXPATHMessage(75, new Object[]{Integer.toString(n3)}));
                }
            }
            if (nArray[n + 3] == 1033) {
                n5 |= 0x40000000;
            }
            if ((n = compiler.getNextStepPos(n)) < 0) break;
        }
        return n5 |= n4 & 0xFF;
    }

    static boolean analyzePredicate(Compiler compiler, int n, int n2) throws TransformerException {
        switch (n2) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                int n3 = compiler.getArgLength(n);
                break;
            }
            default: {
                int n4 = compiler.getArgLengthOfStep(n);
            }
        }
        int n5 = compiler.getFirstPredicateOpPos(n);
        int n6 = compiler.countPredicates(n5);
        return n6 > 0;
    }

    public static boolean canCrissCross(int n) {
        if (WalkerFactory.walksSelfOnly(n)) {
            return false;
        }
        if (WalkerFactory.walksDownOnly(n) && !WalkerFactory.canSkipSubtrees(n)) {
            return false;
        }
        if (WalkerFactory.walksChildrenAndExtraAndSelfOnly(n)) {
            return false;
        }
        if (WalkerFactory.walksDescendantsAndExtraAndSelfOnly(n)) {
            return false;
        }
        if (WalkerFactory.walksUpOnly(n)) {
            return false;
        }
        if (WalkerFactory.walksExtraNodesOnly(n)) {
            return false;
        }
        return WalkerFactory.walksSubtree(n) && (WalkerFactory.walksSideways(n) || WalkerFactory.walksUp(n) || WalkerFactory.canSkipSubtrees(n));
    }

    public static boolean canSkipSubtrees(int n) {
        return WalkerFactory.isSet(n, 65536) | WalkerFactory.walksSideways(n);
    }

    private static StepPattern createDefaultStepPattern(Compiler compiler, int n, MatchPatternIterator matchPatternIterator, int n2, StepPattern stepPattern, StepPattern stepPattern2) throws TransformerException {
        int n3;
        int n4;
        int n5 = compiler.getOp(n);
        boolean bl = false;
        int n6 = n2 & 0xFF;
        boolean bl2 = true;
        int n7 = OpMap.getFirstChildPos(n);
        int n8 = compiler.getWhatToShow(n);
        StepPattern stepPattern3 = null;
        switch (n5) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                Expression expression;
                bl2 = false;
                switch (n5) {
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        expression = compiler.compile(n);
                        break;
                    }
                    default: {
                        expression = compiler.compile(n + 2);
                    }
                }
                n4 = 20;
                n3 = 20;
                stepPattern3 = new FunctionPattern(expression, n4, n3);
                bl = true;
                break;
            }
            case 50: {
                n8 = 1280;
                n4 = 19;
                n3 = 19;
                stepPattern3 = new StepPattern(1280, n4, n3);
                break;
            }
            case 39: {
                n8 = 2;
                n4 = 10;
                n3 = 2;
                break;
            }
            case 49: {
                n8 = 4096;
                n4 = 10;
                n3 = 9;
                break;
            }
            case 37: {
                n4 = 4;
                n3 = 0;
                break;
            }
            case 40: {
                n4 = 10;
                n3 = 3;
                break;
            }
            case 38: {
                n4 = 5;
                n3 = 1;
                break;
            }
            case 48: {
                n4 = 13;
                n3 = 13;
                break;
            }
            case 45: {
                n4 = 3;
                n3 = 10;
                break;
            }
            case 47: {
                n4 = 7;
                n3 = 12;
                break;
            }
            case 46: {
                n4 = 6;
                n3 = 11;
                break;
            }
            case 44: {
                n4 = 12;
                n3 = 7;
                break;
            }
            case 43: {
                n4 = 11;
                n3 = 6;
                break;
            }
            case 42: {
                n4 = 1;
                n3 = 5;
                break;
            }
            case 41: {
                n4 = 0;
                n3 = 4;
                break;
            }
            default: {
                throw new RuntimeException(XSLMessages.createXPATHMessage(75, new Object[]{Integer.toString(n5)}));
            }
        }
        if (stepPattern3 == null) {
            n8 = compiler.getWhatToShow(n);
            stepPattern3 = new StepPattern(n8, compiler.getStepNS(n), compiler.getStepLocalName(n), n4, n3);
        }
        int n9 = compiler.getFirstPredicateOpPos(n);
        stepPattern3.setPredicates(compiler.getCompiledPredicates(n9));
        return stepPattern3;
    }

    private static AxesWalker createDefaultWalker(Compiler compiler, int n, WalkingIterator walkingIterator, int n2) {
        AxesWalker axesWalker = null;
        int n3 = compiler.getOp(n);
        boolean bl = false;
        int n4 = n2 & 0xFF;
        boolean bl2 = true;
        switch (n3) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                bl2 = false;
                axesWalker = new FilterExprWalker(walkingIterator);
                bl = true;
                break;
            }
            case 50: {
                axesWalker = new AxesWalker(walkingIterator, 19);
                break;
            }
            case 37: {
                bl2 = false;
                axesWalker = new ReverseAxesWalker(walkingIterator, 0);
                break;
            }
            case 38: {
                bl2 = false;
                axesWalker = new ReverseAxesWalker(walkingIterator, 1);
                break;
            }
            case 39: {
                axesWalker = new AxesWalker(walkingIterator, 2);
                break;
            }
            case 49: {
                axesWalker = new AxesWalker(walkingIterator, 9);
                break;
            }
            case 40: {
                axesWalker = new AxesWalker(walkingIterator, 3);
                break;
            }
            case 41: {
                bl2 = false;
                axesWalker = new AxesWalker(walkingIterator, 4);
                break;
            }
            case 42: {
                bl2 = false;
                axesWalker = new AxesWalker(walkingIterator, 5);
                break;
            }
            case 43: {
                bl2 = false;
                axesWalker = new AxesWalker(walkingIterator, 6);
                break;
            }
            case 44: {
                bl2 = false;
                axesWalker = new AxesWalker(walkingIterator, 7);
                break;
            }
            case 46: {
                bl2 = false;
                axesWalker = new ReverseAxesWalker(walkingIterator, 11);
                break;
            }
            case 47: {
                bl2 = false;
                axesWalker = new ReverseAxesWalker(walkingIterator, 12);
                break;
            }
            case 45: {
                bl2 = false;
                axesWalker = new ReverseAxesWalker(walkingIterator, 10);
                break;
            }
            case 48: {
                axesWalker = new AxesWalker(walkingIterator, 13);
                break;
            }
            default: {
                throw new RuntimeException(XSLMessages.createXPATHMessage(75, new Object[]{Integer.toString(n3)}));
            }
        }
        if (bl) {
            axesWalker.initNodeTest(-1);
        } else {
            int n5 = compiler.getWhatToShow(n);
            if ((n5 & 0x1043) == 0 || n5 == -1) {
                axesWalker.initNodeTest(n5);
            } else {
                axesWalker.initNodeTest(n5, compiler.getStepNS(n), compiler.getStepLocalName(n));
            }
        }
        return axesWalker;
    }

    public static void diagnoseIterator(String string, int n, Compiler compiler) {
        System.out.println(String.valueOf(compiler.toString()) + ", " + string + ", " + Integer.toBinaryString(n) + ", " + WalkerFactory.getAnalysisString(n));
    }

    static boolean functionProximateOrContainsProximate(Compiler compiler, int n) {
        int n2 = n + compiler.getOp(n + 1) - 1;
        n = OpMap.getFirstChildPos(n);
        int n3 = compiler.getOp(n);
        switch (n3) {
            case 1: 
            case 2: {
                return true;
            }
        }
        int n4 = 0;
        int n5 = ++n;
        while (n5 < n2) {
            int n6 = n5 + 2;
            int n7 = compiler.getOp(n6);
            boolean bl = WalkerFactory.isProximateInnerExpr(compiler, n6);
            if (bl) {
                return true;
            }
            n5 = compiler.getNextOpPos(n5);
            ++n4;
        }
        return false;
    }

    public static String getAnalysisString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("count: " + WalkerFactory.getStepCount(n) + " ");
        if ((n & 0x40000000) != 0) {
            stringBuffer.append("NTANY|");
        }
        if ((n & 0x1000) != 0) {
            stringBuffer.append("PRED|");
        }
        if ((n & 0x2000) != 0) {
            stringBuffer.append("ANC|");
        }
        if ((n & 0x4000) != 0) {
            stringBuffer.append("ANCOS|");
        }
        if ((n & 0x8000) != 0) {
            stringBuffer.append("ATTR|");
        }
        if ((n & 0x10000) != 0) {
            stringBuffer.append("CH|");
        }
        if ((n & 0x20000) != 0) {
            stringBuffer.append("DESC|");
        }
        if ((n & 0x40000) != 0) {
            stringBuffer.append("DESCOS|");
        }
        if ((n & 0x80000) != 0) {
            stringBuffer.append("FOL|");
        }
        if ((n & 0x100000) != 0) {
            stringBuffer.append("FOLS|");
        }
        if ((n & 0x200000) != 0) {
            stringBuffer.append("NS|");
        }
        if ((n & 0x400000) != 0) {
            stringBuffer.append("P|");
        }
        if ((n & 0x800000) != 0) {
            stringBuffer.append("PREC|");
        }
        if ((n & 0x1000000) != 0) {
            stringBuffer.append("PRECS|");
        }
        if ((n & 0x2000000) != 0) {
            stringBuffer.append(".|");
        }
        if ((n & 0x4000000) != 0) {
            stringBuffer.append("FLT|");
        }
        if ((n & 0x8000000) != 0) {
            stringBuffer.append("R|");
        }
        return stringBuffer.toString();
    }

    public static int getAxisFromStep(Compiler compiler, int n) throws TransformerException {
        int[] nArray = compiler.getOpMap();
        int n2 = nArray[n];
        switch (n2) {
            case 43: {
                return 6;
            }
            case 44: {
                return 7;
            }
            case 46: {
                return 11;
            }
            case 47: {
                return 12;
            }
            case 45: {
                return 10;
            }
            case 49: {
                return 9;
            }
            case 37: {
                return 0;
            }
            case 38: {
                return 1;
            }
            case 39: {
                return 2;
            }
            case 50: {
                return 19;
            }
            case 40: {
                return 3;
            }
            case 42: {
                return 5;
            }
            case 41: {
                return 4;
            }
            case 48: {
                return 13;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return 20;
            }
        }
        throw new RuntimeException(XSLMessages.createXPATHMessage(75, new Object[]{Integer.toString(n2)}));
    }

    public static int getStepCount(int n) {
        return n & 0xFF;
    }

    public static boolean hasPredicate(int n) {
        return (n & 0x1000) != 0;
    }

    public static boolean isAbsolute(int n) {
        return WalkerFactory.isSet(n, 0xC000000);
    }

    public static boolean isDownwardAxisOfMany(int n) {
        return n == 5 || n == 4 || n == 6 || n == 11;
    }

    private static boolean isNaturalDocOrder(Compiler compiler, int n, int n2, int n3) throws TransformerException {
        int n4;
        if (WalkerFactory.canCrissCross(n3)) {
            return false;
        }
        if (WalkerFactory.isSet(n3, 0x200000)) {
            return false;
        }
        if (WalkerFactory.isSet(n3, 0x180000) && WalkerFactory.isSet(n3, 0x1800000)) {
            return false;
        }
        int[] nArray = compiler.getOpMap();
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        while ((n4 = nArray[n]) != -1) {
            int n7;
            ++n5;
            switch (n4) {
                case 39: 
                case 51: {
                    if (bl) {
                        return false;
                    }
                    String string = compiler.getStepLocalName(n);
                    if (!string.equals("*")) break;
                    bl = true;
                    break;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 37: 
                case 38: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 49: 
                case 52: 
                case 53: {
                    if (n6 > 0) {
                        return false;
                    }
                    ++n6;
                }
                case 40: 
                case 48: 
                case 50: {
                    if (!bl) break;
                    return false;
                }
                default: {
                    throw new RuntimeException(XSLMessages.createXPATHMessage(75, new Object[]{Integer.toString(n4)}));
                }
            }
            if ((n7 = compiler.getNextStepPos(n)) < 0) break;
            n = n7;
        }
        return true;
    }

    public static boolean isOneStep(int n) {
        return (n & 0xFF) == 1;
    }

    private static boolean isOptimizableForDescendantIterator(Compiler compiler, int n, int n2) throws TransformerException {
        int n3;
        int[] nArray = compiler.getOpMap();
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n5 = 1033;
        while ((n3 = nArray[n]) != -1) {
            if (n5 != 1033 && n5 != 35) {
                return false;
            }
            if (++n4 > 3) {
                return false;
            }
            boolean bl4 = WalkerFactory.mightBeProximate(compiler, n, n3);
            if (bl4) {
                return false;
            }
            switch (n3) {
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 37: 
                case 38: 
                case 39: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 49: 
                case 51: 
                case 52: 
                case 53: {
                    return false;
                }
                case 50: {
                    if (n4 == 1) break;
                    return false;
                }
                case 40: {
                    if (bl3 || bl && bl2) break;
                    return false;
                }
                case 42: {
                    bl3 = true;
                }
                case 41: {
                    if (n4 == 3) {
                        return false;
                    }
                    bl = true;
                    break;
                }
                case 48: {
                    if (n4 != 1) {
                        return false;
                    }
                    bl2 = true;
                    break;
                }
                default: {
                    throw new RuntimeException(XSLMessages.createXPATHMessage(75, new Object[]{Integer.toString(n3)}));
                }
            }
            n5 = compiler.getStepTestType(n);
            int n6 = compiler.getNextStepPos(n);
            if (n6 < 0) break;
            if (nArray[n6] != -1 && compiler.countPredicates(n) > 0) {
                return false;
            }
            n = n6;
        }
        return true;
    }

    static boolean isProximateInnerExpr(Compiler compiler, int n) {
        int n2 = compiler.getOp(n);
        int n3 = n + 2;
        switch (n2) {
            case 26: {
                if (!WalkerFactory.isProximateInnerExpr(compiler, n3)) break;
                return true;
            }
            case 25: {
                boolean bl = WalkerFactory.functionProximateOrContainsProximate(compiler, n);
                if (!bl) break;
                return true;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                int n4 = OpMap.getFirstChildPos(n2);
                int n5 = compiler.getNextOpPos(n4);
                boolean bl = WalkerFactory.isProximateInnerExpr(compiler, n4);
                if (bl) {
                    return true;
                }
                bl = WalkerFactory.isProximateInnerExpr(compiler, n5);
                if (!bl) break;
                return true;
            }
            default: {
                return true;
            }
            case 21: 
            case 22: 
            case 27: 
            case 28: 
        }
        return false;
    }

    public static boolean isSet(int n, int n2) {
        return (n & n2) != 0;
    }

    public static boolean isWild(int n) {
        return (n & 0x40000000) != 0;
    }

    static AxesWalker loadOneWalker(WalkingIterator walkingIterator, Compiler compiler, int n) throws TransformerException {
        AxesWalker axesWalker = null;
        int n2 = compiler.getOpMap()[n];
        if (n2 != -1) {
            axesWalker = WalkerFactory.createDefaultWalker(compiler, n2, walkingIterator, 0);
            axesWalker.init(compiler, n, n2);
        }
        return axesWalker;
    }

    static StepPattern loadSteps(MatchPatternIterator matchPatternIterator, Compiler compiler, int n, int n2) throws TransformerException {
        int n3;
        StepPattern stepPattern = null;
        StepPattern stepPattern2 = null;
        StepPattern stepPattern3 = null;
        int[] nArray = compiler.getOpMap();
        int n4 = WalkerFactory.analyze(compiler, n, n2);
        while ((n3 = nArray[n]) != -1) {
            stepPattern = WalkerFactory.createDefaultStepPattern(compiler, n, matchPatternIterator, n4, stepPattern2, stepPattern3);
            if (stepPattern2 == null) {
                stepPattern2 = stepPattern;
            } else {
                stepPattern.setRelativePathPattern(stepPattern3);
            }
            stepPattern3 = stepPattern;
            n = compiler.getNextStepPos(n);
            if (n < 0) break;
        }
        int n5 = 13;
        int n6 = 13;
        StepPattern stepPattern4 = stepPattern;
        StepPattern stepPattern5 = stepPattern;
        while (stepPattern5 != null) {
            int n7 = stepPattern5.getAxis();
            stepPattern5.setAxis(n5);
            int n8 = stepPattern5.getWhatToShow();
            if (n8 == 2 || n8 == 4096) {
                int n9;
                int n10 = n9 = n8 == 2 ? 2 : 9;
                if (WalkerFactory.isDownwardAxisOfMany(n5)) {
                    StepPattern stepPattern6 = new StepPattern(n8, stepPattern5.getNamespace(), stepPattern5.getLocalName(), n9, 0);
                    XNumber xNumber = stepPattern5.getStaticScore();
                    stepPattern5.setNamespace(null);
                    stepPattern5.setLocalName("*");
                    stepPattern6.setPredicates(stepPattern5.getPredicates());
                    stepPattern5.setPredicates(null);
                    stepPattern5.setWhatToShow(1);
                    StepPattern stepPattern7 = stepPattern5.getRelativePathPattern();
                    stepPattern5.setRelativePathPattern(stepPattern6);
                    stepPattern6.setRelativePathPattern(stepPattern7);
                    stepPattern6.setStaticScore(xNumber);
                    if (stepPattern5.getAxis() == 11) {
                        stepPattern5.setAxis(15);
                    } else if (stepPattern5.getAxis() == 4) {
                        stepPattern5.setAxis(5);
                    }
                    stepPattern5 = stepPattern6;
                } else if (stepPattern5.getAxis() == 3) {
                    stepPattern5.setAxis(2);
                }
            }
            n5 = n7;
            stepPattern4 = stepPattern5;
            stepPattern5 = stepPattern5.getRelativePathPattern();
        }
        if (n5 < 16) {
            ContextMatchStepPattern contextMatchStepPattern = new ContextMatchStepPattern(n5, n6);
            XNumber xNumber = stepPattern4.getStaticScore();
            stepPattern4.setRelativePathPattern(contextMatchStepPattern);
            stepPattern4.setStaticScore(xNumber);
            contextMatchStepPattern.setStaticScore(xNumber);
        }
        return stepPattern;
    }

    static AxesWalker loadWalkers(WalkingIterator walkingIterator, Compiler compiler, int n, int n2) throws TransformerException {
        int n3;
        AxesWalker axesWalker = null;
        AxesWalker axesWalker2 = null;
        int[] nArray = compiler.getOpMap();
        int n4 = WalkerFactory.analyze(compiler, n, n2);
        while ((n3 = nArray[n]) != -1) {
            AxesWalker axesWalker3 = WalkerFactory.createDefaultWalker(compiler, n, walkingIterator, n4);
            axesWalker3.init(compiler, n, n3);
            if (axesWalker == null) {
                axesWalker = axesWalker3;
            } else {
                axesWalker2.setNextWalker(axesWalker3);
                axesWalker3.setPrevWalker(axesWalker2);
            }
            axesWalker2 = axesWalker3;
            n = compiler.getNextStepPos(n);
            if (n < 0) break;
        }
        return axesWalker;
    }

    public static boolean mightBeProximate(Compiler compiler, int n, int n2) throws TransformerException {
        boolean bl = false;
        switch (n2) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                int n3 = compiler.getArgLength(n);
                break;
            }
            default: {
                int n3 = compiler.getArgLengthOfStep(n);
            }
        }
        int n4 = compiler.getFirstPredicateOpPos(n);
        int n5 = 0;
        while (compiler.getOp(n4) == 29) {
            ++n5;
            int n6 = n4 + 2;
            int n7 = compiler.getOp(n6);
            switch (n7) {
                case 19: 
                case 27: {
                    return true;
                }
                case 25: {
                    boolean bl2 = WalkerFactory.functionProximateOrContainsProximate(compiler, n6);
                    if (!bl2) break;
                    return true;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    int n8 = OpMap.getFirstChildPos(n6);
                    int n9 = compiler.getNextOpPos(n8);
                    boolean bl2 = WalkerFactory.isProximateInnerExpr(compiler, n8);
                    if (bl2) {
                        return true;
                    }
                    bl2 = WalkerFactory.isProximateInnerExpr(compiler, n9);
                    if (!bl2) break;
                    return true;
                }
                default: {
                    return true;
                }
                case 22: 
                case 28: 
            }
            n4 = compiler.getNextOpPos(n4);
        }
        return bl;
    }

    public static DTMIterator newDTMIterator(Compiler compiler, int n, boolean bl) throws TransformerException {
        int n2 = OpMap.getFirstChildPos(n);
        int n3 = WalkerFactory.analyze(compiler, n2, 0);
        boolean bl2 = WalkerFactory.isOneStep(n3);
        LocPathIterator locPathIterator = bl2 && WalkerFactory.walksSelfOnly(n3) && WalkerFactory.isWild(n3) && !WalkerFactory.hasPredicate(n3) ? new SelfIteratorNoPredicate(compiler, n, n3) : (WalkerFactory.walksChildrenOnly(n3) && bl2 ? (WalkerFactory.isWild(n3) && !WalkerFactory.hasPredicate(n3) ? new ChildIterator(compiler, n, n3) : new ChildTestIterator(compiler, n, n3)) : (bl2 && WalkerFactory.walksAttributes(n3) ? new AttributeIterator(compiler, n, n3) : (bl2 && !WalkerFactory.walksFilteredList(n3) ? (!WalkerFactory.walksNamespaces(n3) && (WalkerFactory.walksInDocOrder(n3) || WalkerFactory.isSet(n3, 0x400000)) ? new OneStepIteratorForward(compiler, n, n3) : new OneStepIterator(compiler, n, n3)) : (WalkerFactory.isOptimizableForDescendantIterator(compiler, n2, 0) ? new DescendantIterator(compiler, n, n3) : (WalkerFactory.isNaturalDocOrder(compiler, n2, 0, n3) ? new WalkingIterator(compiler, n, n3, true) : new WalkingIteratorSorted(compiler, n, n3, true))))));
        if (locPathIterator instanceof LocPathIterator) {
            ((LocPathIterator)locPathIterator).setIsTopLevel(bl);
        }
        return locPathIterator;
    }

    public static boolean walksAncestors(int n) {
        return WalkerFactory.isSet(n, 24576);
    }

    public static boolean walksAttributes(int n) {
        return (n & 0x8000) != 0;
    }

    public static boolean walksChildren(int n) {
        return (n & 0x10000) != 0;
    }

    public static boolean walksChildrenAndExtraAndSelfOnly(int n) {
        return WalkerFactory.walksChildren(n) && !WalkerFactory.walksDescendants(n) && !WalkerFactory.walksUp(n) && !WalkerFactory.walksSideways(n) && !WalkerFactory.isAbsolute(n);
    }

    public static boolean walksChildrenOnly(int n) {
        return WalkerFactory.walksChildren(n) && !WalkerFactory.isSet(n, 0x2000000) && !WalkerFactory.walksExtraNodes(n) && !WalkerFactory.walksDescendants(n) && !WalkerFactory.walksUp(n) && !WalkerFactory.walksSideways(n) && !WalkerFactory.isAbsolute(n);
    }

    public static boolean walksDescendants(int n) {
        return WalkerFactory.isSet(n, 393216);
    }

    public static boolean walksDescendantsAndExtraAndSelfOnly(int n) {
        return !WalkerFactory.walksChildren(n) && WalkerFactory.walksDescendants(n) && !WalkerFactory.walksUp(n) && !WalkerFactory.walksSideways(n) && !WalkerFactory.isAbsolute(n);
    }

    public static boolean walksDownExtraOnly(int n) {
        return WalkerFactory.walksSubtree(n) && WalkerFactory.walksExtraNodes(n) && !WalkerFactory.walksUp(n) && !WalkerFactory.walksSideways(n) && !WalkerFactory.isAbsolute(n);
    }

    public static boolean walksDownOnly(int n) {
        return WalkerFactory.walksSubtree(n) && !WalkerFactory.walksUp(n) && !WalkerFactory.walksSideways(n) && !WalkerFactory.isAbsolute(n);
    }

    public static boolean walksExtraNodes(int n) {
        return WalkerFactory.isSet(n, 0x208000);
    }

    public static boolean walksExtraNodesOnly(int n) {
        return WalkerFactory.walksExtraNodes(n) && !WalkerFactory.isSet(n, 0x2000000) && !WalkerFactory.walksSubtree(n) && !WalkerFactory.walksUp(n) && !WalkerFactory.walksSideways(n) && !WalkerFactory.isAbsolute(n);
    }

    public static boolean walksFilteredList(int n) {
        return WalkerFactory.isSet(n, 0x4000000);
    }

    public static boolean walksInDocOrder(int n) {
        return (WalkerFactory.walksSubtree(n) || WalkerFactory.walksExtraNodes(n) || WalkerFactory.isSet(n, 35127296)) && !WalkerFactory.walksUp(n) && !WalkerFactory.isSet(n, 0x1800000) && !WalkerFactory.isSet(n, 0x4000000);
    }

    public static boolean walksNamespaces(int n) {
        return (n & 0x200000) != 0;
    }

    public static boolean walksSelfOnly(int n) {
        return WalkerFactory.isSet(n, 0x2000000) && !WalkerFactory.walksSubtree(n) && !WalkerFactory.walksUp(n) && !WalkerFactory.walksSideways(n) && !WalkerFactory.isAbsolute(n);
    }

    public static boolean walksSideways(int n) {
        return WalkerFactory.isSet(n, 26738688);
    }

    public static boolean walksSubtree(int n) {
        return WalkerFactory.isSet(n, 458752);
    }

    public static boolean walksSubtreeOnly(int n) {
        return WalkerFactory.walksSubtree(n) && !WalkerFactory.walksExtraNodes(n) && !WalkerFactory.walksUp(n) && !WalkerFactory.walksSideways(n) && !WalkerFactory.isAbsolute(n);
    }

    public static boolean walksSubtreeOnlyFromRootOrContext(int n) {
        return WalkerFactory.walksSubtree(n) && !WalkerFactory.walksExtraNodes(n) && !WalkerFactory.walksUp(n) && !WalkerFactory.walksSideways(n) && !WalkerFactory.isSet(n, 0x4000000);
    }

    public static boolean walksUp(int n) {
        return WalkerFactory.isSet(n, 0x406000);
    }

    public static boolean walksUpOnly(int n) {
        return !WalkerFactory.walksSubtree(n) && WalkerFactory.walksUp(n) && !WalkerFactory.walksSideways(n) && !WalkerFactory.isAbsolute(n);
    }
}

