// This file may be redistributed and modified only under the terms of
// the GNU General Public License (See COPYING for details).
// Copyright (C) 2000,2001 Alistair Riddoch

#ifndef SERVER_THING_FACTORY_H
#define SERVER_THING_FACTORY_H

#include <Atlas/Message/Element.h>

class Entity;

template <class T>
class Persistor;

class PersistorBase {
  public:
    virtual ~PersistorBase() { }

    virtual void persist() = 0;
};

template <class T>
class PersistorConnection : public PersistorBase {
  private:
    T & m_t;
    Persistor<T> & m_p;
  public:
    PersistorConnection(T & t, Persistor<T> & p) : m_t(t), m_p(p) { }

    /// Use p to hook up t into the persistance code
    void persist();
};

class FactoryBase {
  public:
    std::string m_script;
    std::string m_language;
    Atlas::Message::MapType m_attributes;

    virtual ~FactoryBase() { }

    virtual Entity * newThing(const std::string & id) = 0;
    virtual Entity * newPersistantThing(const std::string & id, PersistorBase **) = 0;
    virtual FactoryBase * duplicateFactory() = 0;
};

// How do we make sure the peristance hooks are put in place in a typesafe way
// but after all the initial attribute have been set.

template <class T>
class PersistantThingFactory : public FactoryBase {
  public:
    Persistor<T> & m_p;

    PersistantThingFactory() : m_p(* new Persistor<T>()) { }
    PersistantThingFactory(PersistantThingFactory<T> & p) : m_p(p.m_p) { }

    T * newThing(const std::string & id);
    T * newPersistantThing(const std::string & id, PersistorBase ** p);
    FactoryBase * duplicateFactory();
};

#endif // SERVER_THING_FACTORY_H
