/* 
 * tileset.h
 *
 * crafted - a pud editor for the freecraft project.
 * 
 * Copyright (C) 2001-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TILESET_H__
#define __TILESET_H__

#include <gtk/gtk.h>

typedef enum
{
  LIGHT_WATER       =  1,
  DARK_WATER        =  2,
  LIGHT_COAST       =  3,
  DARK_COAST        =  4,
  LIGHT_GRASS       =  5,
  DARK_GRASS        =  6,
  FOREST            =  7,
  ROCKS             =  8,
  HUMAN_CLOSED_WALL =  9,
  ORC_CLOSED_WALL   = 10,
  HUMAN_OPEN_WALL   = 11,
  ORC_OPEN_WALL     = 12,
  BRIDGE	    = 13,
  ROAD	    	    = 14,
  FORD	    	    = 15,
  LAST_SOLID_TILE   = 16
} SolidTileType;

extern guint16 solid_tiles[LAST_SOLID_TILE][16];

typedef enum
{
  DARK_WATER_LIGHT_WATER  = 1,
  LIGHT_WATER_LIGHT_COAST = 2,
  DARK_COAST_LIGHT_COAST  = 3,
  ROCKS_LIGHT_COAST       = 4,
  LIGHT_COAST_LIGHT_GRASS = 5,
  DARK_GRASS_LIGHT_GRASS  = 6,
  FOREST_LIGHT_GRASS      = 7,
  HUMAN_WALL_DARK_GRASS   = 8,
  ORC_WALL_DARK_GRASS     = 9,
  BRIDGE_LIGHT_COAST	  = 10,
  ROAD_LIGHT_GRASS	  = 11,
  FORD_LIGHT_COAST	  = 12,
  LAST_MIXED_TILE	  = 13
} MixedTileType;

extern guint16 mixed_tiles[LAST_MIXED_TILE][256];

void load_tileset(gint terrain);

#endif /* __TILESET_H__ */
