/**** EXAMPLE SPECIFIC SECTION ****************************/

#define ARGS 1
#include "fft.h"
extern double applyfft_res();
int q; int iter;
#define READARGS     q = atoi(argv[1]); \
                     generate_data(q);
#define CALLSOURCE   applyfft    ()
#define CALLRESID    applyfft_res()
#define FORMATRESULT "%g"

/**** END OF EXAMPLE SPECIFIC SECTION *********************/

#include <sys/times.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char* argv[]) {
  if (argc < ARGS + 2) {
    fprintf(stderr, "Usage: %s repeat arg1 ... arg%d\n", argv[0], ARGS);
    return -1;
  } else {
    struct tms tsourcestart, tsourcestop, tresstart, tresstop;
    double tsourceuser, tsourcesys, tresuser, tressys;
    long clk_tck;
    int i, repeat;
    repeat = atoi(argv[1]); argv++;
    READARGS;
    fprintf(stderr, "Timing source program...\n");
    times(&tsourcestart);
    for (i = 0; i < repeat; i++) CALLSOURCE;
    times(&tsourcestop);
    printf("Source   result: " FORMATRESULT "\n", CALLSOURCE);
    fprintf(stderr, "Timing residual program...\n");
    times(&tresstart);
    for (i = 0; i < repeat; i++) CALLRESID;
    times(&tresstop);
    printf("Residual result: " FORMATRESULT "\n", CALLRESID);
    fprintf(stderr, "Done.\n");
    clk_tck = sysconf(_SC_CLK_TCK);
    tsourceuser = (double)(tsourcestop.tms_utime - tsourcestart.tms_utime) /
      (double)clk_tck;
    tsourcesys = (double)(tsourcestop.tms_stime - tsourcestart.tms_stime) /
      (double)clk_tck;
    tresuser = (double)(tresstop.tms_utime - tresstart.tms_utime) /
      (double)clk_tck;
    tressys = (double)(tresstop.tms_stime - tresstart.tms_stime) /
      (double)clk_tck;
    printf("\n                  User time       (System time   )\n");
    printf("Source   program  %6.5g seconds  (%6.5g seconds)\n",
	   tsourceuser, tsourcesys);
    printf("Residual program  %6.5g seconds  (%6.5g seconds)\n",
	   tresuser, tressys);
    printf("Speedup factor    %6.1f          (%6.1f        )\n",
	   tresuser == 0.0 ? 1.0 : tsourceuser / tresuser,
	   tressys == 0.0 ? 1.0 : tsourcesys / tressys);
  }
  return 0;
}
