;;; learning/domains/restaurant-real.lisp
;;; Restaurant example from chapter 18, encoded
;;; using real-valued input attributes suitable for
;;; decision-tree learning or neural network learning.

(defvar *restaurant-real* 
    '((patrons 0 0.5 1)
      (0 . 0)
      (0.5 . 1)
      (1 
       (waitestimate 1 0.5 0.17 0)
       (1 . 0)
       (0.5
	(alternate 1 0)
	(1
	 (fri/sat 1 0)
	 (0 . 0)
	 (1 . 1))
	(0
	 (reservation 1 0)
	 (0 
	  (bar 1 0)
	  (0 . 0)
	  (1 . 1))
	 (1 . 1)))
       (0.17
	(hungry 1 0)
	(0 . 1)
	(1
	 (alternate 1 0)
	 (0 . 1)
	 (1
	  (raining 1 0)
	  (0 . 0)
	  (1 . 1))))
       (0 . 1))))

(defvar *restaurant-real12-problem*)

(setq *restaurant-real12-problem*
      (make-learning-problem
       :attributes '((alternate 1 0)
                     (bar 1 0)
                     (fri/sat 1 0)
                     (hungry 1 0)
                     (patrons 0 0.5 1) ;; none some full
                     (price 0 0.5 1)
                     (raining 1 0)
                     (reservation 1 0)
                     (type 1 0.67 0.33 0)  ;; french italian thai burger
                     (waitestimate 0 0.17 0.5 1))  ;; >= 0 10 30 60 minutes
       :goals      '((willwait 1 0))
       :examples   '(((willwait . 1) (alternate . 1)  (bar . 0)  (fri/sat . 0)  
                      (hungry . 1)  (patrons . 0.5)  (price . 1)  (raining . 0)  
                      (reservation . 1)  (type . 1)   (waitestimate . 0)   )
                     ((willwait . 0) (alternate . 1)  (bar . 0)  (fri/sat . 0)  
                      (hungry . 1)  (patrons . 1)  (price . 0)  (raining . 0)  
                      (reservation . 0)  (type . 0.33)   (waitestimate . 0.5)   )
                     ((willwait . 1) (alternate . 0)  (bar . 1)  (fri/sat . 0)  
                      (hungry . 0)  (patrons . 0.5)  (price . 0)  (raining . 0)  
                      (reservation . 0)  (type . 0)   (waitestimate . 0)   )
                     ((willwait . 1) (alternate . 1)  (bar . 0)  (fri/sat . 1)  
                      (hungry . 1)  (patrons . 1)  (price . 0)  (raining . 0)  
                      (reservation . 0)  (type . 0.33)   (waitestimate . 0.17)   )
                     ((willwait . 0) (alternate . 1)  (bar . 0)  (fri/sat . 1)  
                      (hungry . 0)  (patrons . 1)  (price . 1)  (raining . 0)  
                      (reservation . 1)  (type . 1)   (waitestimate . 1)   )
                     ((willwait . 1) (alternate . 0)  (bar . 1)  (fri/sat . 0)  
                      (hungry . 1)  (patrons . 0.5)  (price . 0.5)  (raining . 1)  
                      (reservation . 1)  (type . 0.67)   (waitestimate . 0)   )
                     ((willwait . 0) (alternate . 0)  (bar . 1)  (fri/sat . 0)  
                      (hungry . 0)  (patrons . 0)  (price . 0)  (raining . 1)  
                      (reservation . 0)  (type . 0)   (waitestimate . 0)   )
                     ((willwait . 1) (alternate . 0)  (bar . 0)  (fri/sat . 0)  
                      (hungry . 1)  (patrons . 0.5)  (price . 0.5)  (raining . 1)  
                      (reservation . 1)  (type . 0.33)   (waitestimate . 0)   )
                     ((willwait . 0) (alternate . 0)  (bar . 1)  (fri/sat . 1)  
                      (hungry . 0)  (patrons . 1)  (price . 0)  (raining . 1)  
                      (reservation . 0)  (type . 0)   (waitestimate . 1)   )
                     ((willwait . 0) (alternate . 1)  (bar . 1)  (fri/sat . 1)  
                      (hungry . 1)  (patrons . 1)  (price . 1)  (raining . 0)  
                      (reservation . 1)  (type . 0.67)   (waitestimate . 0.17)   )
                     ((willwait . 0) (alternate . 0)  (bar . 0)  (fri/sat . 0)  
                      (hungry . 0)  (patrons . 0)  (price . 0)  (raining . 0)  
                      (reservation . 0)  (type . 0.33)   (waitestimate . 0)   )
                     ((willwait . 1) (alternate . 1)  (bar . 1)  (fri/sat . 1)  
                      (hungry . 1)  (patrons . 1)  (price . 0)  (raining . 0)  
                      (reservation . 0)  (type . 0)   (waitestimate . 0.5)   ))))


(defvar *restaurant-real100-problem*)

(setq *restaurant-real100-problem*
      (make-learning-problem
       :attributes '((alternate 1 0)
                     (bar 1 0)
                     (fri/sat 1 0)
                     (hungry 1 0)
                     (patrons 0 0.5 1) ;; none some full
                     (price 0 0.5 1)
                     (raining 1 0)
                     (reservation 1 0)
                     (type 1 0.67 0.33 0)  ;; french italian thai burger
                     (waitestimate 0 0.17 0.5 1))  ;; >= 0 10 30 60 minutes
       :goals      '((willwait 1 0))
       :examples   '(
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0) (PRICE . 1) (RAINING . 0) (RESERVATION . 1) (TYPE . 0.33) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 1) (RAINING . 0) (RESERVATION . 0) (TYPE . 0.33) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 0.5) (RAINING . 0) (RESERVATION . 0) (TYPE . 0.33) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 0) (RAINING . 1) (RESERVATION . 0) (TYPE . 0.67) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 0) (PRICE . 1) (RAINING . 0) (RESERVATION . 0) (TYPE . 1) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 1) (PRICE . 1) (RAINING . 1) (RESERVATION . 0) (TYPE . 0) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0) (PRICE . 1) (RAINING . 0) (RESERVATION . 1) (TYPE . 1) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 1) (PRICE . 1) (RAINING . 0) (RESERVATION . 0) (TYPE . 0.33) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 1) (RAINING . 0) (RESERVATION . 1) (TYPE . 0) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0) (PRICE . 1) (RAINING . 0) (RESERVATION . 1) (TYPE . 0) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 1) (PRICE . 1) (RAINING . 0) (RESERVATION . 0) (TYPE . 0) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 1) (PRICE . 0) (RAINING . 1) (RESERVATION . 1) (TYPE . 1) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 0.5) (RAINING . 1) (RESERVATION . 0) (TYPE . 0.67) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 1) (RAINING . 0) (RESERVATION . 1) (TYPE . 0) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 1) (PRICE . 0.5) (RAINING . 1) (RESERVATION . 0) (TYPE . 0) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0) (PRICE . 0.5) (RAINING . 1) (RESERVATION . 1) (TYPE . 1) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 0.5) (PRICE . 0) (RAINING . 1) (RESERVATION . 1) (TYPE . 0.33) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 0) (RAINING . 0) (RESERVATION . 1) (TYPE . 0.33) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 1) (PRICE . 0) (RAINING . 0) (RESERVATION . 0) (TYPE . 0.33) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 0.5) (PRICE . 0.5) (RAINING . 1) (RESERVATION . 1) (TYPE . 0) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 1) (PRICE . 1) (RAINING . 0) (RESERVATION . 0) (TYPE . 0) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 0.5) (PRICE . 0) (RAINING . 1) (RESERVATION . 1) (TYPE . 0.33) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 1) (PRICE . 1) (RAINING . 1) (RESERVATION . 1) (TYPE . 1) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 0) (PRICE . 1) (RAINING . 1) (RESERVATION . 0) (TYPE . 0) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 0) (PRICE . 0.5) (RAINING . 0) (RESERVATION . 0) (TYPE . 0.33) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 0.5) (RAINING . 0) (RESERVATION . 0) (TYPE . 0.33) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 0.5) (PRICE . 0) (RAINING . 1) (RESERVATION . 0) (TYPE . 0.33) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 1) (PRICE . 0.5) (RAINING . 1) (RESERVATION . 1) (TYPE . 1) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0) (PRICE . 1) (RAINING . 0) (RESERVATION . 1) (TYPE . 1) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 1) (PRICE . 0) (RAINING . 1) (RESERVATION . 1) (TYPE . 0) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 0) (RAINING . 0) (RESERVATION . 1) (TYPE . 1) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 1) (PRICE . 1) (RAINING . 0) (RESERVATION . 1) (TYPE . 1) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0) (PRICE . 0.5) (RAINING . 1) (RESERVATION . 1) (TYPE . 1) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 0) (PRICE . 0.5) (RAINING . 1) (RESERVATION . 1) (TYPE . 0.67) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0) (PRICE . 1) (RAINING . 0) (RESERVATION . 1) (TYPE . 1) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 1) (PRICE . 0) (RAINING . 0) (RESERVATION . 0) (TYPE . 0) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 1) (PRICE . 1) (RAINING . 1) (RESERVATION . 1) (TYPE . 0.33) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 0) (PRICE . 0) (RAINING . 1) (RESERVATION . 0) (TYPE . 0.67) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 0) (PRICE . 1) (RAINING . 1) (RESERVATION . 0) (TYPE . 0.33) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 0) (PRICE . 1) (RAINING . 0) (RESERVATION . 0) (TYPE . 1) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0) (PRICE . 0) (RAINING . 1) (RESERVATION . 1) (TYPE . 1) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 0) (PRICE . 1) (RAINING . 0) (RESERVATION . 0) (TYPE . 0) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 1) (PRICE . 0) (RAINING . 1) (RESERVATION . 1) (TYPE . 0.67) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 1) (PRICE . 1) (RAINING . 1) (RESERVATION . 0) (TYPE . 0.33) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 1) (PRICE . 1) (RAINING . 0) (RESERVATION . 1) (TYPE . 0) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 1) (PRICE . 0) (RAINING . 1) (RESERVATION . 1) (TYPE . 0) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 1) (PRICE . 1) (RAINING . 0) (RESERVATION . 1) (TYPE . 1) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 0.5) (RAINING . 0) (RESERVATION . 0) (TYPE . 1) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 0.5) (RAINING . 1) (RESERVATION . 1) (TYPE . 0) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 1) (PRICE . 1) (RAINING . 0) (RESERVATION . 0) (TYPE . 0) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 1) (PRICE . 0) (RAINING . 0) (RESERVATION . 0) (TYPE . 0) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 0) (PRICE . 0.5) (RAINING . 1) (RESERVATION . 0) (TYPE . 1) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 0) (RAINING . 1) (RESERVATION . 1) (TYPE . 0.33) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 0.5) (RAINING . 1) (RESERVATION . 0) (TYPE . 0) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 0) (PRICE . 0.5) (RAINING . 1) (RESERVATION . 0) (TYPE . 0.33) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 1) (PRICE . 0) (RAINING . 1) (RESERVATION . 0) (TYPE . 0) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 1) (PRICE . 0.5) (RAINING . 0) (RESERVATION . 0) (TYPE . 0) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0) (PRICE . 0) (RAINING . 0) (RESERVATION . 1) (TYPE . 0.67) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 0) (PRICE . 1) (RAINING . 1) (RESERVATION . 1) (TYPE . 0) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 0.5) (PRICE . 0) (RAINING . 1) (RESERVATION . 0) (TYPE . 1) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 1) (PRICE . 0.5) (RAINING . 1) (RESERVATION . 0) (TYPE . 0) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 0.5) (PRICE . 0.5) (RAINING . 1) (RESERVATION . 1) (TYPE . 0.67) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 1) (PRICE . 0.5) (RAINING . 1) (RESERVATION . 0) (TYPE . 0.67) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 0) (RAINING . 1) (RESERVATION . 0) (TYPE . 0.33) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0) (PRICE . 0) (RAINING . 1) (RESERVATION . 1) (TYPE . 0.33) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 0.5) (PRICE . 0.5) (RAINING . 0) (RESERVATION . 0) (TYPE . 1) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 1) (PRICE . 1) (RAINING . 1) (RESERVATION . 0) (TYPE . 1) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 0.5) (RAINING . 0) (RESERVATION . 0) (TYPE . 0.67) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 0) (PRICE . 1) (RAINING . 0) (RESERVATION . 1) (TYPE . 0.67) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 1) (PRICE . 1) (RAINING . 0) (RESERVATION . 0) (TYPE . 0.67) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 1) (PRICE . 0) (RAINING . 0) (RESERVATION . 0) (TYPE . 0.67) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 1) (RAINING . 0) (RESERVATION . 0) (TYPE . 0.67) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 0) (PRICE . 0) (RAINING . 0) (RESERVATION . 0) (TYPE . 0) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 1) (PRICE . 1) (RAINING . 0) (RESERVATION . 1) (TYPE . 1) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 0) (RAINING . 1) (RESERVATION . 1) (TYPE . 0.67) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 0) (RAINING . 0) (RESERVATION . 0) (TYPE . 0.67) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 0) (PRICE . 0) (RAINING . 0) (RESERVATION . 1) (TYPE . 0.67) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 1) (PRICE . 0) (RAINING . 1) (RESERVATION . 0) (TYPE . 0.67) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 0) (RAINING . 0) (RESERVATION . 1) (TYPE . 1) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0) (PRICE . 0.5) (RAINING . 0) (RESERVATION . 1) (TYPE . 0.67) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 0) (PRICE . 1) (RAINING . 0) (RESERVATION . 1) (TYPE . 0.67) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0) (PRICE . 0.5) (RAINING . 0) (RESERVATION . 0) (TYPE . 0.67) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 0.5) (PRICE . 0) (RAINING . 0) (RESERVATION . 0) (TYPE . 0.67) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 1) (RAINING . 0) (RESERVATION . 1) (TYPE . 0.33) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 0) (PRICE . 0.5) (RAINING . 0) (RESERVATION . 1) (TYPE . 0.67) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 0) (PRICE . 0) (RAINING . 1) (RESERVATION . 0) (TYPE . 0.33) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 0.5) (PRICE . 0) (RAINING . 1) (RESERVATION . 1) (TYPE . 0.33) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 0) (PRICE . 0.5) (RAINING . 0) (RESERVATION . 0) (TYPE . 0.67) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 0) (PATRONS . 0.5) (PRICE . 0) (RAINING . 1) (RESERVATION . 1) (TYPE . 0.33) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 1) (PRICE . 1) (RAINING . 0) (RESERVATION . 0) (TYPE . 0) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 1) (PRICE . 0) (RAINING . 1) (RESERVATION . 0) (TYPE . 0.67) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 1) (RAINING . 0) (RESERVATION . 0) (TYPE . 1) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0.5) (PRICE . 1) (RAINING . 1) (RESERVATION . 0) (TYPE . 0) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 0) (PRICE . 0.5) (RAINING . 0) (RESERVATION . 0) (TYPE . 1) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 1) (PRICE . 0.5) (RAINING . 0) (RESERVATION . 0) (TYPE . 1) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 1) (ALTERNATE . 0) (BAR . 0) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 0.5) (PRICE . 1) (RAINING . 1) (RESERVATION . 0) (TYPE . 0.33) (WAITESTIMATE . 1)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 0) (PRICE . 0) (RAINING . 0) (RESERVATION . 0) (TYPE . 0.67) (WAITESTIMATE . 0)) 
  ((WILLWAIT . 1) (ALTERNATE . 1) (BAR . 0) (FRI/SAT . 1) (HUNGRY . 1) (PATRONS . 1) (PRICE . 0.5) (RAINING . 0) (RESERVATION . 1) (TYPE . 0.67) (WAITESTIMATE . 0.5)) 
  ((WILLWAIT . 0) (ALTERNATE . 0) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 0) (PATRONS . 1) (PRICE . 0.5) (RAINING . 1) (RESERVATION . 0) (TYPE . 1) (WAITESTIMATE . 0.17)) 
  ((WILLWAIT . 0) (ALTERNATE . 1) (BAR . 1) (FRI/SAT . 0) (HUNGRY . 1) (PATRONS . 0) (PRICE . 1) (RAINING . 0) (RESERVATION . 1) (TYPE . 0) (WAITESTIMATE . 0.17)) 
  )))
