/*
**  main.m for CddbTest.app
**
**  Copyright (c) 2002
**
**  Author: Yen-Ju  <yjchenx@yahoo.com.tw>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>
#import <Cddb/Cddb.h>

int main(int argc, const char **argv)
{
  NSAutoreleasePool *pool;
  Cddb *cddb;
  id result;
  Class bundleClass;
  NSBundle *bundle;
  NSString *bundlePath;
  NSWindow *window;

  pool = [NSAutoreleasePool new];

  bundlePath = [NSString stringWithFormat: @"%@/Bundles/Cddb.bundle",
                      [NSSearchPathForDirectoriesInDomains(NSLibraryDirectory,
                                                           NSLocalDomainMask,
                                                           YES)
                                                          objectAtIndex:0] ];
  bundle = [NSBundle bundleWithPath: bundlePath];
  if (bundle)
    {
      bundleClass = [bundle principalClass];
      if (bundleClass)
        {
          cddb = [bundleClass new];
        }
      else
        {
          NSLog(@"Failed to get Class from Cddb.bundle");
          return 0;
        }
    }
  else
    {
      NSLog(@"Failed to get Cddb.bundle");
      return 0;
    }

   
//   [cddb setDefaultSite: @"http://www.freedb.org:80/~cddb/cddb.cgi"];

   if([cddb connect]) {
     int i;
     id object;

     NSLog(@"site: %@", [cddb defaultSite]);

     NSLog(@"FreeDB version:%@", [cddb version]);

/*
     object = [cddb sites];
     for(i = 0; i < [object count]; i++) {
       NSLog(@"%@ %@ %@ %@ at %@",
                         [[object objectAtIndex: i] objectForKey: @"site"],
                         [[object objectAtIndex: i] objectForKey: @"protocol"],
                         [[object objectAtIndex: i] objectForKey: @"port"],
                         [[object objectAtIndex: i] objectForKey: @"address"],
                         [[object objectAtIndex: i] objectForKey: @"description"]);
     }
*/
/*
     NSLog(@"Disc ID is %@", [cddb discid: @"3 150 202227 326942 4721"]);
     NSLog(@"Category:\n%@", [cddb category]);
     NSLog(@"Current level %d", [cddb proto]);
*/
//     NSLog(@"Set level to %d", [cddb proto: 5]);
     /* Multiple exact match */   
     NSLog(@"Query:\n%@", [cddb query: @"e011c210 16 182 10797 16160 24297 31017 40187 58922 96737 119315 176925 204105 216385 227215 258642 291035 305657 4548"]);

     /* Not exact match */
//     NSLog(@"Query:\n%@", [cddb query: @"cf0a19qe 14 150 17677 29912 44045 57455 73122 96812 108380 119995 132665 143302 155250 166757 176672 2587"]);

     /* Multiple EXTD line */
//     NSLog(@"Read:\n%@", [cddb read: @"classical e011c210"]);

     /* Single EXTD line */
//     NSLog(@"READ:\n%@", [cddb read: @"jazz 2e126f03"]);

//     NSLog(@"Query:\n%@", [cddb query: @"fe0fa612 18 183 13008 32408 44795 59858 75495 85045 101845 119808 134033 156533 174108 189120 220670 241295 250670 266295 289158 4008"]);

//     NSLog(@"Read:\n%@", [cddb read: @"classical fe0fa612"]);

     [cddb disconnect];
   }

   NSLog(@"FreeDB disconnected");
   RELEASE(cddb);
   NSLog(@"FreeDB released");
   RELEASE(pool);
   return 0;
}

