open Printf
open Pp

let end_of_lex l =
  try Parser.ugly_eof (fun _ -> failwith "ugly") l; true
  with _ -> false

let _ =
  if not !Sys.interactive then
  try
    let lexbuf = Lexing.from_channel stdin in
    while not (end_of_lex lexbuf) do
      let result = Parser.full_select Lexer.token lexbuf in
      let p = make_pp_full_select result in
      printf "%s\n" (pp_concr 2 None p);
      flush stdout
    done
  with e -> 
    printf "%s\n" (Printexc.to_string e)
